/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.scheduler.internal;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.scheduler.internal.node.AbstractNode;
import org.eclipse.scout.rt.server.scheduler.internal.node.ArgRef;
import org.eclipse.scout.rt.server.scheduler.internal.node.BooleanAtom;
import org.eclipse.scout.rt.server.scheduler.internal.node.FormulaRoot;
import org.eclipse.scout.rt.server.scheduler.internal.node.INode;
import org.eclipse.scout.rt.server.scheduler.internal.node.IntegerAtom;
import org.eclipse.scout.rt.server.scheduler.internal.node.NotToken;
import org.eclipse.scout.rt.server.scheduler.internal.node.NullAtom;
import org.eclipse.scout.rt.server.scheduler.internal.node.Op;
import org.eclipse.scout.rt.server.scheduler.internal.node.SignalRef;
import org.eclipse.scout.rt.server.scheduler.internal.node.StringAtom;
import org.eclipse.scout.rt.server.scheduler.internal.node.WrappedToken;

public class FormulaParser {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(FormulaParser.class);
    private static final String S_MAP = " \n\t\r";
    private String str;
    private ParsePosition pos;

    public FormulaRoot parse(String formula) throws ParseException {
        FormulaRoot root;
        this.str = formula;
        if (this.str != null) {
            this.str = this.str.trim();
        }
        if (this.str == null || this.str.length() == 0) {
            root = new FormulaRoot(new NullAtom());
        } else {
            this.pos = new ParsePosition(0);
            try {
                INode t = this.parseToken(0);
                if (t == null) {
                    throw new ParseException("no node parsed", this.pos.getIndex());
                }
                if (this.pos.getIndex() < this.str.length()) {
                    throw new ParseException("formula not fully parsed (index " + this.pos.getIndex() + " of " + this.str.length() + ") : " + formula, this.pos.getIndex());
                }
                root = new FormulaRoot(t);
            }
            catch (ParseException ce) {
                throw ce;
            }
            catch (Exception other) {
                LOG.error(null, (Throwable)other);
                throw new ParseException("unexpected exception: " + other, this.pos.getIndex());
            }
        }
        return root;
    }

    private INode parseToken(int level) throws ParseException {
        if (level >= 5) {
            return this.parseAtom();
        }
        INode leftToken = this.parseToken(level + 1);
        if (leftToken != null) {
            INode rightToken;
            String op;
            int save = this.pos.getIndex();
            while (this.parseWhitespace(0) && (op = this.parseOp(level + 1)) != null && this.parseWhitespace(0) && (rightToken = this.parseToken(level + 1)) != null) {
                if ("&&".equals(op)) {
                    leftToken = new Op.And(leftToken, rightToken);
                } else if ("||".equals(op)) {
                    leftToken = new Op.Or(leftToken, rightToken);
                } else if ("==".equals(op)) {
                    leftToken = new Op.Equal(leftToken, rightToken);
                } else if ("<=".equals(op)) {
                    leftToken = new Op.LessThanOrEqual(leftToken, rightToken);
                } else if (">=".equals(op)) {
                    leftToken = new Op.GreaterThanOrEqual(leftToken, rightToken);
                } else if ("<>".equals(op) || "!=".equals(op)) {
                    leftToken = new Op.NotEqual(leftToken, rightToken);
                } else if ("<".equals(op)) {
                    leftToken = new Op.LessThan(leftToken, rightToken);
                } else if (">".equals(op)) {
                    leftToken = new Op.GreaterThan(leftToken, rightToken);
                } else if ("+".equals(op)) {
                    leftToken = new Op.Add(leftToken, rightToken);
                } else if ("-".equals(op)) {
                    leftToken = new Op.Sub(leftToken, rightToken);
                } else if ("*".equals(op)) {
                    leftToken = new Op.Mul(leftToken, rightToken);
                } else if ("/".equals(op)) {
                    leftToken = new Op.Div(leftToken, rightToken);
                } else if ("%".equals(op)) {
                    leftToken = new Op.Mod(leftToken, rightToken);
                } else if ("^".equals(op)) {
                    leftToken = new Op.BitXor(leftToken, rightToken);
                } else if ("|".equals(op)) {
                    leftToken = new Op.BitOr(leftToken, rightToken);
                } else if ("&".equals(op)) {
                    leftToken = new Op.BitAnd(leftToken, rightToken);
                } else if ("<<".equals(op)) {
                    leftToken = new Op.BitShiftLeft(leftToken, rightToken);
                } else if (">>".equals(op)) {
                    leftToken = new Op.BitShiftRight(leftToken, rightToken);
                } else if (">>>".equals(op)) {
                    leftToken = new Op.BitShiftRightZeroExtending(leftToken, rightToken);
                } else {
                    throw new ParseException("unexpected operation " + op, this.pos.getIndex());
                }
                save = this.pos.getIndex();
            }
            this.pos.setIndex(save);
            return leftToken;
        }
        return null;
    }

    private String parseOp(int level) throws ParseException {
        int index = this.pos.getIndex();
        if (this.matches("&&") || this.matches("||") || this.matches("==") || this.matches("<=") || this.matches(">=") || this.matches("<>") || this.matches("!=") || this.matches("<<") || this.matches(">>") || this.matches("<") || this.matches(">") || this.matches("+") || this.matches("-") || this.matches("*") || this.matches("/") || this.matches("%") || this.matches("^") || this.matches("&") || this.matches("|")) {
            String op = this.str.substring(index, this.pos.getIndex());
            if (level == 1) {
                if ("&&".equals(op)) {
                    return op;
                }
                if ("||".equals(op)) {
                    return op;
                }
                return null;
            }
            if (level == 2) {
                if ("==".equals(op)) {
                    return op;
                }
                if ("<=".equals(op)) {
                    return op;
                }
                if (">=".equals(op)) {
                    return op;
                }
                if ("<>".equals(op)) {
                    return op;
                }
                if ("!=".equals(op)) {
                    return op;
                }
                if ("<".equals(op)) {
                    return op;
                }
                if (">".equals(op)) {
                    return op;
                }
                return null;
            }
            if (level == 3) {
                if ("+".equals(op)) {
                    return op;
                }
                if ("-".equals(op)) {
                    return op;
                }
                return null;
            }
            if (level == 4) {
                if ("*".equals(op)) {
                    return op;
                }
                if ("/".equals(op)) {
                    return op;
                }
                if ("%".equals(op)) {
                    return op;
                }
                return null;
            }
            if (level == 5) {
                if ("^".equals(op)) {
                    return op;
                }
                if ("&".equals(op)) {
                    return op;
                }
                if ("|".equals(op)) {
                    return op;
                }
                if ("<<".equals(op)) {
                    return op;
                }
                if (">>".equals(op)) {
                    return op;
                }
                return null;
            }
            throw new ParseException("invalid op level " + level, this.pos.getIndex());
        }
        return null;
    }

    private INode parseAtom() throws ParseException {
        AbstractNode cmd = this.parseWrappedToken();
        if (cmd != null) {
            return cmd;
        }
        cmd = this.parseNotToken();
        if (cmd != null) {
            return cmd;
        }
        cmd = this.parseNullAtom();
        if (cmd != null) {
            return cmd;
        }
        cmd = this.parseIntegerAtom();
        if (cmd != null) {
            return cmd;
        }
        cmd = this.parseBooleanAtom();
        if (cmd != null) {
            return cmd;
        }
        cmd = this.parseStringAtom();
        if (cmd != null) {
            return cmd;
        }
        cmd = this.parseSignalRef();
        if (cmd != null) {
            return cmd;
        }
        cmd = this.parseArgRef();
        if (cmd != null) {
            return cmd;
        }
        return null;
    }

    private WrappedToken parseWrappedToken() throws ParseException {
        int index = this.pos.getIndex();
        INode node = null;
        if (this.matches("(") && this.parseWhitespace(0) && (node = this.parseToken(0)) != null && this.parseWhitespace(0) && this.matches(")")) {
            return new WrappedToken(node);
        }
        this.pos.setIndex(index);
        return null;
    }

    private NotToken parseNotToken() throws ParseException {
        int index = this.pos.getIndex();
        INode node = null;
        if (this.matches("!") && this.parseWhitespace(0) && (node = this.parseToken(0)) != null) {
            return new NotToken(node);
        }
        this.pos.setIndex(index);
        return null;
    }

    private NullAtom parseNullAtom() {
        int index = this.pos.getIndex();
        String name = this.parseName();
        if (name != null && name.equalsIgnoreCase("null")) {
            return new NullAtom();
        }
        this.pos.setIndex(index);
        return null;
    }

    private IntegerAtom parseIntegerAtom() throws ParseException {
        int index = this.pos.getIndex();
        int len = this.str.length();
        int i = index;
        if (this.matches("+") || this.matches("-")) {
            ++i;
        }
        while (i < len && Character.isDigit(this.str.charAt(i))) {
            ++i;
        }
        if (i < len && this.str.charAt(i) == '.') {
            ++i;
            while (i < len && Character.isDigit(this.str.charAt(i))) {
                ++i;
            }
        }
        if (i > index) {
            this.pos.setIndex(i);
            String s = this.str.substring(index, this.pos.getIndex());
            s = s.trim();
            if (s.startsWith("+")) {
                s = s.substring(1);
            }
            if (s.indexOf(46) >= 0) {
                throw new ParseException("only supporting integer numbers: " + s, index);
            }
            return new IntegerAtom(new Integer(s));
        }
        return null;
    }

    private BooleanAtom parseBooleanAtom() {
        int index = this.pos.getIndex();
        String name = this.parseName();
        if (name != null) {
            if (name.equalsIgnoreCase("true")) {
                return new BooleanAtom(true);
            }
            if (name.equalsIgnoreCase("false")) {
                return new BooleanAtom(false);
            }
        }
        this.pos.setIndex(index);
        return null;
    }

    private StringAtom parseStringAtom() throws ParseException {
        int index = this.pos.getIndex();
        if (this.matches("'") || this.matches("\"")) {
            char ch;
            char delimChar = this.str.charAt(index);
            StringBuffer text = new StringBuffer();
            while ((ch = this.parseChar(delimChar)) != '\u0000') {
                text.append(ch);
            }
            if (this.matches("" + delimChar)) {
                return new StringAtom(text.toString());
            }
            throw new ParseException("unclosed string; expected delimChar " + delimChar, this.pos.getIndex());
        }
        this.pos.setIndex(index);
        return null;
    }

    private SignalRef parseSignalRef() throws ParseException {
        int index = this.pos.getIndex();
        String name = this.parseName();
        if (name != null) {
            if ("second".equalsIgnoreCase(name)) {
                return new SignalRef(1);
            }
            if ("minute".equalsIgnoreCase(name)) {
                return new SignalRef(2);
            }
            if ("hour".equalsIgnoreCase(name)) {
                return new SignalRef(3);
            }
            if ("day".equalsIgnoreCase(name)) {
                return new SignalRef(4);
            }
            if ("week".equalsIgnoreCase(name)) {
                return new SignalRef(5);
            }
            if ("month".equalsIgnoreCase(name)) {
                return new SignalRef(6);
            }
            if ("year".equalsIgnoreCase(name)) {
                return new SignalRef(7);
            }
            if ("dayOfWeek".equalsIgnoreCase(name)) {
                return new SignalRef(8);
            }
            if ("dayOfMonthReverse".equalsIgnoreCase(name)) {
                return new SignalRef(9);
            }
            if ("dayOfYear".equalsIgnoreCase(name)) {
                return new SignalRef(10);
            }
            if ("secondOfDay".equalsIgnoreCase(name)) {
                return new SignalRef(11);
            }
        }
        this.pos.setIndex(index);
        return null;
    }

    private ArgRef parseArgRef() throws ParseException {
        int index = this.pos.getIndex();
        String name = this.parseName();
        if (name != null) {
            name = name.toLowerCase();
            Matcher mat = Pattern.compile("arg([0-9]+)").matcher(name.toLowerCase());
            if (mat.matches()) {
                return new ArgRef(Integer.parseInt(mat.group(1)));
            }
        }
        this.pos.setIndex(index);
        return null;
    }

    private String parseName() {
        int len;
        int index = this.pos.getIndex();
        int i = index;
        if (i < (len = this.str.length()) && Character.isJavaIdentifierStart(this.str.charAt(i))) {
            ++i;
            while (i < len && Character.isJavaIdentifierPart(this.str.charAt(i))) {
                ++i;
            }
        }
        if (i > index) {
            this.pos.setIndex(i);
            return this.str.substring(index, this.pos.getIndex());
        }
        this.pos.setIndex(index);
        return null;
    }

    private char parseChar(char quoteChar) {
        int len;
        int index;
        String notCharacterMap = "\\";
        if (quoteChar != '\u0000') {
            notCharacterMap = String.valueOf(notCharacterMap) + quoteChar;
        }
        if ((index = this.pos.getIndex()) >= (len = this.str.length())) {
            return '\u0000';
        }
        char ch = this.str.charAt(index);
        if (index < len && notCharacterMap.indexOf(ch) < 0) {
            this.pos.setIndex(index + 1);
            return (char)ch;
        }
        if (index + 1 < len && ch == '\\') {
            this.pos.setIndex(index + 2);
            ch = this.str.charAt(index + 1);
            switch (ch) {
                case 98: {
                    ch = '\b';
                    break;
                }
                case 116: {
                    ch = '\t';
                    break;
                }
                case 110: {
                    ch = '\n';
                    break;
                }
                case 102: {
                    ch = '\f';
                    break;
                }
                case 114: {
                    ch = '\r';
                }
            }
            return (char)ch;
        }
        return '\u0000';
    }

    private boolean matches(String m) {
        int len;
        int index = this.pos.getIndex();
        if (index + (len = m.length()) <= this.str.length() && m.equalsIgnoreCase(this.str.substring(index, index + len))) {
            this.pos.setIndex(index + len);
            return true;
        }
        return false;
    }

    private boolean parseWhitespace(int numRequired) throws ParseException {
        int index = this.pos.getIndex();
        int len = this.str.length();
        int i = index;
        while (i < len && S_MAP.indexOf(this.str.charAt(i)) >= 0) {
            ++i;
        }
        while (i + 1 < len && this.str.charAt(i) == '/' && this.str.charAt(i + 1) == '*') {
            int end = this.str.indexOf("*/", i += 2);
            if (end < 0) {
                throw new ParseException("missing comment end: */", i);
            }
            String text = this.str.substring(i, end).trim();
            text.length();
            i = end + 2;
            while (i < len && S_MAP.indexOf(this.str.charAt(i)) >= 0) {
                ++i;
            }
        }
        if (i - index >= numRequired) {
            this.pos.setIndex(i);
            return true;
        }
        return false;
    }
}

