/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.csv;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.scout.commons.csv.CsvHelper;
import org.eclipse.scout.commons.csv.IDataConsumer;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.NVPair;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.services.common.csv.CsvSqlSettings;
import org.eclipse.scout.rt.server.services.common.jdbc.ISelectStreamHandler;
import org.eclipse.scout.rt.server.services.common.jdbc.ISqlService;
import org.eclipse.scout.rt.server.services.common.jdbc.SqlBind;

public class CsvSqlAdapter {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(CsvSqlAdapter.class);
    private ISqlService m_sqlService;

    public CsvSqlAdapter(ISqlService service) {
        if (service == null) {
            throw new IllegalArgumentException("sql service must not be null");
        }
        this.m_sqlService = service;
    }

    public void exportDataFromTable(File f, String encoding, Locale contentLocale, String colSeparator, String textDelimiter, String tableName, String groupKeyColumnName, Object groupKeyValue, String lineNumberColumnName, List<String> csvColumnNames, boolean writeColumnNames, List<String> csvColumnTypes, boolean writeColumnTypes) throws ProcessingException {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            CsvSqlSettings params = new CsvSqlSettings();
            params.setFile(f);
            params.setEncoding(encoding);
            params.setContentLocale(contentLocale);
            params.setColSeparator(colSeparator == null ? (char)'\u0000' : colSeparator.charAt(0));
            params.setTextDelimiter(textDelimiter == null ? (char)'\u0000' : textDelimiter.charAt(0));
            params.setTableName(tableName);
            params.setGroupKeyColumnName(groupKeyColumnName);
            params.setGroupKeyValue(groupKeyValue);
            params.setLineNumberColumnName(lineNumberColumnName);
            params.setWriteColumnNames(writeColumnNames);
            params.setWriteColumnTypes(writeColumnTypes);
            if (csvColumnNames != null) {
                params.setCsvColumnNames(csvColumnNames);
            }
            if (csvColumnTypes != null) {
                params.setCsvColumnTypes(csvColumnTypes);
            }
            this.exportData(params);
        }
        catch (Exception e) {
            throw new ProcessingException(e.getMessage(), (Throwable)e);
        }
    }

    public void exportDataWithSql(File f, String encoding, Locale contentLocale, String colSeparator, String textDelimiter, String sqlSelect, NVPair[] bindBase, List<String> csvColumnNames, boolean writeColumNames, List<String> csvColumnTypes, boolean writeColumnTypes) throws ProcessingException {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            CsvSqlSettings params = new CsvSqlSettings();
            params.setFile(f);
            params.setEncoding(encoding);
            params.setContentLocale(contentLocale);
            params.setColSeparator(colSeparator == null ? (char)'\u0000' : colSeparator.charAt(0));
            params.setTextDelimiter(textDelimiter == null ? (char)'\u0000' : textDelimiter.charAt(0));
            params.setSqlSelect(sqlSelect);
            params.setBindBase(bindBase);
            params.setWriteColumnNames(writeColumNames);
            params.setWriteColumnTypes(writeColumnTypes);
            if (csvColumnNames != null) {
                params.setCsvColumnNames(csvColumnNames);
            }
            if (csvColumnTypes != null) {
                params.setCsvColumnTypes(csvColumnTypes);
            }
            this.exportData(params);
        }
        catch (Exception e) {
            throw new ProcessingException(e.getMessage(), (Throwable)e);
        }
    }

    public void exportData(CsvSqlSettings params) throws ProcessingException {
        final CsvHelper h = new CsvHelper(params.getContentLocale(), params.getColSeparator(), params.getTextDelimiter(), "\n");
        if (params.getCsvColumnTypes() != null) {
            h.setColumnTypes(params.getCsvColumnTypes());
        }
        if (params.getCsvColumnNames() != null) {
            h.setColumnNames(params.getCsvColumnNames());
        }
        try {
            String sqlText;
            ArrayList<String> cols = new ArrayList<String>();
            cols.addAll(params.getCsvColumnNames());
            Object[] base = null;
            if (params.getSqlSelect() != null) {
                sqlText = params.getSqlSelect();
                base = params.getBindBase();
            } else {
                StringBuffer buf = new StringBuffer();
                buf.append("SELECT ");
                Iterator it = cols.iterator();
                while (it.hasNext()) {
                    String colName = (String)it.next();
                    buf.append(colName);
                    if (!it.hasNext()) continue;
                    buf.append(",");
                }
                buf.append(" FROM ");
                buf.append(params.getTableName());
                if (params.getGroupKeyValue() != null) {
                    buf.append(" WHERE ");
                    buf.append(params.getGroupKeyColumnName());
                    buf.append("=:groupKeyColumnValue");
                }
                if (params.getLineNumberColumnName() != null) {
                    buf.append(" ORDER BY ");
                    buf.append(params.getLineNumberColumnName());
                }
                sqlText = buf.toString();
                if (params.getGroupKeyValue() != null) {
                    base = new Object[]{new NVPair("groupKeyColumnValue", params.getGroupKeyValue())};
                }
            }
            final OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(params.getFile()), params.getEncoding());
            try {
                h.exportHeaderRows((Writer)w, params.getWriteColumnNames(), params.getWriteColumnTypes());
                ISelectStreamHandler handler = new ISelectStreamHandler(){

                    @Override
                    public void handleRow(Connection con, PreparedStatement stm, ResultSet rs, int rowIndex, List<SqlBind> values) throws ProcessingException {
                        Object[] row = new Object[values.size()];
                        int i = 0;
                        while (i < row.length) {
                            row[i] = values.get(i).getValue();
                            ++i;
                        }
                        h.exportDataRow(row, w, false);
                    }

                    @Override
                    public void finished(Connection con, PreparedStatement stm, ResultSet rs, int rowCount) throws ProcessingException {
                    }
                };
                this.m_sqlService.selectStreaming(sqlText, handler, base);
            }
            finally {
                try {
                    ((Writer)w).close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            throw new ProcessingException(e.getMessage(), (Throwable)e);
        }
    }

    public void importDataIntoTable(File f, String encoding, Locale contentLocale, int headerRowCount, String colSeparator, String textDelimiter, String tableName, String groupKeyColumnName, Object groupKeyValue, String lineNumberColumnName, List<String> csvColumnNames, List<String> csvColumnTypes, boolean allowVariableColumnCount) throws ProcessingException {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            CsvSqlSettings params = new CsvSqlSettings();
            params.setFile(f);
            params.setEncoding(encoding);
            params.setContentLocale(contentLocale);
            params.setHeaderRowCount(headerRowCount);
            params.setColSeparator(colSeparator == null ? (char)'\u0000' : colSeparator.charAt(0));
            params.setTextDelimiter(textDelimiter == null ? (char)'\u0000' : textDelimiter.charAt(0));
            params.setTableName(tableName);
            params.setGroupKeyColumnName(groupKeyColumnName);
            params.setGroupKeyValue(groupKeyValue);
            params.setLineNumberColumnName(lineNumberColumnName);
            params.setAllowVariableColumnCount(allowVariableColumnCount);
            if (csvColumnNames != null) {
                params.setCsvColumnNames(csvColumnNames);
            }
            if (csvColumnTypes != null) {
                params.setCsvColumnTypes(csvColumnTypes);
            }
            this.importData(params);
        }
        catch (Exception e) {
            throw new ProcessingException(e.getMessage(), (Throwable)e);
        }
    }

    public void importData(CsvSqlSettings params) throws ProcessingException {
        CsvHelper h = new CsvHelper(params.getContentLocale(), params.getColSeparator(), params.getTextDelimiter(), "\n");
        if (params.getCsvColumnTypes() != null) {
            h.setColumnTypes(params.getCsvColumnTypes());
        }
        if (params.getCsvColumnNames() != null) {
            h.setColumnNames(params.getCsvColumnNames());
        }
        try {
            ArrayList<String> cols = new ArrayList<String>();
            if (params.getGroupKeyValue() != null) {
                cols.add(params.getGroupKeyColumnName());
            }
            if (params.getLineNumberColumnName() != null) {
                cols.add(params.getLineNumberColumnName());
            }
            cols.addAll(params.getCsvColumnNames());
            StringBuffer buf = new StringBuffer();
            buf.append("INSERT INTO ");
            buf.append(params.getTableName());
            buf.append("(");
            for (String colName : cols) {
                if ("null".equals(colName)) continue;
                buf.append(colName);
                buf.append(",");
            }
            buf.deleteCharAt(buf.length() - 1);
            buf.append(") VALUES (");
            int i = 0;
            for (String colName : cols) {
                if ("null".equals(colName)) continue;
                buf.append(":v" + i);
                buf.append(",");
                ++i;
            }
            buf.deleteCharAt(buf.length() - 1);
            buf.append(")");
            String stm = buf.toString();
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(params.getFile()), params.getEncoding());){
                SqlInsertDataConsumer cons = new SqlInsertDataConsumer(stm, params.getGroupKeyValue(), params.getLineNumberColumnName() != null);
                h.importData((IDataConsumer)cons, (Reader)reader, false, false, params.getHeaderRowCount(), -1, params.getAllowVariableColumnCount());
            }
        }
        catch (Exception e) {
            throw new ProcessingException(e.getMessage(), (Throwable)e);
        }
    }

    private class SqlInsertDataConsumer
    implements IDataConsumer {
        private String m_statement;
        private Object m_groupKey;
        private boolean m_useLineNumberColumnName;

        public SqlInsertDataConsumer(String stm, Object groupKey, boolean useLineNumberColumnName) {
            this.m_statement = stm;
            this.m_groupKey = groupKey;
            this.m_useLineNumberColumnName = useLineNumberColumnName;
        }

        public void processRow(int lineNr, List<Object> row) throws ProcessingException {
            try {
                ArrayList<NVPair> bindBase = new ArrayList<NVPair>();
                int i = 0;
                if (this.m_groupKey != null) {
                    bindBase.add(new NVPair("v" + i, this.m_groupKey));
                    ++i;
                }
                if (this.m_useLineNumberColumnName) {
                    bindBase.add(new NVPair("v" + i, (Object)lineNr));
                    ++i;
                }
                Iterator<Object> it = row.iterator();
                while (it.hasNext()) {
                    bindBase.add(new NVPair("v" + i, it.next()));
                    ++i;
                }
                CsvSqlAdapter.this.m_sqlService.insert(this.m_statement, bindBase.toArray());
            }
            catch (Exception e) {
                throw new ProcessingException("line=" + lineNr + " row=" + row + "\n" + e.getMessage());
            }
        }
    }
}

