/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.dict;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.services.common.jdbc.dict.ColumnDesc;
import org.eclipse.scout.rt.server.services.common.jdbc.dict.DataDictionary;
import org.eclipse.scout.rt.server.services.common.jdbc.dict.IndexDesc;
import org.eclipse.scout.rt.server.services.common.jdbc.dict.PrimaryKeyDesc;
import org.eclipse.scout.rt.server.services.common.jdbc.dict.SequenceDesc;
import org.eclipse.scout.rt.server.services.common.jdbc.dict.TableDesc;
import org.eclipse.scout.rt.server.services.common.jdbc.dict.TableGrantDesc;
import org.eclipse.scout.rt.server.services.common.jdbc.dict.ViewDesc;

@Deprecated
public class CongruencyFilter {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(CongruencyFilter.class);
    private ArrayList<String> m_forceTriggerChangeTableNames = new ArrayList();

    public boolean isRelevant(Object o) {
        return true;
    }

    public boolean allowDropTable() {
        return false;
    }

    public boolean allowDropTableColumn() {
        return false;
    }

    public void forceTriggerChange(String fullTableName) {
        this.m_forceTriggerChangeTableNames.add(fullTableName);
    }

    public boolean isTriggerChanged(String fullTableName) {
        return this.m_forceTriggerChangeTableNames.contains(fullTableName);
    }

    public boolean isAnyTriggerChanged() {
        return this.m_forceTriggerChangeTableNames.size() > 0;
    }

    public boolean isCongruent(DataDictionary o1, DataDictionary o2) {
        return this.isCongruentAndRelevant(o1.getTables(), o2.getTables()) && this.isCongruentAndRelevant(o1.getViews(), o2.getViews()) && this.isCongruentAndRelevant(o1.getSequences(), o2.getSequences());
    }

    public boolean isCongruent(TableDesc o1, TableDesc o2) {
        if (o1 != null && this.isTriggerChanged(o1.getFullName())) {
            return false;
        }
        if (o2 != null && this.isTriggerChanged(o2.getFullName())) {
            return false;
        }
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.getName().equals(o2.getName()) && this.isCongruent(o1.getPrimaryKey(), o2.getPrimaryKey()) && this.isCongruentAndRelevant(o1.getColumns(), o2.getColumns()) && this.isCongruentAndRelevant(o1.getIndices(), o2.getIndices()) && this.isCongruentAndRelevant(o1.getGrants(), o2.getGrants());
    }

    public boolean isCongruent(ViewDesc o1, ViewDesc o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.getName().equals(o2.getName()) && o1.getStatement().equals(o2.getStatement()) && this.isCongruentAndRelevant(o1.getGrants(), o2.getGrants());
    }

    public boolean isCongruent(TableGrantDesc o1, TableGrantDesc o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.getGrantee().equals(o2.getGrantee()) && o1.getType().equals(o2.getType());
    }

    public boolean isCongruent(ColumnDesc o1, ColumnDesc o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.getName().equals(o2.getName()) && o1.isNullable() == o2.isNullable() && this.getCanonicalColumnType(o1).equals(this.getCanonicalColumnType(o2));
    }

    public boolean isCongruent(IndexDesc o1, IndexDesc o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.isUnique() == o2.isUnique() && o1.getColumnNames().equals(o2.getColumnNames());
    }

    public boolean isCongruent(PrimaryKeyDesc o1, PrimaryKeyDesc o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.getColumnNames().equals(o2.getColumnNames());
    }

    public boolean isCongruent(SequenceDesc o1, SequenceDesc o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.getName().equals(o2.getName());
    }

    public boolean isCongruentAndRelevant(Collection c1, Collection c2) {
        for (Object o : c1) {
            if (!this.isRelevant(o) || this.containsCongruent(c2, o)) continue;
            return false;
        }
        for (Object o : c2) {
            if (!this.isRelevant(o) || this.containsCongruent(c1, o)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsCongruent(Collection c, Object o) {
        if (o == null) {
            return false;
        }
        try {
            Object o1;
            boolean found;
            Method m = this.getClass().getMethod("isCongruent", o.getClass(), o.getClass());
            Iterator it = c.iterator();
            do {
                if (!it.hasNext()) {
                    return false;
                }
                o1 = it.next();
            } while (!(found = ((Boolean)m.invoke((Object)this, o1, o)).booleanValue()));
            return true;
        }
        catch (Exception e) {
            LOG.error("Error in reflection on Collection " + c + " and Object " + o + ":" + e, (Throwable)e);
        }
        return false;
    }

    public boolean isNumeric(ColumnDesc cd) {
        String type = cd.getTypeName().toUpperCase();
        return "INT".equals(type) || "INTEGER".equals(type) || "DOUBLE".equals(type) || "DOUBLE PRECISION".equals(type) || "REAL".equals(type) || "BIGINT".equals(type) || "SMALLINT".equals(type) || "TINYINT".equals(type) || "NUMBER".equals(type) || "DECIMAL".equals(type);
    }

    public String getCanonicalColumnType(ColumnDesc cd) {
        String type = cd.getTypeName().toUpperCase();
        if (cd.getPrecision() > 0L) {
            if (cd.getDecimalDigits() > 0L) {
                return String.valueOf(type) + "(" + cd.getPrecision() + "," + cd.getDecimalDigits() + ")";
            }
            return String.valueOf(type) + "(" + cd.getPrecision() + ")";
        }
        if (cd.getSize() > 0L) {
            return String.valueOf(type) + "(" + cd.getSize() + ")";
        }
        return type;
    }
}

