/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.internal.exec;

import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.IBeanArrayHolder;
import org.eclipse.scout.commons.parsers.token.IToken;
import org.eclipse.scout.commons.parsers.token.ValueInputToken;
import org.eclipse.scout.rt.server.services.common.jdbc.SqlBind;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.BeanPropertyInput;
import org.eclipse.scout.rt.server.services.common.jdbc.internal.exec.IBindInput;
import org.eclipse.scout.rt.server.services.common.jdbc.style.ISqlStyle;

class BeanArrayHolderInput
implements IBindInput {
    private IBeanArrayHolder m_holder;
    private BeanPropertyInput m_delegate;

    public BeanArrayHolderInput(IBeanArrayHolder holder, Object[] beans, String propertyName, ValueInputToken target) throws ProcessingException {
        this.m_holder = holder;
        if (beans == null) {
            beans = this.m_holder.getBeans(new IBeanArrayHolder.State[0]);
        }
        this.m_delegate = new BeanPropertyInput(propertyName, beans, target);
    }

    @Override
    public IToken getToken() {
        return this.m_delegate.getToken();
    }

    @Override
    public boolean isBatch() {
        return this.m_delegate.isBatch();
    }

    @Override
    public boolean hasBatch(int i) {
        return this.m_delegate.hasBatch(i);
    }

    @Override
    public void setNextBatchIndex(int i) {
        this.m_delegate.setNextBatchIndex(i);
    }

    @Override
    public boolean isJdbcBind(ISqlStyle sqlStyle) {
        return this.m_delegate.isJdbcBind(sqlStyle);
    }

    @Override
    public int getJdbcBindIndex() {
        return this.m_delegate.getJdbcBindIndex();
    }

    @Override
    public void setJdbcBindIndex(int index) {
        this.m_delegate.setJdbcBindIndex(index);
    }

    @Override
    public SqlBind produceSqlBindAndSetReplaceToken(ISqlStyle sqlStyle) throws ProcessingException {
        return this.m_delegate.produceSqlBindAndSetReplaceToken(sqlStyle);
    }
}

