/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.annotations.IOrdered;
import org.eclipse.scout.commons.annotations.OrderedCollection;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.data.model.AbstractDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.AbstractDataModelEntity;
import org.eclipse.scout.rt.shared.data.model.IDataModel;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelEntity;
import org.eclipse.scout.rt.shared.extension.ContributionComposite;
import org.eclipse.scout.rt.shared.extension.ExtensionUtility;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractDataModel
implements IDataModel,
Serializable,
IContributionOwner {
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractDataModel.class);
    private boolean m_calledInitializer;
    private List<IDataModelAttribute> m_attributes;
    private List<IDataModelEntity> m_entities;
    private IContributionOwner m_contributionHolder;

    public AbstractDataModel() {
        this(true);
    }

    public AbstractDataModel(boolean callInitializer) {
        if (callInitializer) {
            this.callInitializer();
        }
    }

    @Override
    public final List<Object> getAllContributions() {
        return this.m_contributionHolder.getAllContributions();
    }

    @Override
    public final <T> List<T> getContributionsByClass(Class<T> type) {
        return this.m_contributionHolder.getContributionsByClass(type);
    }

    @Override
    public final <T> T getContribution(Class<T> contribution) {
        return this.m_contributionHolder.getContribution(contribution);
    }

    protected void callInitializer() {
        if (!this.m_calledInitializer) {
            this.m_calledInitializer = true;
            this.initConfig();
        }
    }

    protected List<IDataModelAttribute> createAttributes(Object holder) {
        Class[] all = ConfigurationUtility.getDeclaredPublicClasses(holder.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])all, IDataModelAttribute.class);
        List<IDataModelAttribute> contributedAttributes = this.m_contributionHolder.getContributionsByClass(IDataModelAttribute.class);
        OrderedCollection attributes = new OrderedCollection();
        for (Class attributeClazz : filtered) {
            try {
                IDataModelAttribute a = (IDataModelAttribute)ConfigurationUtility.newInnerInstance((Object)holder, (Class)attributeClazz);
                attributes.addOrdered((IOrdered)a);
            }
            catch (Exception e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + attributeClazz.getName() + "'.", (Throwable)e));
            }
        }
        attributes.addAllOrdered(contributedAttributes);
        ExtensionUtility.moveModelObjects((Iterable<? extends IOrdered>)attributes);
        return attributes.getOrderedList();
    }

    protected List<IDataModelEntity> createEntities(Object holder) {
        Class[] all = ConfigurationUtility.getDeclaredPublicClasses(holder.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])all, IDataModelEntity.class);
        List<IDataModelEntity> contributedEntities = this.m_contributionHolder.getContributionsByClass(IDataModelEntity.class);
        OrderedCollection entities = new OrderedCollection();
        for (Class dataModelEntityClazz : filtered) {
            try {
                entities.addOrdered((IOrdered)((IDataModelEntity)ConfigurationUtility.newInnerInstance((Object)holder, (Class)dataModelEntityClazz)));
            }
            catch (Exception e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + dataModelEntityClazz.getName() + "'.", (Throwable)e));
            }
        }
        entities.addAllOrdered(contributedEntities);
        ExtensionUtility.moveModelObjects((Iterable<? extends IOrdered>)entities);
        return entities.getOrderedList();
    }

    protected List<IDataModelAttribute> createAttributes() {
        return this.createAttributes(this);
    }

    protected List<IDataModelEntity> createEntities() {
        return this.createEntities(this);
    }

    protected void initConfig() {
        this.m_contributionHolder = new ContributionComposite(this);
        this.m_attributes = this.createAttributes();
        for (IDataModelAttribute a : this.m_attributes) {
            if (!(a instanceof AbstractDataModelAttribute)) continue;
            ((AbstractDataModelAttribute)a).setParentEntity(null);
        }
        this.m_entities = this.createEntities();
        HashMap<Class<? extends IDataModelEntity>, IDataModelEntity> instanceMap = new HashMap<Class<? extends IDataModelEntity>, IDataModelEntity>(this.m_entities.size());
        for (IDataModelEntity e : this.m_entities) {
            if (e instanceof AbstractDataModelEntity) {
                ((AbstractDataModelEntity)e).setParentEntity(null);
            }
            instanceMap.put(e.getClass(), e);
        }
        for (IDataModelEntity e : this.m_entities) {
            e.initializeChildEntities(instanceMap);
        }
    }

    @Override
    public void init() {
        for (IDataModelEntity e : this.getEntities()) {
            try {
                e.initEntity();
            }
            catch (Throwable t) {
                LOG.error("entity " + e, t);
            }
        }
        for (IDataModelAttribute a : this.getAttributes()) {
            try {
                a.initAttribute();
            }
            catch (Throwable t) {
                LOG.error("attribute " + a, t);
            }
        }
    }

    @Override
    public List<IDataModelAttribute> getAttributes() {
        return CollectionUtility.arrayList(this.m_attributes);
    }

    @Override
    public List<IDataModelEntity> getEntities() {
        return CollectionUtility.arrayList(this.m_entities);
    }

    @Override
    public IDataModelAttribute getAttribute(Class<? extends IDataModelAttribute> attributeClazz) {
        for (IDataModelAttribute attribute : this.m_attributes) {
            if (attribute.getClass() != attributeClazz) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public IDataModelEntity getEntity(Class<? extends IDataModelEntity> entityClazz) {
        for (IDataModelEntity entity : this.m_entities) {
            if (entity.getClass() != entityClazz) continue;
            return entity;
        }
        return null;
    }
}

