/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.extension;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.scout.commons.ClassIdentifier;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.annotations.Extends;
import org.eclipse.scout.commons.annotations.IOrdered;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.extension.AbstractExtensionRegistryItem;
import org.eclipse.scout.rt.shared.extension.ExtensionRegistryItem;
import org.eclipse.scout.rt.shared.extension.ExtensionRegistryMoveItem;
import org.eclipse.scout.rt.shared.extension.ExtensionScope;
import org.eclipse.scout.rt.shared.extension.ExtensionStack;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.IExtensionRegistrationValidatorService;
import org.eclipse.scout.rt.shared.extension.IExtensionRegistry;
import org.eclipse.scout.rt.shared.extension.IInternalExtensionRegistry;
import org.eclipse.scout.rt.shared.extension.IMoveModelObjectToRootMarker;
import org.eclipse.scout.rt.shared.extension.IllegalExtensionException;
import org.eclipse.scout.rt.shared.extension.MoveDescriptor;
import org.eclipse.scout.rt.shared.extension.ScopeItem;
import org.eclipse.scout.rt.shared.extension.ScopeStack;
import org.eclipse.scout.service.AbstractService;
import org.eclipse.scout.service.SERVICES;

public class ExtensionRegistry
extends AbstractService
implements IInternalExtensionRegistry {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ExtensionRegistry.class);
    private final Map<ClassIdentifier, List<ExtensionRegistryItem>> m_extensionItemMap;
    private final Map<ClassIdentifier, List<ExtensionRegistryItem>> m_contributionItemMap;
    private final Map<ClassIdentifier, List<ExtensionRegistryMoveItem>> m_modelMoveItemMap;
    private final ThreadLocal<ExtensionStack> m_extensionStack;
    private final ThreadLocal<ScopeStack> m_scopeStack;
    private final AtomicLong m_registrationOrder;
    private final ReadWriteLock m_readWriteLock = new ReentrantReadWriteLock();
    private ExtensionScope<ExtensionRegistryItem> m_globalExtensionScope;
    private ExtensionScope<ExtensionRegistryItem> m_globalContributionScope;
    private ExtensionScope<ExtensionRegistryMoveItem> m_globalModelMoveItemScope;

    public ExtensionRegistry() {
        this.m_extensionItemMap = new HashMap<ClassIdentifier, List<ExtensionRegistryItem>>();
        this.m_contributionItemMap = new HashMap<ClassIdentifier, List<ExtensionRegistryItem>>();
        this.m_modelMoveItemMap = new HashMap<ClassIdentifier, List<ExtensionRegistryMoveItem>>();
        this.m_extensionStack = new ThreadLocal();
        this.m_scopeStack = new ThreadLocal();
        this.m_registrationOrder = new AtomicLong();
        this.m_globalContributionScope = this.createGlobalScope(this.m_contributionItemMap, true);
        this.m_globalExtensionScope = this.createGlobalScope(this.m_extensionItemMap, true);
        this.m_globalModelMoveItemScope = this.createGlobalScope(this.m_modelMoveItemMap, false);
    }

    @Override
    public void register(Class<?> extensionClass) {
        this.register(extensionClass, (ClassIdentifier)null);
    }

    @Override
    public void register(Class<?> extensionClass, Class<?> ownerClass) {
        this.register(extensionClass, ownerClass, null);
    }

    @Override
    public void register(Class<?> extensionClass, Class<?> ownerClass, Double order) {
        if (extensionClass == null) {
            throw new IllegalExtensionException("Extension class must not be null.");
        }
        this.register(extensionClass, ownerClass == null ? null : new ClassIdentifier(new Class[]{ownerClass}), order);
    }

    @Override
    public void register(Class<?> extensionClass, ClassIdentifier ownerClassIdentifier) {
        this.register(extensionClass, ownerClassIdentifier, null);
    }

    @Override
    public void register(Class<?> extensionClass, ClassIdentifier ownerClassIdentifier, Double order) {
        if (extensionClass.getEnclosingClass() != null && !Modifier.isStatic(extensionClass.getModifiers())) {
            throw new IllegalExtensionException("Extension class [" + extensionClass.getName() + "] is a non-static inner class.");
        }
        this.m_readWriteLock.writeLock().lock();
        try {
            this.autoRegisterInternal(extensionClass, null, ownerClassIdentifier, null, order);
        }
        finally {
            this.m_readWriteLock.writeLock().unlock();
        }
    }

    protected Extends getExtendsAnnotation(Class<?> c) {
        Extends result = null;
        Class<?> currentClass = c;
        while (result == null && currentClass != null) {
            result = currentClass.getAnnotation(Extends.class);
            currentClass = currentClass.getSuperclass();
        }
        return result;
    }

    protected void autoRegisterInternal(Class<?> extensionClass, Class<?> declaringClass, ClassIdentifier ownerClassIdentifier, ClassIdentifier ownerClassIdentifierFromDeclaring, Double order) {
        if (extensionClass == null) {
            throw new IllegalExtensionException("Extension or contribution cannot be null.");
        }
        boolean isExtension = IExtension.class.isAssignableFrom(extensionClass);
        Class extensionGeneric = null;
        if (isExtension) {
            extensionGeneric = TypeCastUtility.getGenericsParameterClass(extensionClass, IExtension.class);
        }
        if (ownerClassIdentifier == null) {
            if (isExtension) {
                ownerClassIdentifier = new ClassIdentifier(new Class[]{extensionGeneric});
            }
            if (ownerClassIdentifier == null) {
                Extends extendsAnnotation = this.getExtendsAnnotation(extensionClass);
                if (extendsAnnotation != null) {
                    int pathToContainerLength = extendsAnnotation.pathToContainer().length;
                    if (pathToContainerLength > 0) {
                        Class[] segments = new Class[pathToContainerLength + 1];
                        System.arraycopy(extendsAnnotation.pathToContainer(), 0, segments, 0, pathToContainerLength);
                        segments[pathToContainerLength] = extendsAnnotation.value();
                        ownerClassIdentifier = new ClassIdentifier(segments);
                    } else {
                        ownerClassIdentifier = new ClassIdentifier(new Class[]{extendsAnnotation.value()});
                    }
                }
                if (ownerClassIdentifier == null) {
                    ownerClassIdentifier = ownerClassIdentifierFromDeclaring;
                }
            }
        }
        if (Modifier.isStatic(extensionClass.getModifiers())) {
            declaringClass = null;
        }
        this.registerInternal(ownerClassIdentifier, declaringClass, extensionClass, order, extensionGeneric, isExtension);
        if (isExtension) {
            List<Class<?>> innerExtensionClasses = this.collectInnerExtensionClasses(extensionClass);
            for (Class<?> innerExtensionClass : innerExtensionClasses) {
                this.autoRegisterInternal(innerExtensionClass, extensionClass, null, ownerClassIdentifier, null);
            }
        }
    }

    protected List<Class<?>> collectInnerExtensionClasses(Class<?> extensionClass) {
        Class<?>[] innerClasses = extensionClass.getClasses();
        ArrayList result = new ArrayList(innerClasses.length);
        Class<?>[] classArray = innerClasses;
        int n = innerClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> innerClass = classArray[n2];
            if (!Modifier.isAbstract(innerClass.getModifiers())) {
                result.add(innerClass);
            }
            ++n2;
        }
        return result;
    }

    protected void validateRegister(ClassIdentifier ownerClassIdentifier, Class<?> extensionClass, Double modelOrder, Class<?> extensionGeneric, boolean isExtension) {
        boolean isOrdered;
        if (ownerClassIdentifier == null) {
            throw new IllegalExtensionException("No owner information available for [" + extensionClass.getName() + "]. Either add an [@" + Extends.class.getSimpleName() + "] annotation, move it into a [" + IExtension.class.getName() + "] class or register explicitly on the [" + IExtensionRegistry.class.getName() + "] service.");
        }
        Class ownerClass = ownerClassIdentifier.getLastSegment();
        if (ownerClass == null) {
            throw new IllegalExtensionException("No owner information available for [" + extensionClass.getName() + "]. Either add an [@" + Extends.class.getSimpleName() + "] annotation, move it into a [" + IExtension.class.getName() + "] class or register explicitly on the [" + IExtensionRegistry.class.getName() + "] service.");
        }
        if (isExtension) {
            if (!ownerClass.equals(extensionGeneric)) {
                if (extensionGeneric == null) {
                    LOG.warn("Could not parse owner generic of extension [" + extensionClass.getName() + "].");
                } else if (!extensionGeneric.isAssignableFrom(ownerClass)) {
                    throw new IllegalExtensionException("Owner [" + ownerClass.getName() + "] is not compatible with the generic [" + extensionGeneric.getName() + "] of extension [" + extensionClass.getName() + "].");
                }
            }
        } else {
            boolean isContributionOwner = IContributionOwner.class.isAssignableFrom(ownerClass);
            if (!isContributionOwner) {
                throw new IllegalExtensionException("The owner [" + ownerClass.getName() + "] of contribution [" + extensionClass.getName() + "] does not implement [" + IContributionOwner.class.getName() + "].");
            }
            if (!this.isValidContribution(extensionClass, ownerClass)) {
                throw new IllegalExtensionException("Contribution [" + extensionClass.getName() + "] is not supported for owner [" + ownerClass.getName() + "].");
            }
        }
        if (!(isOrdered = IOrdered.class.isAssignableFrom(extensionClass)) && (modelOrder != null || this.isOrderAnnotationPresentInSuperClasses(extensionClass))) {
            LOG.warn("Order information not valid for extension [" + extensionClass.getName() + "]. This extension is not an [" + IOrdered.class.getName() + "] object.");
        }
    }

    protected boolean isValidContribution(Class<?> contribution, Class<?> container) {
        IExtensionRegistrationValidatorService[] iExtensionRegistrationValidatorServiceArray = (IExtensionRegistrationValidatorService[])SERVICES.getServices(IExtensionRegistrationValidatorService.class);
        int n = iExtensionRegistrationValidatorServiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtensionRegistrationValidatorService validator = iExtensionRegistrationValidatorServiceArray[n2];
            if (validator.isValidContribution(contribution, container)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isOrderAnnotationPresentInSuperClasses(Class<?> clazz) {
        Class<?> cls = clazz;
        while (cls != null) {
            if (cls.isAnnotationPresent(Order.class)) {
                return true;
            }
            cls = cls.getSuperclass();
        }
        return false;
    }

    protected void registerInternal(ClassIdentifier ownerClassIdentifier, Class<?> declaringClass, Class<?> extensionClass, Double modelOrder, Class<?> extensionGeneric, boolean isExtension) {
        this.validateRegister(ownerClassIdentifier, extensionClass, modelOrder, extensionGeneric, isExtension);
        Map map = this.getInsertionMap(isExtension);
        List<ExtensionRegistryItem> extensions = map.get(ownerClassIdentifier);
        if (extensions == null) {
            extensions = new LinkedList<ExtensionRegistryItem>();
            map.put(ownerClassIdentifier, extensions);
        }
        ExtensionRegistryItem item = new ExtensionRegistryItem(ownerClassIdentifier, declaringClass, extensionClass, modelOrder, this.m_registrationOrder.incrementAndGet());
        extensions.add(item);
        if (isExtension) {
            this.m_globalExtensionScope = this.createGlobalScope(map, true);
        } else {
            this.m_globalContributionScope = this.createGlobalScope(map, true);
        }
    }

    @Override
    public void registerMoveToRoot(Class<? extends IOrdered> modelClass, Double newOrder) {
        if (modelClass == null) {
            throw new IllegalExtensionException("modelClass class must not be null.");
        }
        this.registerMoveToRoot(new ClassIdentifier(new Class[]{modelClass}), newOrder);
    }

    @Override
    public void registerMoveToRoot(ClassIdentifier modelClassIdentifer, Double newOrder) {
        this.registerMove(modelClassIdentifer, newOrder, IMoveModelObjectToRootMarker.class);
    }

    @Override
    public void registerMove(Class<? extends IOrdered> modelClass, double newOrder) {
        if (modelClass == null) {
            throw new IllegalExtensionException("modelClass class must not be null.");
        }
        this.registerMove(new ClassIdentifier(new Class[]{modelClass}), newOrder);
    }

    @Override
    public void registerMove(ClassIdentifier modelClassIdentifier, double newOrder) {
        this.registerMove(modelClassIdentifier, (Double)newOrder, (ClassIdentifier)null);
    }

    @Override
    public void registerMove(Class<? extends IOrdered> modelClass, Double newOrder, Class<? extends IOrdered> newContainerClass) {
        if (modelClass == null) {
            throw new IllegalExtensionException("modelClass class must not be null.");
        }
        this.registerMove(new ClassIdentifier(new Class[]{modelClass}), newOrder, newContainerClass);
    }

    @Override
    public void registerMove(ClassIdentifier modelClassIdentifer, Double newOrder, Class<? extends IOrdered> newContainerClass) {
        this.registerMove(modelClassIdentifer, newOrder, newContainerClass == null ? null : new ClassIdentifier(new Class[]{newContainerClass}));
    }

    @Override
    public void registerMove(ClassIdentifier modelClassIdentifer, Double newOrder, ClassIdentifier newContainerClassIdentifier) {
        this.validateRegisterMove(modelClassIdentifer, newOrder, newContainerClassIdentifier);
        this.m_readWriteLock.writeLock().lock();
        try {
            Map<ClassIdentifier, List<ExtensionRegistryMoveItem>> modelMoveItemMap = this.getModelMoveItemMap();
            List<ExtensionRegistryMoveItem> moveItems = modelMoveItemMap.get(modelClassIdentifer);
            if (moveItems == null) {
                moveItems = new LinkedList<ExtensionRegistryMoveItem>();
                modelMoveItemMap.put(modelClassIdentifer, moveItems);
            }
            ExtensionRegistryMoveItem item = new ExtensionRegistryMoveItem(modelClassIdentifer, newContainerClassIdentifier, newOrder, this.m_registrationOrder.incrementAndGet());
            moveItems.add(item);
            this.m_globalModelMoveItemScope = this.createGlobalScope(this.getModelMoveItemMap(), false);
        }
        finally {
            this.m_readWriteLock.writeLock().unlock();
        }
    }

    protected void validateRegisterMove(ClassIdentifier modelClassIdentifier, Double newOrder, ClassIdentifier newContainerClassIdentifier) {
        if (modelClassIdentifier == null) {
            throw new IllegalExtensionException("modelClassIdentifier class must not be null.");
        }
        Class lastSegment = modelClassIdentifier.getLastSegment();
        if (!IOrdered.class.isAssignableFrom(lastSegment)) {
            throw new IllegalExtensionException("modelClassIdentifier's last segment is not an " + IOrdered.class.getSimpleName() + ".");
        }
        Class modelClass = lastSegment;
        if (modelClass == null) {
            throw new IllegalExtensionException("modelClass class must not be null.");
        }
        if (newOrder == null && newContainerClassIdentifier == null) {
            throw new IllegalExtensionException("At least a new order or a new container must be specified.");
        }
        if (newContainerClassIdentifier != null) {
            Class newContainerClass = newContainerClassIdentifier.getLastSegment();
            if (modelClass == newContainerClass) {
                throw new IllegalExtensionException("model class cannot be moved into itself.");
            }
            if (!IOrdered.class.isAssignableFrom(newContainerClass)) {
                throw new IllegalExtensionException("new container class must be instanceof " + IOrdered.class.getSimpleName() + ".");
            }
            Class newOrderedContainerClass = newContainerClass;
            if (!this.isValidMove(modelClass, newOrderedContainerClass)) {
                String newOrderStr = null;
                newOrderStr = newOrder == null ? "null" : newOrder.toString();
                throw new IllegalExtensionException("Move of element [" + modelClass.getName() + "] is not supported for order [" + newOrderStr + "] and container [" + newContainerClass.getName() + "].");
            }
        }
    }

    protected boolean isValidMove(Class<? extends IOrdered> modelClass, Class<? extends IOrdered> newContainerClass) {
        IExtensionRegistrationValidatorService[] iExtensionRegistrationValidatorServiceArray = (IExtensionRegistrationValidatorService[])SERVICES.getServices(IExtensionRegistrationValidatorService.class);
        int n = iExtensionRegistrationValidatorServiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtensionRegistrationValidatorService validator = iExtensionRegistrationValidatorServiceArray[n2];
            if (validator.isValidMove(modelClass, newContainerClass)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean deregisterMove(Class<? extends IOrdered> modelClass, double newOrder) {
        return this.deregisterMove(modelClass, (Double)newOrder, null);
    }

    @Override
    public boolean deregisterMove(Class<? extends IOrdered> modelClass, Double newOrder, Class<? extends IOrdered> newContainerClass) {
        if (modelClass == null) {
            throw new IllegalExtensionException("modelClass class must not be null.");
        }
        return this.deregisterMove(new ClassIdentifier(new Class[]{modelClass}), newOrder, newContainerClass);
    }

    @Override
    public boolean deregisterMove(ClassIdentifier modelClassIdentifier, Double newOrder, Class<? extends IOrdered> newContainerClass) {
        return this.deregisterMove(modelClassIdentifier, newOrder, newContainerClass == null ? null : new ClassIdentifier(new Class[]{newContainerClass}));
    }

    @Override
    public boolean deregisterMove(ClassIdentifier modelClassIdentifier, Double newOrder, ClassIdentifier newContainerClassIdentifier) {
        if (newOrder == null && newContainerClassIdentifier == null) {
            throw new IllegalExtensionException("At least a new order or a new container must be specified.");
        }
        this.m_readWriteLock.writeLock().lock();
        try {
            boolean changed = false;
            Map<ClassIdentifier, List<ExtensionRegistryMoveItem>> modelMoveItemMap = this.getModelMoveItemMap();
            List<ExtensionRegistryMoveItem> moveItems = modelMoveItemMap.get(modelClassIdentifier);
            if (CollectionUtility.hasElements(moveItems)) {
                Iterator<ExtensionRegistryMoveItem> iterator = moveItems.iterator();
                while (iterator.hasNext()) {
                    ExtensionRegistryMoveItem moveItem = iterator.next();
                    if (!CompareUtility.equals((Object)moveItem.getNewModelOrder(), (Object)newOrder) || !CompareUtility.equals((Object)moveItem.getNewModelContainerClassIdentifier(), (Object)newContainerClassIdentifier)) continue;
                    iterator.remove();
                    changed = true;
                }
                if (moveItems.isEmpty()) {
                    modelMoveItemMap.remove(modelClassIdentifier);
                    changed = true;
                }
            }
            if (changed) {
                this.m_globalModelMoveItemScope = this.createGlobalScope(this.getModelMoveItemMap(), false);
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            this.m_readWriteLock.writeLock().unlock();
        }
    }

    protected Map<ClassIdentifier, List<ExtensionRegistryItem>> getInsertionMap(boolean isExtension) {
        if (isExtension) {
            return this.getExtensionMap();
        }
        return this.getContributionMap();
    }

    protected Map<ClassIdentifier, List<ExtensionRegistryItem>> getExtensionMap() {
        return this.m_extensionItemMap;
    }

    protected Map<ClassIdentifier, List<ExtensionRegistryItem>> getContributionMap() {
        return this.m_contributionItemMap;
    }

    protected Map<ClassIdentifier, List<ExtensionRegistryMoveItem>> getModelMoveItemMap() {
        return this.m_modelMoveItemMap;
    }

    protected Set<ExtensionRegistryItem> getModelExtensionItemsFor(Class<?> ownerClass) {
        ScopeStack scopeStack = this.m_scopeStack.get();
        ExtensionScope<ExtensionRegistryItem> extensionScope = null;
        if (scopeStack != null) {
            extensionScope = scopeStack.getExtensionScope();
        }
        if (extensionScope == null) {
            extensionScope = this.m_globalExtensionScope;
        }
        return extensionScope.getRegistryItems(ownerClass);
    }

    protected Set<ExtensionRegistryItem> getModelContributionItemsFor(Class<?> ownerClass) {
        ScopeStack scopeStack = this.m_scopeStack.get();
        ExtensionScope<ExtensionRegistryItem> contributionScope = null;
        if (scopeStack != null) {
            contributionScope = scopeStack.getContributionScope();
        }
        if (contributionScope == null) {
            contributionScope = this.m_globalContributionScope;
        }
        return contributionScope.getRegistryItems(ownerClass);
    }

    protected Set<ExtensionRegistryMoveItem> getModelMoveItemsFor(Class<?> modelClass, Iterator<?> parentModelObjectIterator) {
        if (this.m_globalModelMoveItemScope == null) {
            return null;
        }
        Set<ScopeItem> scopeItems = this.m_globalModelMoveItemScope.filterScopeItems(modelClass, parentModelObjectIterator);
        return this.m_globalModelMoveItemScope.resolveRegistryItems(scopeItems);
    }

    @Override
    public boolean deregister(Class<?> extensionOrContributionClass) {
        if (extensionOrContributionClass == null) {
            throw new IllegalExtensionException("extensionOrContributionClass cannot be null.");
        }
        this.m_readWriteLock.writeLock().lock();
        try {
            boolean changed = false;
            boolean isExtension = IExtension.class.isAssignableFrom(extensionOrContributionClass);
            Map<ClassIdentifier, List<ExtensionRegistryItem>> mapToRemoveFrom = this.getInsertionMap(isExtension);
            Iterator<List<ExtensionRegistryItem>> iterator = mapToRemoveFrom.values().iterator();
            while (iterator.hasNext()) {
                List<ExtensionRegistryItem> items = iterator.next();
                Iterator<ExtensionRegistryItem> itemIterator = items.iterator();
                while (itemIterator.hasNext()) {
                    ExtensionRegistryItem item = itemIterator.next();
                    Class<?> extensionClass = item.getExtensionClass();
                    if (!extensionOrContributionClass.equals(extensionClass)) continue;
                    itemIterator.remove();
                    changed = true;
                }
                if (!items.isEmpty()) continue;
                iterator.remove();
                changed = true;
            }
            if (isExtension) {
                List<Class<?>> innerExtensionClasses = this.collectInnerExtensionClasses(extensionOrContributionClass);
                for (Class<?> innerExtensionClass : innerExtensionClasses) {
                    boolean innerChanged = this.deregister(innerExtensionClass);
                    if (!innerChanged) continue;
                    changed = true;
                }
            }
            if (changed) {
                if (isExtension) {
                    this.m_globalExtensionScope = this.createGlobalScope(this.getExtensionMap(), true);
                } else {
                    this.m_globalContributionScope = this.createGlobalScope(this.getContributionMap(), true);
                }
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            this.m_readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public <T extends IExtension<?>> List<T> createExtensionsFor(Object owner) {
        if (owner == null) {
            throw new IllegalArgumentException("owner must not be null.");
        }
        Set<ExtensionRegistryItem> extensionItems = null;
        this.m_readWriteLock.readLock().lock();
        try {
            extensionItems = this.getModelExtensionItemsFor(owner.getClass());
        }
        finally {
            this.m_readWriteLock.readLock().unlock();
        }
        LinkedList<IExtension> extensions = new LinkedList<IExtension>();
        if (CollectionUtility.isEmpty(extensionItems)) {
            return extensions;
        }
        ExtensionStack extensionStack = this.m_extensionStack.get();
        for (ExtensionRegistryItem extensionItem : extensionItems) {
            IExtension ext = (IExtension)extensionItem.createInstance(owner, extensionStack);
            extensions.addFirst(ext);
        }
        return extensions;
    }

    @Override
    public <T> List<T> createContributionsFor(Object container, Class<T> filterType) {
        if (container == null) {
            throw new IllegalArgumentException("container must not be null.");
        }
        Set<ExtensionRegistryItem> contributionItems = null;
        this.m_readWriteLock.readLock().lock();
        try {
            contributionItems = this.getModelContributionItemsFor(container.getClass());
        }
        finally {
            this.m_readWriteLock.readLock().unlock();
        }
        LinkedList contributions = new LinkedList();
        if (CollectionUtility.isEmpty(contributionItems)) {
            return contributions;
        }
        ExtensionStack extensionStack = this.m_extensionStack.get();
        for (ExtensionRegistryItem item : contributionItems) {
            if (filterType != null && !filterType.isAssignableFrom(item.getExtensionClass())) continue;
            contributions.addFirst(item.createInstance(container, extensionStack));
        }
        return contributions;
    }

    @Override
    public Set<Class<?>> getContributionsFor(Class<?> container) {
        if (container == null) {
            throw new IllegalArgumentException("container must not be null.");
        }
        Set<ExtensionRegistryItem> contributionItems = this.getModelContributionItemsFor(container);
        LinkedHashSet result = new LinkedHashSet(contributionItems.size());
        for (ExtensionRegistryItem item : contributionItems) {
            result.add(item.getExtensionClass());
        }
        return result;
    }

    @Override
    public <T> MoveDescriptor<T> createModelMoveDescriptorFor(T modelObject, Iterator<?> parentModelObjectIterator) {
        if (modelObject == null) {
            throw new IllegalExtensionException("modelObject must not be null.");
        }
        Set<ExtensionRegistryMoveItem> moveItems = null;
        this.m_readWriteLock.readLock().lock();
        try {
            moveItems = this.getModelMoveItemsFor(modelObject.getClass(), parentModelObjectIterator);
        }
        finally {
            this.m_readWriteLock.readLock().unlock();
        }
        if (CollectionUtility.isEmpty(moveItems)) {
            return null;
        }
        ClassIdentifier newContainer = null;
        Double newOrder = null;
        for (ExtensionRegistryMoveItem item : moveItems) {
            if (item.getNewModelContainerClassIdentifier() != null) {
                newContainer = item.getNewModelContainerClassIdentifier();
            }
            if (item.getNewModelOrder() == null) continue;
            newOrder = item.getNewModelOrder();
        }
        return new MoveDescriptor<T>(modelObject, newContainer, newOrder);
    }

    protected <T extends AbstractExtensionRegistryItem> ExtensionScope<T> createGlobalScope(Map<ClassIdentifier, List<T>> registryItems, boolean topDownStrategy) {
        HashMap clonedRegistryItems = new HashMap(registryItems.size());
        for (Map.Entry<ClassIdentifier, List<T>> entry : registryItems.entrySet()) {
            clonedRegistryItems.put(entry.getKey(), new LinkedList(entry.getValue()));
        }
        return new ExtensionScope(clonedRegistryItems, topDownStrategy);
    }

    @Override
    public void pushExtensions(List<? extends IExtension<?>> extensions) {
        ExtensionStack extensionStack = this.m_extensionStack.get();
        if (extensionStack == null) {
            extensionStack = new ExtensionStack();
            this.m_extensionStack.set(extensionStack);
        }
        extensionStack.pushExtensions(extensions);
    }

    @Override
    public void popExtensions(List<? extends IExtension<?>> extensions) {
        ExtensionStack extensionStack = this.m_extensionStack.get();
        if (extensionStack == null) {
            throw new IllegalStateException("popExtensions from empty stack");
        }
        extensionStack.popExtensions(extensions);
        if (extensionStack.isEmpty()) {
            this.m_extensionStack.remove();
        }
    }

    @Override
    public void pushScope(Class<?> scopeClass) {
        ScopeStack scopeStack = this.m_scopeStack.get();
        if (scopeStack == null) {
            scopeStack = new ScopeStack(this.m_globalContributionScope, this.m_globalExtensionScope);
            this.m_scopeStack.set(scopeStack);
        }
        scopeStack.pushScope(scopeClass);
    }

    @Override
    public void popScope() {
        ScopeStack scopeStack = this.m_scopeStack.get();
        if (scopeStack == null) {
            throw new IllegalStateException("popScope from empty stack");
        }
        scopeStack.popScope();
        if (scopeStack.isEmpty()) {
            this.m_scopeStack.remove();
        }
    }
}

