/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.extension.services.common.code;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.commons.annotations.OrderedCollection;
import org.eclipse.scout.commons.annotations.OrderedComparator;
import org.eclipse.scout.rt.shared.extension.AbstractMoveModelObjectHandler;
import org.eclipse.scout.rt.shared.services.common.code.ICode;

public class MoveCodesHandler<CODE_ID, CODE extends ICode<CODE_ID>>
extends AbstractMoveModelObjectHandler<CODE> {
    public MoveCodesHandler(OrderedCollection<CODE> rootModelObjects) {
        super("code", rootModelObjects);
    }

    @Override
    protected CODE getParent(CODE child) {
        return (CODE)child.getParentCode();
    }

    @Override
    protected void removeChild(CODE parent, CODE child) {
        parent.removeChildCodeInternal(child.getId());
    }

    @Override
    protected void addChild(CODE parent, CODE child) {
        parent.addChildCodeInternal(-1, child);
        this.sortChildren(parent);
    }

    @Override
    protected void sortChildren(CODE parent) {
        List childCodes = parent.getChildCodes(false);
        Collections.sort(childCodes, new OrderedComparator());
        int index = 0;
        for (ICode code : childCodes) {
            parent.addChildCodeInternal(index, code);
            ++index;
        }
    }

    @Override
    protected List<CODE> collectAllModelObjects() {
        LinkedList allCodes = new LinkedList();
        this.collectAllCodes((Iterable<? extends CODE>)this.getRootModelObjects(), allCodes);
        return allCodes;
    }

    private void collectAllCodes(Iterable<? extends CODE> codes, List<CODE> allCodes) {
        if (codes == null) {
            return;
        }
        for (ICode code : codes) {
            allCodes.add(code);
            List childCodes = code.getChildCodes(false);
            this.collectAllCodes(childCodes, allCodes);
        }
    }
}

