/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client.config;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.spec.client.internal.Activator;
import org.osgi.framework.Bundle;

public class SpecFileConfig {
    private static final String ADDITIONAL_SOURCE_PLUGINS = "additionalSourcePlugins";
    private static final String SPEC_OUT_DIR_PATH = "target" + File.separator + "spec";
    private static final String SPEC_IN_DIR_PATH = "resources" + File.separator + "spec";
    private static final String CSS_PATH = "resources" + File.separator + "style";
    private static final String DEFAULT_CSS_FILE_NAME = "spec.css";
    private static final String IMAGES_DIR_NAME = "images";
    private static final String MEDIAWIKI_DIR_NAME = "mediawiki";
    private static final String LINKS_FILE_NAME = "links.properties";
    private String[] m_additionalSourcePlugins = new String[0];
    private Bundle m_bundle;
    private static IScoutLogger LOG = ScoutLogManager.getLogger(SpecFileConfig.class);

    public SpecFileConfig() {
        IProduct product = Platform.getProduct();
        if (product != null) {
            this.m_bundle = product.getDefiningBundle();
        }
        this.readAdditionalSourcePluginsFromConfig();
    }

    private void readAdditionalSourcePluginsFromConfig() {
        String parameter = SpecFileConfig.getConfigParameter(ADDITIONAL_SOURCE_PLUGINS);
        this.m_additionalSourcePlugins = StringUtility.split((String)parameter, (String)",");
    }

    private static String getConfigParameter(String parameterName) {
        String commandLineArgumentName = "-" + parameterName + "=";
        String[] stringArray = Platform.getCommandLineArgs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg != null && arg.startsWith(commandLineArgumentName)) {
                return arg.substring(commandLineArgumentName.length());
            }
            ++n2;
        }
        return System.getProperty(parameterName);
    }

    public SpecFileConfig(String pluginName) {
        this.m_bundle = Platform.getBundle((String)pluginName);
    }

    public File getBundleRoot() throws ProcessingException {
        try {
            URL bundleRoot = this.getBundle().getEntry("/");
            URI uri = FileLocator.resolve((URL)bundleRoot).toURI();
            return new File(uri);
        }
        catch (URISyntaxException e) {
            throw new ProcessingException("Bundle Root File not found", (Throwable)e);
        }
        catch (IOException e) {
            throw new ProcessingException("Bundle Root File not found", (Throwable)e);
        }
    }

    public Bundle getBundle() {
        return this.m_bundle;
    }

    public List<Bundle> getSourceBundles() {
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.add(Activator.getDefault().getBundle());
        String[] stringArray = this.m_additionalSourcePlugins;
        int n = this.m_additionalSourcePlugins.length;
        int n2 = 0;
        while (n2 < n) {
            String bundleName = stringArray[n2];
            Bundle bundle = Platform.getBundle((String)bundleName);
            if (bundle != null) {
                arrayList.add(bundle);
            } else {
                LOG.warn("no bundle available with symbolic name: " + bundleName);
            }
            ++n2;
        }
        arrayList.add(this.getBundle());
        return arrayList;
    }

    public File getSpecDir() throws ProcessingException {
        return new File(this.getBundleRoot(), SPEC_OUT_DIR_PATH);
    }

    public File getImageDir() throws ProcessingException {
        return new File(this.getSpecDir(), IMAGES_DIR_NAME);
    }

    public File getHtmlDir() throws ProcessingException {
        return new File(this.getSpecDir(), "html");
    }

    public File getMediawikiDir() throws ProcessingException {
        return new File(this.getSpecDir(), MEDIAWIKI_DIR_NAME);
    }

    public String getRelativeMediawikiSourceDirPath() {
        return String.valueOf(SPEC_IN_DIR_PATH) + File.separator + MEDIAWIKI_DIR_NAME;
    }

    public String getRelativeSourceDirPath() {
        return SPEC_IN_DIR_PATH;
    }

    public String getRelativeImagesSourceDirPath() {
        return String.valueOf(SPEC_IN_DIR_PATH) + File.separator + IMAGES_DIR_NAME;
    }

    public String getRelativeCssDirPath() {
        return CSS_PATH;
    }

    public String getDefaultCssFileName() {
        return DEFAULT_CSS_FILE_NAME;
    }

    public File getLinksFile() throws ProcessingException {
        return new File(this.getSpecDir(), LINKS_FILE_NAME);
    }
}

