/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.testing.client.runner;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.common.session.IClientSessionRegistryService;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.eclipse.scout.rt.testing.commons.ScoutAssert;
import org.eclipse.scout.service.SERVICES;
import org.eclipse.scout.testing.client.IGuiMock;
import org.eclipse.scout.testing.client.IGuiMockService;
import org.eclipse.scout.testing.client.runner.ScoutClientTestRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class ScoutClientGUITestRunner
extends ScoutClientTestRunner {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ScoutClientGUITestRunner.class);

    public ScoutClientGUITestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    @Override
    protected Statement createWrappedStatement(final Statement testStatement, final IClientSession session) {
        return new Statement(){

            public void evaluate() throws Throwable {
                IGuiMockService guiMockService = (IGuiMockService)SERVICES.getService(IGuiMockService.class);
                if (guiMockService == null) {
                    LOG.error("Can not evaluate statement, no IGuiMockService available");
                    return;
                }
                if (session == null) {
                    LOG.error("Can not evaluate statement, no Session available");
                    return;
                }
                IClientSessionRegistryService service = (IClientSessionRegistryService)SERVICES.getService(IClientSessionRegistryService.class);
                UserAgent initUserAgent = guiMockService.initUserAgent();
                IClientSession clientSession = service.newClientSession(session.getClass(), initUserAgent);
                final IGuiMock gui = guiMockService.createMock(clientSession);
                gui.beforeTest();
                try {
                    ClientSyncJob runModelJob = new ClientSyncJob("Run", clientSession){

                        protected void runVoid(IProgressMonitor m) throws Throwable {
                            testStatement.evaluate();
                        }
                    };
                    runModelJob.setUser(false);
                    runModelJob.setSystem(true);
                    ClientSyncJob disposeModelJob = new ClientSyncJob("Dispose", clientSession){

                        protected void runVoid(IProgressMonitor m) throws Throwable {
                        }
                    };
                    disposeModelJob.setUser(false);
                    disposeModelJob.setSystem(true);
                    JobEx guiScriptJob = new JobEx("Gui Script"){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                gui.waitForIdle();
                                return Status.OK_STATUS;
                            }
                            catch (Throwable t) {
                                return new Status(2, ((Object)((Object)ScoutClientGUITestRunner.this)).getClass().getName(), t.getMessage(), t);
                            }
                        }
                    };
                    guiScriptJob.setUser(false);
                    guiScriptJob.setSystem(true);
                    try {
                        runModelJob.schedule();
                        while (!runModelJob.isWaitFor() && runModelJob.getState() != 0) {
                            runModelJob.join(100L);
                        }
                        guiScriptJob.schedule();
                        guiScriptJob.join();
                    }
                    finally {
                        disposeModelJob.schedule();
                        disposeModelJob.join();
                    }
                    runModelJob.join();
                    ScoutAssert.jobSuccessfullyCompleted((JobEx)runModelJob);
                    ScoutAssert.jobSuccessfullyCompleted((JobEx)guiScriptJob);
                    ScoutAssert.jobSuccessfullyCompleted((JobEx)disposeModelJob);
                }
                finally {
                    gui.afterTest();
                }
            }
        };
    }
}

