/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext.busy;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swing.SwingUtility;

public class SwingBusyIndicator {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingBusyIndicator.class);
    private static final AtomicLong BUSY_SEQ = new AtomicLong();
    private static final String BUSY_SET_CLIENT_PROPERTY = "SwingBusyIndicator.busySet";
    private static SwingBusyIndicator instance = new SwingBusyIndicator();
    public static final String BUSY_SUPPORTED_CLIENT_PROPERTY = "SwingBusyIndicator.busySupported";
    public static final String BUSY_CLICKABLE_CLIENT_PROPERTY = "SwingBusyIndicator.busyClickable";
    private final AtomicInteger m_busyLevel = new AtomicInteger();

    public static SwingBusyIndicator getInstance() {
        return instance;
    }

    public static synchronized void setInstance(SwingBusyIndicator newIndicator) {
        if (instance != null) {
            instance.dispose();
        }
        instance = newIndicator;
    }

    public void showWhile(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("must not be called on ui thread");
        }
        try {
            this.m_busyLevel.incrementAndGet();
            ArrayList<RootPaneContainer> lazyHolder = new ArrayList<RootPaneContainer>();
            try {
                this.setBusy(lazyHolder);
                runnable.run();
            }
            finally {
                this.clearBusy(lazyHolder);
            }
        }
        finally {
            this.m_busyLevel.decrementAndGet();
        }
    }

    public boolean isBusy() {
        return this.m_busyLevel.get() > 0;
    }

    public void startBlocking(IProgressMonitor monitor) {
        this.setBlocking(monitor);
    }

    protected void dispose() {
    }

    private void setBusy(final Collection<RootPaneContainer> lazyHolder) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Window[] windows = Window.getWindows();
                if (windows != null) {
                    Window[] windowArray = windows;
                    int n = windows.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Window w = windowArray[n2];
                        RootPaneContainer r = SwingBusyIndicator.this.accept(w);
                        if (r != null && SwingBusyIndicator.this.setBusy0(r)) {
                            lazyHolder.add(r);
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    private void setBlocking(final IProgressMonitor monitor) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Window[] windows = Window.getWindows();
                if (windows != null) {
                    Window[] windowArray = windows;
                    int n = windows.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Window w = windowArray[n2];
                        RootPaneContainer r = SwingBusyIndicator.this.accept(w);
                        if (r != null) {
                            SwingBusyIndicator.this.setBlocking0(r, monitor);
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    private void clearBusy(final Collection<RootPaneContainer> lazyHolder) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (lazyHolder.size() == 0) {
                    return;
                }
                for (RootPaneContainer r : lazyHolder) {
                    SwingBusyIndicator.this.clearBusy0(r);
                }
            }
        });
    }

    private RootPaneContainer accept(Component c) {
        if (c == null) {
            return null;
        }
        if (!c.isVisible()) {
            return null;
        }
        if (!(c instanceof RootPaneContainer)) {
            return null;
        }
        JRootPane rootPane = ((RootPaneContainer)((Object)c)).getRootPane();
        if (rootPane == null) {
            return null;
        }
        if (!Boolean.TRUE.equals(rootPane.getClientProperty(BUSY_SUPPORTED_CLIENT_PROPERTY))) {
            return null;
        }
        return (RootPaneContainer)((Object)c);
    }

    private boolean setBusy0(RootPaneContainer r) {
        JRootPane rootPane = r.getRootPane();
        if (rootPane == null) {
            return false;
        }
        if (rootPane.getClientProperty(BUSY_SET_CLIENT_PROPERTY) != null) {
            return false;
        }
        rootPane.putClientProperty(BUSY_SET_CLIENT_PROPERTY, true);
        BusyGlassPane glass = new BusyGlassPane();
        rootPane.setGlassPane(glass);
        glass.setVisible(true);
        return true;
    }

    private void setBlocking0(RootPaneContainer r, IProgressMonitor monitor) {
        JRootPane rootPane = r.getRootPane();
        if (rootPane == null) {
            return;
        }
        if (rootPane.getGlassPane() instanceof BusyGlassPane) {
            BusyGlassPane glass = (BusyGlassPane)rootPane.getGlassPane();
            glass.block(monitor);
        }
    }

    private void clearBusy0(RootPaneContainer r) {
        JRootPane rootPane = r.getRootPane();
        if (rootPane == null) {
            return;
        }
        rootPane.putClientProperty(BUSY_SET_CLIENT_PROPERTY, null);
        rootPane.setGlassPane(new IdleGlassPane());
        rootPane.getGlassPane().setVisible(false);
    }

    private static class BusyGlassPane
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private IProgressMonitor m_monitor;
        private String m_blockingMessage;
        private Rectangle m_messageRect;

        public BusyGlassPane() {
            this.setVisible(false);
            this.setOpaque(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    JComponent busyClickable;
                    IProgressMonitor mon = BusyGlassPane.this.m_monitor;
                    if (mon == null && (busyClickable = BusyGlassPane.this.getBusyClickable(e)) != null) {
                        BusyGlassPane.this.retargetEvent(e, busyClickable);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    JComponent busyClickable;
                    IProgressMonitor mon = BusyGlassPane.this.m_monitor;
                    if (mon == null && (busyClickable = BusyGlassPane.this.getBusyClickable(e)) != null) {
                        BusyGlassPane.this.retargetEvent(e, busyClickable);
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    IProgressMonitor mon = BusyGlassPane.this.m_monitor;
                    JComponent busyClickable = BusyGlassPane.this.getBusyClickable(e);
                    if (mon == null) {
                        if (busyClickable != null) {
                            BusyGlassPane.this.retargetEvent(e, busyClickable);
                        }
                    } else {
                        Rectangle r = BusyGlassPane.this.m_messageRect;
                        if (!mon.isCanceled() && r != null && r.contains(e.getPoint()) || busyClickable != null) {
                            BusyGlassPane.this.m_blockingMessage = null;
                            mon.setCanceled(true);
                            BusyGlassPane.this.repaint();
                        }
                    }
                }
            });
        }

        private JComponent getBusyClickable(MouseEvent e) {
            if (e.getComponent() == null) {
                return null;
            }
            Window w = SwingUtilities.getWindowAncestor(e.getComponent());
            if (!(w instanceof RootPaneContainer)) {
                return null;
            }
            Point p = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), ((RootPaneContainer)((Object)w)).getContentPane());
            Component c = SwingUtilities.getDeepestComponentAt(((RootPaneContainer)((Object)w)).getContentPane(), p.x, p.y);
            if (!(c instanceof JComponent)) {
                return null;
            }
            Boolean b = (Boolean)((JComponent)c).getClientProperty(SwingBusyIndicator.BUSY_CLICKABLE_CLIENT_PROPERTY);
            if (b != null && b.booleanValue()) {
                return (JComponent)c;
            }
            return null;
        }

        private void retargetEvent(MouseEvent e, JComponent c) {
            MouseEvent retargetEvent = SwingUtilities.convertMouseEvent(e.getComponent(), e, c);
            c.dispatchEvent(retargetEvent);
        }

        public void block(IProgressMonitor monitor) {
            this.m_monitor = monitor;
            this.m_blockingMessage = SwingUtility.getNlsText("BusyBlockingMessage", new String[0]);
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.m_monitor != null) {
                String s = this.m_blockingMessage;
                Window w = SwingUtilities.getWindowAncestor(this);
                if (s != null && w != null && w.isActive()) {
                    Rectangle r;
                    int textWidth = g.getFontMetrics().stringWidth(s);
                    int textHeight = g.getFontMetrics().getAscent();
                    int pad = 8;
                    this.m_messageRect = r = new Rectangle(this.getWidth() / 2 - textWidth / 2 - pad, this.getHeight() * 4 / 5 - (textHeight + pad + pad), textWidth + pad + pad, textHeight + pad + pad);
                    g.setColor(new Color(0x66000000, true));
                    g.fillRoundRect(r.x, r.y, r.width, r.height, pad + pad, pad + pad);
                    g.setColor(Color.white);
                    g.drawString(s, r.x + pad, r.y + pad + textHeight - 2);
                }
            }
        }
    }

    private static class IdleGlassPane
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public IdleGlassPane() {
            this.setName("null.glassPane");
            this.setVisible(false);
            this.setOpaque(false);
        }
    }
}

