/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.table.celleditor;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.scout.commons.BooleanUtility;
import org.eclipse.scout.commons.holders.BooleanHolder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.basic.table.celleditor.TableCellEditor;
import org.eclipse.swt.widgets.TableColumn;

public class TableEditingSupport
extends EditingSupport
implements ICellEditorListener {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(TableEditingSupport.class);
    private ISwtEnvironment m_environment;
    private ITable m_scoutTable;
    private IColumn<?> m_scoutColumn;
    private TableColumn m_swtColumn;

    public TableEditingSupport(TableViewer viewer, TableColumn swtColumn, ISwtEnvironment environment) {
        super((ColumnViewer)viewer);
        this.m_scoutColumn = (IColumn)swtColumn.getData("scoutColumn");
        this.m_swtColumn = swtColumn;
        this.m_scoutTable = this.m_scoutColumn.getTable();
        this.m_environment = environment;
    }

    public TableViewer getViewer() {
        return (TableViewer)super.getViewer();
    }

    protected boolean canEdit(Object element) {
        final ITableRow row = (ITableRow)element;
        final BooleanHolder editable = new BooleanHolder();
        try {
            this.m_environment.invokeScoutLater(new Runnable(){

                @Override
                public void run() {
                    editable.setValue((Object)TableEditingSupport.this.m_scoutTable.isCellEditable(row, TableEditingSupport.this.m_scoutColumn));
                }
            }, 2345L).join(2345L);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting for the model to determine the cell's editability.", (Throwable)e);
        }
        return BooleanUtility.nvl((Boolean)((Boolean)editable.getValue()), (boolean)false);
    }

    protected CellEditor getCellEditor(Object element) {
        TableCellEditor cellEditor = new TableCellEditor(this.getViewer(), this.m_swtColumn, (ITableRow)element, this.m_environment);
        cellEditor.addListener(this);
        return cellEditor;
    }

    protected Object getValue(Object element) {
        return null;
    }

    protected void setValue(Object element, Object value) {
        this.m_environment.invokeScoutLater(new Runnable(){

            @Override
            public void run() {
                TableEditingSupport.this.m_scoutTable.getUIFacade().completeCellEditFromUI();
            }
        }, 0L);
    }

    public void cancelEditor() {
        this.m_environment.invokeScoutLater(new Runnable(){

            @Override
            public void run() {
                TableEditingSupport.this.m_scoutTable.getUIFacade().cancelCellEditFromUI();
            }
        }, 0L);
    }

    public void applyEditorValue() {
    }

    public void editorValueChanged(boolean oldValidState, boolean newValidState) {
    }
}

