/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.busy;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.busy.IBusyHandler;
import org.eclipse.scout.rt.client.busy.IBusyManagerService;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.busy.SwtBusyHandler;
import org.eclipse.scout.rt.ui.swt.window.ISwtScoutPart;
import org.eclipse.scout.rt.ui.swt.window.desktop.editor.AbstractScoutEditorPart;
import org.eclipse.scout.rt.ui.swt.window.desktop.view.AbstractScoutView;
import org.eclipse.scout.rt.ui.swt.window.dialog.SwtScoutDialog;
import org.eclipse.scout.service.SERVICES;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class SwtBusyUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtBusyUtility.class);

    private SwtBusyUtility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showBusyIndicator(final SwtBusyHandler busyHandler, final IRunnableWithProgress runnable, IProgressMonitor monitor) {
        if (!busyHandler.isEnabled()) {
            return;
        }
        final Object lock = new Object();
        final Display display = busyHandler.getDisplay();
        display.asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!busyHandler.isEnabled()) {
                    return;
                }
                try {
                    BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ModalContext.run((IRunnableWithProgress)new IRunnableWithProgress(){

                                    public void run(IProgressMonitor monitor2) throws InvocationTargetException, InterruptedException {
                                        runnable.run(monitor2);
                                    }
                                }, (boolean)true, (IProgressMonitor)new NullProgressMonitor(), (Display)display);
                            }
                            catch (Throwable t) {
                                LOG.warn("run modal context", t);
                            }
                        }
                    });
                }
                catch (Throwable throwable) {
                    Object object = lock;
                    synchronized (object) {
                        lock.notifyAll();
                    }
                    throw throwable;
                }
                Object object = lock;
                synchronized (object) {
                    lock.notifyAll();
                }
            }
        });
        Object object = lock;
        synchronized (object) {
            try {
                lock.wait();
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while waiting for the runnable providing busy feedback to complete.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showWorkbenchIndicator(final SwtBusyHandler busyHandler, final IRunnableWithProgress runnable) {
        if (!busyHandler.isEnabled()) {
            return;
        }
        final Object lock = new Object();
        Display display = busyHandler.getDisplay();
        display.asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block20: {
                    if (!busyHandler.isEnabled()) {
                        return;
                    }
                    IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (activeWorkbenchWindow == null) {
                        return;
                    }
                    try {
                        activeWorkbenchWindow.run(true, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor workbenchJobMonitor) throws InvocationTargetException, InterruptedException {
                                runnable.run(workbenchJobMonitor);
                            }
                        });
                    }
                    catch (InvocationTargetException e) {
                        LOG.warn("Exception while showing workbench busy indicator.", (Throwable)e);
                        Object object = lock;
                        synchronized (object) {
                            lock.notifyAll();
                            break block20;
                        }
                    }
                    catch (InterruptedException e) {
                        Object object;
                        try {
                            LOG.warn("Exception while showing workbench busy indicator.", (Throwable)e);
                            object = lock;
                        }
                        catch (Throwable throwable) {
                            Object object2 = lock;
                            synchronized (object2) {
                                lock.notifyAll();
                            }
                            throw throwable;
                        }
                        synchronized (object) {
                            lock.notifyAll();
                            break block20;
                        }
                    }
                    Object object = lock;
                    synchronized (object) {
                        lock.notifyAll();
                    }
                }
            }
        });
        Object object = lock;
        synchronized (object) {
            try {
                lock.wait();
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while waiting for the runnable blocking the workbench to complete.", (Throwable)e);
            }
        }
    }

    public static boolean isDialogPart(ISwtScoutPart part) {
        return part instanceof SwtScoutDialog;
    }

    public static boolean isViewOrEditorPart(ISwtScoutPart part) {
        return part instanceof AbstractScoutView || part instanceof AbstractScoutEditorPart;
    }

    public static List<ISwtScoutPart> findAffectedParts(ISwtEnvironment env) {
        ArrayList<ISwtScoutPart> candidateParts = new ArrayList<ISwtScoutPart>();
        for (ISwtScoutPart part : env.getOpenFormParts()) {
            if (!SwtBusyUtility.isDialogPart(part) && !SwtBusyUtility.isViewOrEditorPart(part)) continue;
            candidateParts.add(part);
        }
        ArrayList<ISwtScoutPart> affectedParts = new ArrayList<ISwtScoutPart>();
        for (ISwtScoutPart part : candidateParts) {
            if (!part.isActive() || !SwtBusyUtility.isDialogPart(part)) continue;
            affectedParts.add(part);
            return affectedParts;
        }
        for (ISwtScoutPart part : candidateParts) {
            if (!part.isActive() || !SwtBusyUtility.isDialogPart(part)) continue;
            affectedParts.add(part);
            return affectedParts;
        }
        for (ISwtScoutPart part : candidateParts) {
            if (!part.isActive() || !SwtBusyUtility.isViewOrEditorPart(part)) continue;
            affectedParts.addAll(candidateParts);
            affectedParts.remove(part);
            affectedParts.add(0, part);
            return affectedParts;
        }
        affectedParts.add(null);
        affectedParts.addAll(candidateParts);
        return affectedParts;
    }

    public static void asyncIdleExec(final ISwtEnvironment env, final Runnable runnable) {
        final IBusyHandler busyHandler = ((IBusyManagerService)SERVICES.getService(IBusyManagerService.class)).getHandler(env.getClientSession());
        if (!busyHandler.isBlocking()) {
            runnable.run();
        } else {
            Job job = new Job("Wait for blocked workbench to be finish"){

                protected IStatus run(IProgressMonitor monitor) {
                    busyHandler.waitForBlockingToEnd();
                    if (!env.getDisplay().isDisposed()) {
                        env.getDisplay().syncExec(runnable);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.setUser(false);
            job.schedule();
        }
    }
}

