/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.busy.strategy.workbench;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.busy.BusyJob;
import org.eclipse.scout.rt.client.busy.IBusyHandler;
import org.eclipse.scout.rt.shared.TEXTS;
import org.eclipse.scout.rt.ui.swt.busy.SwtBusyHandler;
import org.eclipse.scout.rt.ui.swt.busy.SwtBusyUtility;
import org.eclipse.scout.rt.ui.swt.busy.strategy.workbench.BlockPartsJob;
import org.eclipse.scout.rt.ui.swt.busy.strategy.workbench.BlockWorkbenchJob;
import org.eclipse.scout.rt.ui.swt.window.ISwtScoutPart;

public class WaitForBlockingJob
extends BusyJob {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(WaitForBlockingJob.class);
    private final boolean m_allowBlockWorkbench;
    private List<ISwtScoutPart> m_parts;
    private boolean m_blockWorkbench;

    public WaitForBlockingJob(String name, SwtBusyHandler handler, boolean allowBlockWorkbench) {
        super(name, (IBusyHandler)handler);
        this.m_allowBlockWorkbench = allowBlockWorkbench;
    }

    protected SwtBusyHandler getBusyHandler() {
        return (SwtBusyHandler)super.getBusyHandler();
    }

    protected void runBusy(IProgressMonitor monitor) {
        SwtBusyHandler busyHandler = this.getBusyHandler();
        busyHandler.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                WaitForBlockingJob.this.m_parts = SwtBusyUtility.findAffectedParts(WaitForBlockingJob.this.getBusyHandler().getSwtEnvironment());
                WaitForBlockingJob.this.m_blockWorkbench = WaitForBlockingJob.this.shouldBlockWorkbench(WaitForBlockingJob.this.m_parts.size() > 0 ? (ISwtScoutPart)WaitForBlockingJob.this.m_parts.get(0) : null);
            }
        });
        IRunnableWithProgress busyRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor2) throws InvocationTargetException, InterruptedException {
                WaitForBlockingJob.super.runBusy(monitor2);
            }
        };
        SwtBusyUtility.showBusyIndicator(busyHandler, busyRunnable, monitor);
    }

    protected void runBlocking(IProgressMonitor monitor) {
        if (this.m_blockWorkbench) {
            new BlockWorkbenchJob(TEXTS.get((String)"BusyJob"), this.getBusyHandler()).schedule();
        } else {
            new BlockPartsJob(this.getName(), this.getBusyHandler(), this.m_parts).schedule();
        }
    }

    protected boolean shouldBlockWorkbench(ISwtScoutPart activePart) {
        if (!this.m_allowBlockWorkbench) {
            return false;
        }
        if (activePart == null || activePart.getForm() == null) {
            return true;
        }
        if (activePart.getForm().getDisplayHint() == 0) {
            return false;
        }
        if (activePart.getForm().getDisplayHint() == 12) {
            return false;
        }
        return activePart.getForm().getDisplayHint() != 10;
    }
}

