/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.colorpickerfield;

import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.basic.ColorUtility;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class ColorCanvas
extends Canvas {
    private Color m_color;
    private ISwtEnvironment m_environment;

    public ColorCanvas(Composite parent, ISwtEnvironment environment) {
        super(parent, 2048);
        this.m_environment = environment;
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ColorCanvas.this.disposeResources();
            }
        });
    }

    protected void disposeResources() {
        if (this.m_color != null && !this.m_color.isDisposed()) {
            this.m_color.dispose();
        }
    }

    public ISwtEnvironment getEnvironment() {
        return this.m_environment;
    }

    public void setColor(String hexColor) {
        if (this.m_color != null) {
            this.m_color.dispose();
            this.m_color = null;
        }
        this.m_color = ColorUtility.createColor(this.getDisplay(), hexColor);
        this.setBackground(this.m_color);
    }

    public Color getColor() {
        return this.m_color;
    }
}

