/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.radiobuttongroup.layout;

import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.IRadioButtonGroup;
import org.eclipse.scout.rt.ui.swt.util.SwtLayoutUtility;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RadioButtonGroupLayout
extends Layout {
    private IRadioButtonGroup<?> m_scoutField;
    private int m_hgap;
    private int m_vgap;
    private Control[][] m_buttons;
    private Point[][] m_sizes;

    public RadioButtonGroupLayout(IRadioButtonGroup<?> scoutField, int hgap, int vgap) {
        this.m_scoutField = scoutField;
        this.m_hgap = hgap;
        this.m_vgap = vgap;
    }

    protected Point computeSize(Composite composite, int hint, int hint2, boolean flushCache) {
        this.validateLayout(composite);
        Point result = new Point(0, 0);
        int r = 0;
        while (r < this.m_buttons.length) {
            int w = 0;
            int h = 0;
            int colCount = this.m_buttons[r].length;
            int c = 0;
            while (c < colCount) {
                if (this.m_buttons[r][c] != null) {
                    Point d = this.m_sizes[r][c];
                    w += d.x;
                    h = Math.max(h, d.y);
                }
                ++c;
            }
            result.x = Math.max(result.x, w);
            result.y += h;
            ++r;
        }
        if (this.m_buttons.length > 0) {
            result.x += Math.max(0, this.m_buttons[0].length - 1) * this.m_hgap;
            result.y += Math.max(0, this.m_buttons.length - 1) * this.m_vgap;
        }
        return result;
    }

    protected void validateLayout(Composite parent) {
        int rowCount = Math.max(1, this.m_scoutField.getGridRowCount());
        int colCount = Math.max(1, this.m_scoutField.getGridColumnCount());
        this.m_buttons = new Control[rowCount][colCount];
        this.m_sizes = new Point[rowCount][colCount];
        int index = 0;
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c.getVisible()) {
                Point d;
                this.m_buttons[index / colCount][index % colCount] = c;
                this.m_sizes[index / colCount][index % colCount] = d = SwtLayoutUtility.computeMinimumSize(c, false);
                ++index;
            }
            ++n2;
        }
    }

    protected void layout(Composite composite, boolean flushCache) {
        int colCount;
        if (flushCache) {
            this.validateLayout(composite);
        }
        Rectangle clientArea = composite.getClientArea();
        int w = clientArea.width;
        int h = clientArea.height;
        int rowCount = this.m_buttons.length;
        int n = colCount = rowCount > 0 ? this.m_buttons[0].length : 0;
        if (colCount > 0) {
            int c;
            int[] widths = new int[colCount];
            int[] minWidths = new int[colCount];
            int[] y = new int[rowCount + 1];
            if (this.m_scoutField.getGridData().useUiHeight && this.hasMultilineButtons()) {
                this.calculateYValuesDynamicHeight(y, h, rowCount, colCount, minWidths);
            } else {
                this.calculateYValuesSameHeight(y, h, rowCount, colCount, minWidths);
            }
            int excess = 0;
            int c2 = 0;
            while (c2 < colCount) {
                int candidateWidth = (c2 + 1) * w / colCount - c2 * w / colCount;
                if (minWidths[c2] > candidateWidth) {
                    excess += minWidths[c2] - candidateWidth;
                }
                widths[c2] = Math.max(candidateWidth, minWidths[c2]);
                ++c2;
            }
            while (excess > 0) {
                int shrinkableCount = 0;
                int gcd = Integer.MAX_VALUE;
                c = 0;
                while (c < colCount) {
                    if (widths[c] > minWidths[c]) {
                        ++shrinkableCount;
                        gcd = Math.min(gcd, widths[c] - minWidths[c]);
                    }
                    ++c;
                }
                if (shrinkableCount == 0) break;
                int delta = (Math.min(excess, gcd) + shrinkableCount - 1) / shrinkableCount;
                int c3 = 0;
                while (c3 < colCount && excess > 0) {
                    if (widths[c3] > minWidths[c3]) {
                        int n2 = c3;
                        widths[n2] = widths[n2] - delta;
                        excess -= delta;
                    }
                    ++c3;
                }
            }
            int[] x = new int[colCount + 1];
            int i = 0;
            while (i < widths.length) {
                x[i + 1] = x[i] + widths[i];
                ++i;
            }
            int r = 0;
            while (r < rowCount) {
                c = 0;
                while (c < colCount) {
                    Rectangle bounds = new Rectangle(x[c], y[r], x[c + 1] - x[c], y[r + 1] - y[r] - this.m_vgap);
                    if (this.m_buttons[r][c] != null) {
                        this.m_buttons[r][c].setBounds(bounds);
                    }
                    ++c;
                }
                ++r;
            }
        }
    }

    private boolean hasMultilineButtons() {
        for (IButton button : this.m_scoutField.getButtons()) {
            if (!StringUtility.containsNewLines((String)button.getLabel())) continue;
            return true;
        }
        return false;
    }

    private void calculateYValuesSameHeight(int[] y, int h, int rowCount, int colCount, int[] minWidths) {
        int hWithoutGaps = h - Math.max(0, rowCount - 1) * this.m_vgap;
        y[y.length - 1] = h + this.m_vgap;
        int r = 0;
        while (r < rowCount) {
            int c = 0;
            while (c < colCount) {
                if (this.m_sizes[r][c] != null) {
                    minWidths[c] = Math.max(minWidths[c], this.m_sizes[r][c].x);
                }
                ++c;
            }
            y[r] = r * hWithoutGaps / rowCount + r * this.m_vgap;
            ++r;
        }
    }

    private void calculateYValuesDynamicHeight(int[] y, int h, int rowCount, int colCount, int[] minWidths) {
        y[y.length - 1] = h + this.m_vgap;
        int r = 0;
        while (r < rowCount) {
            int c = 0;
            while (c < colCount) {
                if (this.m_sizes[r][c] != null) {
                    minWidths[c] = Math.max(minWidths[c], this.m_sizes[r][c].x);
                    y[r] = r == 0 ? 0 : y[r - 1] + this.m_sizes[r - 1][c].y + this.m_vgap;
                }
                ++c;
            }
            ++r;
        }
    }
}

