/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.keystroke;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.keystroke.IKeyStrokeManager;
import org.eclipse.scout.rt.ui.swt.keystroke.ISwtKeyStroke;
import org.eclipse.scout.rt.ui.swt.keystroke.ISwtKeyStrokeFilter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class KeyStrokeManager
implements IKeyStrokeManager {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(KeyStrokeManager.class);
    private Listener m_keyListener;
    private ArrayList<ISwtKeyStroke> m_globalKeyStrokes;
    private boolean m_globalKeyStrokesActivated;
    private Object m_globalKeyStrokeListLock;
    private final ISwtEnvironment m_environment;

    public KeyStrokeManager(ISwtEnvironment environment) {
        this.m_environment = environment;
        this.m_globalKeyStrokeListLock = new Object();
        this.m_globalKeyStrokes = new ArrayList();
        this.m_keyListener = new Listener(){

            public void handleEvent(Event event) {
                KeyStrokeManager.this.handleKeyEvent(event);
            }
        };
        PlatformUI.getWorkbench().getDisplay().addFilter(2, this.m_keyListener);
    }

    protected ISwtKeyStroke[] getKeyStrokes(Widget widget) {
        Object data = widget.getData("org.eclipse.scout.rt.ui.swt.keyStrokes");
        ISwtKeyStroke[] keyStrokes = null;
        keyStrokes = data instanceof ISwtKeyStroke[] ? (ISwtKeyStroke[])data : new ISwtKeyStroke[]{};
        return keyStrokes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addGlobalKeyStroke(ISwtKeyStroke stroke) {
        Object object = this.m_globalKeyStrokeListLock;
        synchronized (object) {
            this.m_globalKeyStrokes.add(stroke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeGlobalKeyStroke(ISwtKeyStroke stroke) {
        Object object = this.m_globalKeyStrokeListLock;
        synchronized (object) {
            return this.m_globalKeyStrokes.remove(stroke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISwtKeyStroke[] getGlobalKeyStrokes() {
        Object object = this.m_globalKeyStrokeListLock;
        synchronized (object) {
            return this.m_globalKeyStrokes.toArray(new ISwtKeyStroke[this.m_globalKeyStrokes.size()]);
        }
    }

    @Override
    public void addKeyStroke(Widget widget, ISwtKeyStroke stroke) {
        ISwtKeyStroke[] keyStrokes = (ISwtKeyStroke[])widget.getData("org.eclipse.scout.rt.ui.swt.keyStrokes");
        if (keyStrokes == null) {
            keyStrokes = new ISwtKeyStroke[]{};
        }
        ArrayList<ISwtKeyStroke> list = new ArrayList<ISwtKeyStroke>(Arrays.asList(keyStrokes));
        list.add(stroke);
        widget.setData("org.eclipse.scout.rt.ui.swt.keyStrokes", (Object)list.toArray(new ISwtKeyStroke[list.size()]));
    }

    @Override
    public boolean removeKeyStroke(Widget widget, ISwtKeyStroke stroke) {
        boolean retVal = false;
        ISwtKeyStroke[] keyStrokes = (ISwtKeyStroke[])widget.getData("org.eclipse.scout.rt.ui.swt.keyStrokes");
        if (keyStrokes != null) {
            ArrayList<ISwtKeyStroke> list = new ArrayList<ISwtKeyStroke>(Arrays.asList(keyStrokes));
            retVal = list.remove(stroke);
            widget.setData("org.eclipse.scout.rt.ui.swt.keyStrokes", (Object)list.toArray(new ISwtKeyStroke[list.size()]));
        }
        return retVal;
    }

    protected ISwtKeyStrokeFilter[] getKeyStrokeFilters(Widget widget) {
        ISwtKeyStrokeFilter[] keyStrokeFilters = (ISwtKeyStrokeFilter[])widget.getData("org.eclipse.scout.rt.ui.swt.keyStrokeFilters");
        if (keyStrokeFilters == null) {
            keyStrokeFilters = new ISwtKeyStrokeFilter[]{};
        }
        return keyStrokeFilters;
    }

    @Override
    public void addKeyStrokeFilter(Widget widget, ISwtKeyStrokeFilter stroke) {
        ISwtKeyStrokeFilter[] keyStrokeFilters = (ISwtKeyStrokeFilter[])widget.getData("org.eclipse.scout.rt.ui.swt.keyStrokeFilters");
        if (keyStrokeFilters == null) {
            keyStrokeFilters = new ISwtKeyStrokeFilter[]{};
        }
        ArrayList<ISwtKeyStrokeFilter> list = new ArrayList<ISwtKeyStrokeFilter>(Arrays.asList(keyStrokeFilters));
        list.add(stroke);
        widget.setData("org.eclipse.scout.rt.ui.swt.keyStrokeFilters", (Object)list.toArray(new ISwtKeyStrokeFilter[list.size()]));
    }

    @Override
    public boolean removeKeyStrokeFilter(Widget widget, ISwtKeyStrokeFilter stroke) {
        boolean retVal = false;
        ISwtKeyStrokeFilter[] keyStrokeFilters = (ISwtKeyStrokeFilter[])widget.getData("org.eclipse.scout.rt.ui.swt.keyStrokeFilters");
        if (keyStrokeFilters != null) {
            List<ISwtKeyStrokeFilter> list = Arrays.asList(keyStrokeFilters);
            retVal = list.remove(stroke);
            widget.setData("org.eclipse.scout.rt.ui.swt.keyStrokeFilters", (Object)list.toArray(new ISwtKeyStrokeFilter[list.size()]));
        }
        return retVal;
    }

    private void handleKeyEvent(Event event) {
        Event eventCopy = new Event();
        eventCopy.button = event.button;
        eventCopy.character = event.character;
        eventCopy.count = event.count;
        eventCopy.data = event.data;
        eventCopy.detail = event.detail;
        eventCopy.display = event.display;
        eventCopy.doit = event.doit;
        eventCopy.end = event.end;
        eventCopy.gc = event.gc;
        eventCopy.height = event.height;
        eventCopy.index = event.index;
        eventCopy.item = event.item;
        eventCopy.keyCode = event.keyCode;
        eventCopy.start = event.start;
        eventCopy.stateMask = event.stateMask;
        eventCopy.text = event.text;
        eventCopy.time = event.time;
        eventCopy.type = event.type;
        eventCopy.widget = event.widget;
        eventCopy.width = event.width;
        eventCopy.x = event.x;
        eventCopy.y = event.y;
        this.handleKeyEventHierarchical(eventCopy, event.widget);
        if (eventCopy.doit && this.isGlobalKeyStrokesActivated()) {
            ISwtKeyStroke[] iSwtKeyStrokeArray = this.getGlobalKeyStrokes();
            int n = iSwtKeyStrokeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISwtKeyStroke keyStroke = iSwtKeyStrokeArray[n2];
                if (keyStroke.getKeyCode() == eventCopy.keyCode && keyStroke.getStateMask() == eventCopy.stateMask) {
                    keyStroke.handleSwtAction(eventCopy);
                    if (!eventCopy.doit) break;
                }
                ++n2;
            }
        }
        event.doit = eventCopy.doit;
    }

    private void handleKeyEventHierarchical(Event event, Widget widget) {
        if (widget == null) {
            return;
        }
        Object[] objectArray = this.getKeyStrokeFilters(widget);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISwtKeyStrokeFilter filter = objectArray[n2];
            if (!filter.accept(event, this.m_environment)) {
                return;
            }
            ++n2;
        }
        objectArray = this.getKeyStrokes(widget);
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object keyStroke = objectArray[n2];
            if (keyStroke.getKeyCode() == event.keyCode && keyStroke.getStateMask() == event.stateMask) {
                keyStroke.handleSwtAction(event);
                if (!event.doit) {
                    return;
                }
            }
            ++n2;
        }
        if (widget instanceof Control) {
            this.handleKeyEventHierarchical(event, (Widget)((Control)widget).getParent());
        }
    }

    public boolean isGlobalKeyStrokesActivated() {
        return this.m_globalKeyStrokesActivated;
    }

    public void setGlobalKeyStrokesActivated(boolean globalKeyStrokesActivated) {
        this.m_globalKeyStrokesActivated = globalKeyStrokesActivated;
    }
}

