/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.executor;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.jdt.JavaElementDeleteOperation;
import org.eclipse.scout.sdk.ui.dialog.MemberSelectionDialog;
import org.eclipse.scout.sdk.ui.executor.AbstractExecutor;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.widgets.Shell;

public class LookupCallDeleteExecutor
extends AbstractExecutor {
    private MemberSelectionDialog m_confirmDialog;
    private IType m_lookupCall;
    private Set<IType> m_lookupServices;
    private Set<IType> m_lookupServiceInterfaces;

    @Override
    public boolean canRun(IStructuredSelection selection) {
        this.m_lookupCall = UiUtility.getTypeFromSelection(selection);
        return this.isEditable((IJavaElement)this.m_lookupCall);
    }

    @Override
    public Object run(Shell shell, IStructuredSelection selection, ExecutionEvent event) {
        this.m_confirmDialog = new MemberSelectionDialog(shell, Texts.get((String)"DeleteLookupCall"));
        LinkedHashSet<IMember> members = new LinkedHashSet<IMember>();
        LinkedHashSet<IMember> selectedMembers = new LinkedHashSet<IMember>();
        this.collectAffectedMembers(members, selectedMembers);
        this.m_confirmDialog.setMembers(members);
        this.m_confirmDialog.setSelectedMembers(selectedMembers);
        if (this.m_confirmDialog.open() == 0) {
            JavaElementDeleteOperation op = new JavaElementDeleteOperation(){

                protected void deleteMember(IJavaElement member, Set<ICompilationUnit> icuForOrganizeImports, IProgressMonitor monitor, IWorkingCopyManager manager) throws CoreException {
                    if (member != null && LookupCallDeleteExecutor.this.m_lookupServiceInterfaces.contains(member)) {
                        ScoutUtility.unregisterServiceProxy((IType)((IType)member));
                    }
                    if (member != null && LookupCallDeleteExecutor.this.m_lookupServices.contains(member)) {
                        ScoutUtility.unregisterServiceImplementation((IType)((IType)member));
                    }
                    super.deleteMember(member, icuForOrganizeImports, monitor, manager);
                }
            };
            op.setMembers(this.m_confirmDialog.getSelectedMembers());
            new OperationJob(new IOperation[]{op}).schedule();
        }
        return null;
    }

    protected void collectAffectedMembers(Set<IMember> members, Set<IMember> selectedMembers) {
        members.add((IMember)this.m_lookupCall);
        selectedMembers.add((IMember)this.m_lookupCall);
        IType iService = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.lookup.ILookupService");
        HashSet<IType> types = new HashSet<IType>();
        ICachedTypeHierarchy serviceHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iService);
        String serviceIfcName = this.m_lookupCall.getElementName().replaceAll("^(.*)LookupCall$", "I$1LookupService");
        ITypeFilter serviceIfcFilter = TypeFilters.getMultiTypeFilterAnd((ITypeFilter[])new ITypeFilter[]{TypeFilters.getInterfaceFilter(), TypeFilters.getInWorkspaceFilter(), TypeFilters.getElementNameFilter((String)serviceIfcName), TypeFilters.getTypesOnClasspath((IJavaProject)this.m_lookupCall.getJavaProject())});
        Set allInterfaces = serviceHierarchy.getAllSubtypes(iService, serviceIfcFilter);
        types.addAll(allInterfaces);
        this.m_lookupServiceInterfaces = allInterfaces;
        String serviceName = this.m_lookupCall.getElementName().replaceAll("^(.*)LookupCall$", "$1LookupService");
        IScoutBundle sharedBundle = ScoutTypeUtility.getScoutBundle((IJavaElement)this.m_lookupCall);
        Set visibleServers = sharedBundle.getChildBundles(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"SERVER"}), true);
        ITypeFilter serviceFilter = TypeFilters.getMultiTypeFilterAnd((ITypeFilter[])new ITypeFilter[]{TypeFilters.getClassFilter(), TypeFilters.getInWorkspaceFilter(), TypeFilters.getElementNameFilter((String)serviceName), ScoutTypeFilters.getInScoutBundles((Collection)visibleServers)});
        Set allImplementations = serviceHierarchy.getAllSubtypes(iService, serviceFilter, null);
        types.addAll(allImplementations);
        this.m_lookupServices = allImplementations;
        for (IType ifc : allInterfaces) {
            Set all = TypeUtility.getTypeHierarchy((IType)ifc).getAllSubtypes(ifc, TypeFilters.getInWorkspaceFilter());
            for (IType candidate : all) {
                types.add(candidate);
                if (LookupCallDeleteExecutor.isInterface(candidate)) {
                    this.m_lookupServiceInterfaces.add(candidate);
                    continue;
                }
                this.m_lookupServices.add(candidate);
            }
        }
        members.addAll(types);
    }

    private static boolean isInterface(IType t) {
        try {
            return t.isInterface();
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("Unable to check if type '" + t.getFullyQualifiedName() + "' is an interface or not.", e);
            return false;
        }
    }
}

