/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.executor;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.service.ServiceDeleteOperation;
import org.eclipse.scout.sdk.ui.dialog.IMemberSelectionChangedListener;
import org.eclipse.scout.sdk.ui.dialog.MemberSelectionDialog;
import org.eclipse.scout.sdk.ui.executor.AbstractExecutor;
import org.eclipse.scout.sdk.ui.view.outline.pages.project.server.service.AbstractServiceNodePage;
import org.eclipse.swt.widgets.Shell;

public class ServiceDeleteExecutor
extends AbstractExecutor {
    private IType m_serviceIfc = null;
    private IType m_serviceImpl = null;

    @Override
    public boolean canRun(IStructuredSelection selection) {
        Object selectedElement = selection.getFirstElement();
        if (selectedElement instanceof AbstractServiceNodePage) {
            AbstractServiceNodePage asnp = (AbstractServiceNodePage)selectedElement;
            this.m_serviceIfc = asnp.getInterfaceType();
            this.m_serviceImpl = asnp.getType();
        }
        return this.isEditable((IJavaElement)this.m_serviceImpl);
    }

    @Override
    public Object run(Shell shell, IStructuredSelection selection, ExecutionEvent event) {
        final MemberSelectionDialog confirmDialog = new MemberSelectionDialog(shell, Texts.get((String)"Delete"));
        confirmDialog.addMemberSelectionListener(new IMemberSelectionChangedListener(){

            @Override
            public void handleSelectionChanged(Set<? extends IMember> s) {
                confirmDialog.setMessage("");
                confirmDialog.getOkButton().setEnabled(CollectionUtility.hasElements(s));
            }
        });
        LinkedHashSet<IType> members = new LinkedHashSet<IType>(2);
        if (this.m_serviceIfc != null && !this.m_serviceIfc.isBinary()) {
            members.add(this.m_serviceIfc);
        }
        if (this.m_serviceImpl != null && !this.m_serviceImpl.isBinary()) {
            members.add(this.m_serviceImpl);
        }
        confirmDialog.setMembers(members);
        confirmDialog.setSelectedMembers(members);
        if (confirmDialog.open() == 0) {
            ServiceDeleteOperation deleteOp = new ServiceDeleteOperation();
            for (IMember iMember : confirmDialog.getSelectedMembers()) {
                if (CompareUtility.equals((Object)iMember, (Object)this.m_serviceIfc)) {
                    deleteOp.setServiceInterface(this.m_serviceIfc);
                    continue;
                }
                if (!CompareUtility.equals((Object)iMember, (Object)this.m_serviceImpl)) continue;
                deleteOp.setServiceImplementation(this.m_serviceImpl);
            }
            new OperationJob(new IOperation[]{deleteOp}).schedule();
        }
        return null;
    }
}

