/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.executor;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.ui.executor.AbstractExecutor;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.field.TableFieldNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.page.PageWithTableNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.table.ColumnTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.table.TableNodePage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.scout.sdk.workspace.type.config.ConfigPropertyUpdateOperation;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.scout.sdk.workspace.type.config.parser.IPropertySourceParser;
import org.eclipse.scout.sdk.workspace.type.config.parser.IntegerPropertySourceParser;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class TableColumnWidthsPasteExecutor
extends AbstractExecutor {
    private static final String TABLE_MENU_COLUMN_COPY_CLIPBOARD_IDENTIFIER = "COLUMN_COPY_CLIPBOARD_IDENTIFIER";
    private static final String COLUMN_WIDTH_METHOD_NAME = "getConfiguredWidth";
    private IType m_tableType;
    private String m_stringFromClipboard;

    @Override
    public boolean canRun(IStructuredSelection selection) {
        this.m_stringFromClipboard = this.getStringFromClipboard();
        if (this.isInteresting(this.m_stringFromClipboard)) {
            this.m_tableType = this.getTableType(selection);
            return TypeUtility.exists((IJavaElement)this.m_tableType);
        }
        return false;
    }

    @Override
    public Object run(Shell shell, IStructuredSelection selection, ExecutionEvent event) {
        Map<String, Integer> clipBoardContent = this.parseContent(this.m_stringFromClipboard);
        if (clipBoardContent != null && !clipBoardContent.isEmpty()) {
            try {
                this.changeColumnWidths(this.m_tableType, clipBoardContent, shell);
            }
            catch (CoreException e) {
                ScoutSdkUi.logError("Unable to change column widths.", e);
            }
        } else {
            this.showInfoMessageBox(shell, Texts.get((String)"Action_PasteColumnWidths_InvalidClipboard"));
        }
        return null;
    }

    private void changeColumnWidths(IType tableType, Map<String, Integer> map, Shell shell) throws CoreException {
        LinkedList<ConfigPropertyUpdateOperation> updateOps = new LinkedList<ConfigPropertyUpdateOperation>();
        for (IType innerType : ScoutTypeUtility.getColumns((IType)tableType)) {
            String className = innerType.getFullyQualifiedName();
            Integer columnWidth = map.get(className);
            if (columnWidth != null && columnWidth >= 0) {
                ConfigurationMethod configurationMethod = ScoutTypeUtility.getConfigurationMethod((IType)innerType, (String)COLUMN_WIDTH_METHOD_NAME, (ITypeHierarchy)TypeUtility.getSupertypeHierarchy((IType)innerType), (int)1, (String)"INTEGER");
                ConfigPropertyUpdateOperation updateOp = new ConfigPropertyUpdateOperation(configurationMethod, (IPropertySourceParser)new IntegerPropertySourceParser());
                updateOp.setValue((Object)columnWidth);
                updateOps.add(updateOp);
                continue;
            }
            if (columnWidth == null) continue;
            this.showInfoMessageBox(shell, Texts.get((String)"ColumnWidthPasteInvalidWidth", (String[])new String[]{columnWidth.toString()}));
        }
        if (updateOps.size() > 0) {
            new OperationJob(updateOps).schedule();
        }
    }

    private Map<String, Integer> parseContent(String content) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            content = content.replaceAll("\r", "");
            String[] lines = content.split("\n");
            int i = 1;
            while (i < lines.length) {
                String line = lines[i];
                if (StringUtility.hasText((CharSequence)line)) {
                    String[] parts = line.split("\t");
                    Integer columnWidth = Integer.valueOf(parts[1]);
                    if (columnWidth < 0) {
                        columnWidth = 0;
                    }
                    map.put(parts[0], columnWidth);
                }
                ++i;
            }
            return map;
        }
        catch (Exception e) {
            ScoutSdkUi.logError("Unable to parse column widths", e);
            return null;
        }
    }

    private IType getTableType(IStructuredSelection selection) {
        Object page = selection.getFirstElement();
        IType ret = null;
        if (page instanceof ColumnTablePage) {
            ret = ((ColumnTablePage)page).getColumnDeclaringType();
        } else if (page instanceof PageWithTableNodePage) {
            Set tables = ScoutTypeUtility.getTables((IType)((PageWithTableNodePage)page).getType());
            if (tables.size() > 0) {
                ret = (IType)CollectionUtility.firstElement((Collection)tables);
            }
        } else if (page instanceof TableFieldNodePage) {
            Set tables = ScoutTypeUtility.getTables((IType)((TableFieldNodePage)page).getType());
            if (tables.size() > 0) {
                ret = (IType)CollectionUtility.firstElement((Collection)tables);
            }
        } else if (page instanceof TableNodePage) {
            ret = ((TableNodePage)page).getType();
        }
        return ret;
    }

    private void showInfoMessageBox(Shell s, String message) {
        MessageBox msgBox = new MessageBox(s, 34);
        msgBox.setMessage(message);
        msgBox.open();
    }

    private boolean isInteresting(String content) {
        if (!StringUtility.hasText((CharSequence)content)) {
            return false;
        }
        try {
            Object identifier = TypeUtility.getFieldConstant((IField)TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.basic.table.menus.CopyWidthsOfColumnsMenu").getField(TABLE_MENU_COLUMN_COPY_CLIPBOARD_IDENTIFIER));
            if (identifier instanceof String) {
                return content.startsWith(identifier.toString());
            }
            return false;
        }
        catch (Exception e) {
            ScoutSdkUi.logError("Unable to get the identification constant from the scout class", e);
            return false;
        }
    }

    private String getStringFromClipboard() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Reader reader = DataFlavor.stringFlavor.getReaderForText(clipboard.getContents(null));
            return IOUtility.getContent((Reader)reader, (boolean)true);
        }
        catch (Exception e) {
            ScoutSdkUi.logError("Unable to get content from clipboard", e);
            return null;
        }
    }
}

