/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.proposal.javaelement;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.styled.SearchRangeStyledLabelProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.swt.graphics.Image;

public class JavaElementLabelProvider
extends SearchRangeStyledLabelProvider
implements ITableLabelProvider {
    public String getText(Object element) {
        if (element instanceof IJavaElement) {
            return ((IJavaElement)element).getElementName();
        }
        return null;
    }

    @Override
    public String getTextSelected(Object element) {
        IJavaElement javaElement;
        IJavaElement parentElement;
        StringBuilder textBuilder = new StringBuilder(this.getText(element));
        if (element instanceof IJavaElement && (parentElement = (javaElement = (IJavaElement)element).getParent()) != null) {
            switch (javaElement.getElementType()) {
                case 7: {
                    textBuilder.append(" (");
                    switch (parentElement.getElementType()) {
                        case 7: {
                            textBuilder.append(((IType)parentElement).getFullyQualifiedName());
                            break;
                        }
                        default: {
                            textBuilder.append(parentElement.getAncestor(4).getElementName());
                        }
                    }
                    textBuilder.append(")");
                    break;
                }
                case 8: 
                case 9: {
                    if (parentElement.getElementType() != 7) break;
                    textBuilder.append(" (");
                    textBuilder.append(((IType)parentElement).getFullyQualifiedName());
                    textBuilder.append(")");
                }
            }
        }
        return textBuilder.toString();
    }

    public Image getImage(Object element) {
        if (element instanceof IJavaElement) {
            return ScoutSdkUi.getImage((IJavaElement)element);
        }
        return null;
    }

    @Override
    public Image getImageSelected(Object element) {
        return this.getImage(element);
    }

    public String getColumnText(Object element, int columnIndex) {
        return this.getText(element);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return this.getImage(element);
    }
}

