/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared;

import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.create.PermissionNewAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.PermissionNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;

public class PermissionTablePage
extends AbstractPage {
    private ICachedTypeHierarchy m_basicPermissionHierarchy;

    public PermissionTablePage(AbstractPage parent) {
        this.setParent(parent);
        this.setName(Texts.get((String)"PermissionTablePage"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("permissions.png"));
    }

    @Override
    public void unloadPage() {
        if (this.m_basicPermissionHierarchy != null) {
            this.m_basicPermissionHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
            this.m_basicPermissionHierarchy = null;
        }
    }

    @Override
    public void refresh(boolean clearCache) {
        if (clearCache && this.m_basicPermissionHierarchy != null) {
            this.m_basicPermissionHierarchy.invalidate();
        }
        super.refresh(clearCache);
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.PermissionTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    protected void loadChildrenImpl() {
        IType permission = TypeUtility.getType((String)"java.security.Permission");
        if (TypeUtility.exists((IJavaElement)permission)) {
            if (this.m_basicPermissionHierarchy == null) {
                this.m_basicPermissionHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)permission);
                this.m_basicPermissionHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
            }
            ITypeFilter filter = ScoutTypeFilters.getClassesInScoutBundles((IScoutBundle)this.getScoutBundle());
            Set permissions = this.m_basicPermissionHierarchy.getAllSubtypes(permission, filter, TypeComparators.getTypeNameComparator());
            for (IType type : permissions) {
                new PermissionNodePage(this, type);
            }
        }
    }

    @Override
    public Set<Class<? extends IScoutHandler>> getSupportedMenuActions() {
        return this.newSet(PermissionNewAction.class);
    }
}

