/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.wizard.newbundle;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ScoutBundleNodeGroup;
import org.eclipse.scout.sdk.ui.internal.wizard.newproject.ScoutProjectNewWizardPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class ScoutBundleAddWizardPage
extends ScoutProjectNewWizardPage {
    private final IScoutBundle m_project;
    private final String m_name;
    private final String m_postfix;

    public ScoutBundleAddWizardPage(IScoutBundle project) {
        this.m_project = project;
        this.setTitle(Texts.get((String)"CreateNewScoutBundles"));
        this.setDescription(Texts.get((String)"NewScoutBundlesDesc"));
        String[] parts = ScoutBundleNodeGroup.getBundleBaseNameAndPostfix(project);
        this.m_name = parts[0];
        this.m_postfix = parts[1];
    }

    @Override
    protected IStatus getStatusTargetProject() {
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus getStatusTargetPlatform() {
        return Status.OK_STATUS;
    }

    @Override
    protected void createContent(Composite parent) {
        super.createContent(parent);
        this.m_projectNameField.setText(this.m_name);
        this.m_postFixField.setText(this.m_postfix);
        ((GridData)this.m_eclipseTargetPlatform.getLayoutData()).exclude = true;
        ITreeNode[] backup = this.m_bundleTree.getCheckedNodes();
        this.m_bundleTree.setChecked(new ITreeNode[0]);
        this.m_bundleTree.setChecked(backup);
    }

    public IScoutBundle getProject() {
        return this.m_project;
    }
}

