/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.outline.pages.basic.beanproperty;

import java.util.Comparator;
import java.util.Set;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.create.BeanPropertyNewAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.basic.beanproperty.BeanPropertyNodePage;
import org.eclipse.scout.sdk.util.jdt.IJavaResourceChangedListener;
import org.eclipse.scout.sdk.util.jdt.JdtEvent;
import org.eclipse.scout.sdk.util.jdt.JdtUtility;
import org.eclipse.scout.sdk.util.type.IPropertyBean;
import org.eclipse.scout.sdk.util.type.IPropertyBeanFilter;
import org.eclipse.scout.sdk.util.type.PropertyBeanComparators;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.type.ScoutPropertyBeanFilters;

public class BeanPropertyTablePage
extends AbstractPage {
    private final IType m_declaringType;
    private P_MethodChangedListener m_methodChangedListener;

    public BeanPropertyTablePage(IPage parentPage, IType beanDeclaringType) {
        this.m_declaringType = beanDeclaringType;
        this.setName(Texts.get((String)"BeanPropertyTablePage"));
        this.setParent(parentPage);
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("variables.png"));
    }

    @Override
    public void unloadPage() {
        if (this.m_methodChangedListener != null) {
            ScoutSdkCore.getJavaResourceChangedEmitter().removeMethodChangedListener(this.getDeclaringType(), (IJavaResourceChangedListener)this.m_methodChangedListener);
        }
        super.unloadPage();
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.BeanPropertyTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    public IType getDeclaringType() {
        return this.m_declaringType;
    }

    @Override
    protected void loadChildrenImpl() {
        if (this.m_methodChangedListener == null) {
            this.m_methodChangedListener = new P_MethodChangedListener();
            ScoutSdkCore.getJavaResourceChangedEmitter().addMethodChangedListener(this.getDeclaringType(), (IJavaResourceChangedListener)this.m_methodChangedListener);
        }
        Set beans = TypeUtility.getPropertyBeans((IType)this.getDeclaringType(), (IPropertyBeanFilter)ScoutPropertyBeanFilters.getDtoPropertyFilter(), (Comparator)PropertyBeanComparators.getNameComparator());
        for (IPropertyBean bean : beans) {
            new BeanPropertyNodePage(this, bean);
        }
    }

    @Override
    public Set<Class<? extends IScoutHandler>> getSupportedMenuActions() {
        return this.newSet(BeanPropertyNewAction.class);
    }

    private class P_MethodChangedListener
    implements IJavaResourceChangedListener {
        private P_MethodChangedListener() {
        }

        public void handleEvent(JdtEvent event) {
            if (JdtUtility.hasAnnotation((IAnnotatable)((IAnnotatable)event.getElement()), (String)"org.eclipse.scout.commons.annotations.FormData")) {
                BeanPropertyTablePage.this.markStructureDirty();
            }
        }
    }
}

