/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties.part.multipage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.multi.MultiBooleanPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.multi.MultiIntegerPresenter;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.multi.MultiLongPresenter;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractScoutTypePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.properties.part.ISection;
import org.eclipse.scout.sdk.ui.view.properties.part.multipage.AbstractMultiPageSectionBasedViewPart;
import org.eclipse.scout.sdk.ui.view.properties.presenter.multi.AbstractMultiMethodPresenter;
import org.eclipse.scout.sdk.util.jdt.AbstractElementChangedListener;
import org.eclipse.scout.sdk.workspace.type.config.ConfigPropertyTypeSet;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethodSet;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class JdtTypeMultiPropertyPart
extends AbstractMultiPageSectionBasedViewPart {
    private static final String SECTION_ID_PROPERTIES = "section.properties";
    private final Map<String, AbstractMultiMethodPresenter<?>> m_methodPresenters = new HashMap();
    private IElementChangedListener m_methodChangedListener;
    private ConfigPropertyTypeSet m_configPropertyTypeSet;
    private P_DelayedUpdateJob m_updateJob;

    @Override
    protected void createSections() {
        ArrayList<IType> types = new ArrayList<IType>(this.getPages().length);
        IPage[] iPageArray = this.getPages();
        int n = iPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPage p = iPageArray[n2];
            if (!(p instanceof AbstractScoutTypePage)) {
                return;
            }
            types.add(((AbstractScoutTypePage)p).getType());
            ++n2;
        }
        try {
            this.m_configPropertyTypeSet = new ConfigPropertyTypeSet(types);
            if (this.m_configPropertyTypeSet.hasConfigPropertyMethods()) {
                ISection propertySection = this.createSection(SECTION_ID_PROPERTIES, "Properties");
                for (ConfigurationMethodSet set : this.m_configPropertyTypeSet.getCommonConfigPropertyMethodSets()) {
                    this.createConfigMethodPresenter(propertySection.getSectionClient(), set);
                }
            }
            super.createSections();
            if (this.m_updateJob == null) {
                this.m_updateJob = new P_DelayedUpdateJob(this.getForm().getDisplay());
            }
            if (this.m_methodChangedListener == null) {
                this.m_methodChangedListener = new P_MethodChangedListener2();
                JavaCore.addElementChangedListener((IElementChangedListener)this.m_methodChangedListener);
            }
        }
        catch (CoreException e) {
            ScoutSdkUi.logError("Unable to create multi property part.", e);
        }
    }

    @Override
    public void cleanup() {
        if (this.m_methodChangedListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.m_methodChangedListener);
            this.m_methodChangedListener = null;
        }
        if (this.m_updateJob != null) {
            this.m_updateJob.cancel();
            this.m_updateJob = null;
        }
    }

    protected AbstractMultiMethodPresenter createConfigMethodPresenter(Composite parent, ConfigurationMethodSet methodSet) {
        AbstractMultiMethodPresenter presenter = null;
        String propertyType = methodSet.getConfigAnnotationType();
        if ("BOOLEAN".equals(propertyType)) {
            presenter = new MultiBooleanPresenter(this.getFormToolkit(), parent);
            presenter.setMethodSet(methodSet);
        } else if ("INTEGER".equals(propertyType)) {
            presenter = new MultiIntegerPresenter(this.getFormToolkit(), parent);
            presenter.setMethodSet(methodSet);
        } else if ("LONG".equals(propertyType)) {
            presenter = new MultiLongPresenter(this.getFormToolkit(), parent);
            presenter.setMethodSet(methodSet);
        }
        if (presenter != null) {
            GridData layoutData = new GridData(768);
            layoutData.widthHint = 200;
            presenter.getContainer().setLayoutData((Object)layoutData);
            this.m_methodPresenters.put(methodSet.getMethodName(), presenter);
        } else {
            ScoutSdkUi.logInfo("Could not find a multi presenter for property '" + propertyType + "'.");
        }
        return presenter;
    }

    private void handleMethodChanged(IMethod method) {
        if (this.m_configPropertyTypeSet.isRelevantType(method.getDeclaringType())) {
            try {
                AbstractMultiMethodPresenter<?> presenter;
                ConfigurationMethod updatedMethod = this.m_configPropertyTypeSet.updateIfChanged(method);
                if (updatedMethod != null && (presenter = this.m_methodPresenters.get(updatedMethod.getMethodName())) != null) {
                    this.m_updateJob.update(presenter, this.m_configPropertyTypeSet.getConfigurationMethodSet(updatedMethod.getMethodName()));
                }
            }
            catch (CoreException e) {
                ScoutSdkUi.logError("Unable to update method '" + method.getElementName() + "'.", e);
            }
        }
    }

    private static final class P_DelayedUpdateJob
    extends Job {
        private final Object m_delayedUpdateLock = new Object();
        private final Display m_display;
        private AbstractMultiMethodPresenter m_presenter;
        private ConfigurationMethodSet m_methodSet;

        public P_DelayedUpdateJob(Display display) {
            super("");
            this.m_display = display;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update(AbstractMultiMethodPresenter presenter, ConfigurationMethodSet methodSet) {
            Object object = this.m_delayedUpdateLock;
            synchronized (object) {
                this.cancel();
                this.setName(Texts.get((String)"UpdatePresenterForX", (String[])new String[]{methodSet.getMethodName()}));
                this.m_presenter = presenter;
                this.m_methodSet = methodSet;
                this.schedule(200L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Object object = this.m_delayedUpdateLock;
            synchronized (object) {
                this.m_display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (P_DelayedUpdateJob.this.m_presenter.getContainer() != null && !P_DelayedUpdateJob.this.m_presenter.getContainer().isDisposed()) {
                            P_DelayedUpdateJob.this.m_presenter.setMethodSet(P_DelayedUpdateJob.this.m_methodSet);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        }
    }

    private class P_MethodChangedListener2
    extends AbstractElementChangedListener {
        private P_MethodChangedListener2() {
        }

        protected boolean visit(int kind, int flags, IJavaElement e, CompilationUnit ast) {
            if (e != null && e.getElementType() == 9) {
                JdtTypeMultiPropertyPart.this.handleMethodChanged((IMethod)e);
                return false;
            }
            return super.visit(kind, flags, e, ast);
        }
    }
}

