/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.resources;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.pde.ProductFileModelHelper;
import org.eclipse.scout.sdk.util.resources.IResourceFilter;

public class ResourceFilters {
    private static final IResourceFilter PRODUCT_FILE_FILTER = ResourceFilters.getFileExtensionFilter("product");
    private static final IResourceFilter TARGET_FILE_FILTER = ResourceFilters.getFileExtensionFilter("target");

    protected ResourceFilters() {
    }

    public static IResourceFilter getFileExtensionFilter(String fileExtension) {
        final String ext = "." + fileExtension.toLowerCase().trim();
        return new IResourceFilter(){

            @Override
            public boolean accept(IResourceProxy resource) {
                return resource.getType() == 1 && resource.getName().toLowerCase().endsWith(ext);
            }
        };
    }

    public static IResourceFilter getMultifilterAnd(IResourceFilter ... filters) {
        return ResourceFilters.getMultifilter(false, filters);
    }

    public static IResourceFilter getMultifilterOr(IResourceFilter ... filters) {
        return ResourceFilters.getMultifilter(true, filters);
    }

    private static IResourceFilter getMultifilter(final boolean or, final IResourceFilter ... filters) {
        if (filters == null || filters.length < 1) {
            return null;
        }
        return new IResourceFilter(){

            @Override
            public boolean accept(IResourceProxy candidate) {
                IResourceFilter[] iResourceFilterArray = filters;
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceFilter f = iResourceFilterArray[n2];
                    boolean accepted = f.accept(candidate);
                    if (or == accepted) {
                        return accepted;
                    }
                    ++n2;
                }
                return !or;
            }
        };
    }

    public static IResourceFilter getProductFileFilter() {
        return PRODUCT_FILE_FILTER;
    }

    public static IResourceFilter getTargetFileFilter() {
        return TARGET_FILE_FILTER;
    }

    public static IResourceFilter getProductFileByContentFilter(final boolean or, final String ... pluginOrFeatureIds) {
        IResourceFilter productFileContentFilter = new IResourceFilter(){

            @Override
            public boolean accept(IResourceProxy resource) {
                IFile productFile = (IFile)resource.requestResource();
                try {
                    ProductFileModelHelper pfmh = new ProductFileModelHelper(productFile);
                    String[] stringArray = pluginOrFeatureIds;
                    int n = pluginOrFeatureIds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String id = stringArray[n2];
                        boolean exists = pfmh.ProductFile.existsDependency(id);
                        if (or == exists) {
                            return exists;
                        }
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    SdkUtilActivator.logError("Unable to parse content of product file '" + productFile.getFullPath().toOSString() + "'.", e);
                }
                return !or;
            }
        };
        return ResourceFilters.getMultifilterAnd(ResourceFilters.getProductFileFilter(), productFileContentFilter);
    }
}

