/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.type;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.internal.codeassist.impl.AssistOptions;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.sdk.util.NamingUtility;
import org.eclipse.scout.sdk.util.ScoutSdkUtilCore;
import org.eclipse.scout.sdk.util.ast.AstUtility;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.internal.typecache.HierarchyCache;
import org.eclipse.scout.sdk.util.internal.typecache.TypeCache;
import org.eclipse.scout.sdk.util.signature.IResolvedTypeParameter;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.util.type.FieldFilters;
import org.eclipse.scout.sdk.util.type.IFieldFilter;
import org.eclipse.scout.sdk.util.type.IMethodFilter;
import org.eclipse.scout.sdk.util.type.IPropertyBean;
import org.eclipse.scout.sdk.util.type.IPropertyBeanFilter;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.MethodFilters;
import org.eclipse.scout.sdk.util.type.MethodParameter;
import org.eclipse.scout.sdk.util.type.PropertyBean;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchyResult;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.TypeHierarchyConstraints;

public class TypeUtility {
    public static final String DEFAULT_SOURCE_FOLDER_NAME = "src";
    public static final Pattern BEAN_METHOD_NAME = Pattern.compile("(get|set|is)([A-Z].*)");

    protected TypeUtility() {
    }

    public static IType getType(String typeName) {
        return TypeCache.getInstance().getType(typeName);
    }

    public static Set<IType> getTypes(String typeName) {
        return TypeCache.getInstance().getTypes(typeName);
    }

    public static List<IType> getAllTypes(ICompilationUnit icu, ITypeFilter filter) throws JavaModelException {
        ArrayList<IType> result = new ArrayList<IType>();
        IType[] iTypeArray = icu.getTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            TypeUtility.collectTypesInType(t, result, filter);
            ++n2;
        }
        return result;
    }

    private static void collectTypesInType(IType type, Collection<IType> result, ITypeFilter filter) throws JavaModelException {
        if (filter == null || filter.accept(type)) {
            result.add(type);
        }
        IType[] iTypeArray = type.getTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            TypeUtility.collectTypesInType(t, result, filter);
            ++n2;
        }
    }

    public static boolean existsType(String typeName) {
        return TypeUtility.exists((IJavaElement)TypeUtility.getType(typeName));
    }

    public static IPackageFragmentRoot getSrcPackageFragmentRoot(IJavaProject project) throws JavaModelException {
        return project.findPackageFragmentRoot((IPath)new Path(String.valueOf('/') + project.getElementName() + '/' + DEFAULT_SOURCE_FOLDER_NAME));
    }

    public static IPackageFragment getPackage(IJavaElement element) {
        IPackageFragment packageFragment = (IPackageFragment)element.getAncestor(4);
        return packageFragment;
    }

    public static IPackageFragment getPackage(IJavaProject project, String packageName) throws JavaModelException {
        return TypeUtility.getSrcPackageFragmentRoot(project).getPackageFragment(packageName);
    }

    public static Set<IType> getInnerTypes(IType type) {
        return TypeUtility.getInnerTypes(type, null);
    }

    public static Set<IType> getInnerTypes(IType type, ITypeFilter filter) {
        return TypeUtility.getInnerTypes(type, filter, null);
    }

    public static Set<IType> getInnerTypes(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        IType[] types = null;
        try {
            types = type.getTypes();
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logWarning("could not get inner types of '" + type.getFullyQualifiedName() + "'", e);
            return CollectionUtility.hashSet((Object[])new IType[0]);
        }
        AbstractSet result = null;
        result = comparator == null ? new HashSet(types.length) : new TreeSet<IType>(comparator);
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType subtype = iTypeArray[n2];
            if (filter == null || filter.accept(subtype)) {
                result.add((IType)subtype);
            }
            ++n2;
        }
        return result;
    }

    public static Set<IType> getInnerTypesOrdered(IType declaringType, IType supertype, Comparator<IType> comparator) {
        ITypeHierarchy localTypeHierarchy = TypeUtility.getLocalTypeHierarchy(new IJavaElement[]{declaringType});
        return TypeUtility.getInnerTypesOrdered(declaringType, supertype, comparator, localTypeHierarchy);
    }

    public static Set<IType> getInnerTypesOrdered(IType declaringType, IType supertype, Comparator<IType> comparator, ITypeHierarchy localTypeHierarchy) {
        Set<IType> allSubtypes = TypeUtility.getInnerTypes(declaringType, TypeFilters.getSubtypeFilter(supertype, localTypeHierarchy), comparator);
        return allSubtypes;
    }

    public static IType getTypeBySignature(String signature) {
        if (signature == null) {
            return null;
        }
        if (Signature.getTypeSignatureKind((String)signature) == 3) {
            return null;
        }
        return TypeUtility.getType(SignatureUtility.getFullyQualifiedName(signature));
    }

    public static ITypeHierarchy getLocalTypeHierarchy(Collection<? extends IJavaElement> elements) {
        IRegion region = JavaCore.newRegion();
        if (elements != null) {
            for (IJavaElement iJavaElement : elements) {
                IType t;
                if (!TypeUtility.exists(iJavaElement)) continue;
                if (iJavaElement.getElementType() == 7 && (t = (IType)iJavaElement).isBinary()) {
                    TypeUtility.addBinaryInnerTypesToRegionRec(t, region);
                }
                region.add(iJavaElement);
            }
        }
        return TypeUtility.getLocalTypeHierarchy(region);
    }

    public static ITypeHierarchy getLocalTypeHierarchy(IJavaElement ... elements) {
        return TypeUtility.getLocalTypeHierarchy(CollectionUtility.hashSet((Object[])elements));
    }

    private static void addBinaryInnerTypesToRegionRec(IType declaringType, IRegion region) {
        try {
            IType[] iTypeArray = declaringType.getTypes();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType child = iTypeArray[n2];
                region.add((IJavaElement)child);
                TypeUtility.addBinaryInnerTypesToRegionRec(child, region);
                ++n2;
            }
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logError("Unable to get inner types of type '" + declaringType.getFullyQualifiedName() + "'.", e);
        }
    }

    public static ITypeHierarchy getLocalTypeHierarchy(IRegion region) {
        return HierarchyCache.getInstance().getLocalTypeHierarchy(region);
    }

    public static ITypeHierarchy getSupertypeHierarchy(IType type) {
        return HierarchyCache.getInstance().getSupertypeHierarchy(type);
    }

    public static ICachedTypeHierarchy getTypeHierarchy(IType type) {
        return HierarchyCache.getInstance().getTypeHierarchy(type);
    }

    public static ICachedTypeHierarchy getPrimaryTypeHierarchy(IType type) {
        return HierarchyCache.getInstance().getPrimaryTypeHierarchy(type);
    }

    public static boolean hasInnerType(IType declaringType, String typeName) {
        IType candidate = declaringType.getType(typeName);
        return candidate != null && candidate.exists();
    }

    public static IMethod getMethod(IType declaringType, String methodName, List<String> resolvedParameterSignatures) throws CoreException {
        ArrayList<String> cleanedParameterSignatures = new ArrayList<String>(resolvedParameterSignatures.size());
        for (String sig : resolvedParameterSignatures) {
            cleanedParameterSignatures.add(sig.replaceAll("\\$", "."));
        }
        IMethod[] iMethodArray = declaringType.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            List<String> parameterSignatures;
            IMethod m = iMethodArray[n2];
            if (CompareUtility.equals((Object)m.getElementName(), (Object)methodName) && (parameterSignatures = SignatureUtility.getMethodParameterSignatureResolved(m)).size() == cleanedParameterSignatures.size()) {
                boolean signatureEquals = true;
                int i = 0;
                while (i < parameterSignatures.size()) {
                    if (!CompareUtility.equals((Object)((String)cleanedParameterSignatures.get(i)), (Object)parameterSignatures.get(i))) {
                        signatureEquals = false;
                        break;
                    }
                    ++i;
                }
                if (signatureEquals) {
                    return m;
                }
            }
            ++n2;
        }
        return null;
    }

    public static IMethod findMethodInSuperclassHierarchy(IType type, IMethodFilter filter) {
        return TypeUtility.findMethodInSuperclassHierarchy(type, ScoutSdkUtilCore.getHierarchyCache().getSupertypeHierarchy(type), filter);
    }

    public static IMethod findMethodInSuperclassHierarchy(IType type, ITypeHierarchy hierarchy, IMethodFilter filter) {
        if (TypeUtility.exists((IJavaElement)type)) {
            IMethod method = TypeUtility.getFirstMethod(type, filter);
            if (TypeUtility.exists((IJavaElement)method)) {
                return method;
            }
            return TypeUtility.findMethodInSuperclassHierarchy(hierarchy.getSuperclass(type), hierarchy, filter);
        }
        return null;
    }

    public static IMethod getFirstMethod(IType type, IMethodFilter filter) {
        try {
            IMethod[] iMethodArray = type.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (filter == null || filter.accept(method)) {
                    return method;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            SdkUtilActivator.logWarning("could not get methods of '" + type.getFullyQualifiedName() + "' with filter '" + filter + "'.", e);
        }
        return null;
    }

    public static IMethod getMethod(IType type, String methodName) {
        Set<IMethod> methods = TypeUtility.getMethods(type, MethodFilters.getNameFilter(methodName));
        return (IMethod)CollectionUtility.firstElement(methods);
    }

    public static Set<IMethod> getMethods(IType type) {
        return TypeUtility.getMethods(type, null);
    }

    public static Set<IMethod> getMethods(IType type, IMethodFilter filter) {
        return TypeUtility.getMethods(type, filter, null);
    }

    public static Set<IMethod> getMethods(IType type, IMethodFilter filter, Comparator<IMethod> comparator) {
        try {
            Object[] methods = type.getMethods();
            if (filter == null && comparator == null) {
                return CollectionUtility.hashSet((Object[])methods);
            }
            AbstractSet collector = null;
            collector = comparator == null ? new HashSet(methods.length) : new TreeSet<IMethod>(comparator);
            Object[] objectArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Object method = objectArray[n2];
                if (filter == null || filter.accept((IMethod)method)) {
                    collector.add((IMethod)method);
                }
                ++n2;
            }
            return collector;
        }
        catch (CoreException e) {
            SdkUtilActivator.logWarning("could not get methods of '" + type.getFullyQualifiedName() + "' with filter '" + filter + "'.", e);
            return CollectionUtility.hashSet((Object[])new IMethod[0]);
        }
    }

    public static ISourceRange getContentSourceRange(IMethod method) throws JavaModelException {
        ASTParser parser = AstUtility.newParser();
        parser.setCompilerOptions(method.getJavaProject().getOptions(true));
        parser.setKind(4);
        parser.setSource(method.getSource().toCharArray());
        parser.setResolveBindings(false);
        parser.setBindingsRecovery(false);
        ASTNode rootNode = parser.createAST(null);
        final Holder rangeHolder = new Holder(ISourceRange.class);
        rootNode.accept(new ASTVisitor(){
            boolean a = false;

            public boolean visit(MethodDeclaration node) {
                this.a = true;
                return true;
            }

            public boolean visit(Block node) {
                if (this.a) {
                    rangeHolder.setValue((Object)new SourceRange(node.getStartPosition(), node.getLength()));
                    return false;
                }
                return true;
            }
        });
        ISourceRange methodRelativeRange = (ISourceRange)rangeHolder.getValue();
        if (methodRelativeRange != null) {
            return new SourceRange(methodRelativeRange.getOffset() + method.getSourceRange().getOffset() + 1, methodRelativeRange.getLength() - 2);
        }
        return null;
    }

    public static List<MethodParameter> getMethodParameters(IMethod method, IType contextType) throws CoreException {
        List<String> resolvedParamSignatures;
        String[] paramNames = method.getParameterNames();
        if (paramNames.length != (resolvedParamSignatures = SignatureUtility.getMethodParameterSignatureResolved(method, contextType)).size()) {
            throw new IllegalArgumentException("Could not resolve method parameters of '" + method.getElementName() + "' in '" + method.getDeclaringType().getFullyQualifiedName() + "'.");
        }
        ArrayList<MethodParameter> params = new ArrayList<MethodParameter>(paramNames.length);
        int i = 0;
        while (i < paramNames.length) {
            params.add(new MethodParameter(paramNames[i], resolvedParamSignatures.get(i)));
            ++i;
        }
        return params;
    }

    public static List<MethodParameter> getMethodParameters(IMethod method, Map<String, IResolvedTypeParameter> generics) throws CoreException {
        List<String> resolvedParamSignatures;
        String[] paramNames = method.getParameterNames();
        if (paramNames.length != (resolvedParamSignatures = SignatureUtility.getMethodParameterSignatureResolved(method, generics)).size()) {
            throw new IllegalArgumentException("Could not resolve method parameters of '" + method.getElementName() + "' in '" + method.getDeclaringType().getFullyQualifiedName() + "'.");
        }
        ArrayList<MethodParameter> params = new ArrayList<MethodParameter>(paramNames.length);
        int i = 0;
        while (i < paramNames.length) {
            params.add(new MethodParameter(paramNames[i], resolvedParamSignatures.get(i)));
            ++i;
        }
        return params;
    }

    public static IType getAncestor(IType type, ITypeFilter filter) {
        IType ancestorType = type;
        while (TypeUtility.exists((IJavaElement)ancestorType)) {
            if (filter.accept(ancestorType)) {
                return ancestorType;
            }
            ancestorType = ancestorType.getDeclaringType();
        }
        return null;
    }

    public static Set<IField> getFields(IType declaringType) {
        return TypeUtility.getFields(declaringType, null);
    }

    public static Set<IField> getFields(IType declaringType, IFieldFilter filter) {
        return TypeUtility.getFields(declaringType, filter, null);
    }

    public static Set<IField> getFields(IType declaringType, IFieldFilter filter, Comparator<IField> comparator) {
        try {
            Object[] fields = declaringType.getFields();
            if (filter == null && comparator == null) {
                return CollectionUtility.hashSet((Object[])fields);
            }
            AbstractSet collector = null;
            collector = comparator == null ? new HashSet(fields.length) : new TreeSet<IField>(comparator);
            Object[] objectArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Object field = objectArray[n2];
                if (filter == null || filter.accept((IField)field)) {
                    collector.add((IField)field);
                }
                ++n2;
            }
            return collector;
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logWarning("could not get fields of '" + declaringType.getElementName() + "'.", e);
            return CollectionUtility.hashSet((Object[])new IField[0]);
        }
    }

    public static IField getFirstField(IType type, IFieldFilter filter) {
        try {
            IField[] iFieldArray = type.getFields();
            int n = iFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                IField method = iFieldArray[n2];
                if (filter == null || filter.accept(method)) {
                    return method;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logWarning("could not get methods of '" + type.getFullyQualifiedName() + "'.", e);
        }
        return null;
    }

    public static Object getFieldConstant(IField field) throws JavaModelException {
        Object val = field.getConstant();
        if (val instanceof String) {
            String ret = (String)val;
            if ((ret = ret.trim()).length() > 2 && ret.charAt(0) == '\"' && ret.charAt(ret.length() - 1) == '\"') {
                ret = ret.substring(1, ret.length() - 1);
            }
            return ret;
        }
        return val;
    }

    public static IMethod getOverwrittenMethod(IMethod method, ITypeHierarchy supertypeHierarchy) {
        IType supertype = supertypeHierarchy.getSuperclass(method.getDeclaringType());
        IMethodFilter overrideFilter = MethodFilters.getSuperMethodFilter(method);
        while (supertype != null) {
            IMethod superMethod = TypeUtility.getFirstMethod(supertype, overrideFilter);
            if (superMethod != null) {
                return superMethod;
            }
            supertype = supertypeHierarchy.getSuperclass(supertype);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static IType getPrimaryType(IJavaElement e) {
        if (!TypeUtility.exists(e)) {
            return null;
        }
        surroundingType = null;
        if (e.getElementType() == 7) {
            surroundingType = (IType)e;
        } else if (e.getElementType() == 5) {
            try {
                types = ((ICompilationUnit)e).getTypes();
                if (types == null || types.length != 1) ** GOTO lbl17
                surroundingType = types[0];
            }
            catch (JavaModelException e1) {
                SdkUtilActivator.logError("Unable to retrieve types of icu '" + e.getElementName() + "'.", e1);
                return null;
            }
        } else {
            surroundingType = e.getElementType() == 6 ? ((IClassFile)e).getType() : (IType)e.getAncestor(7);
        }
lbl17:
        // 4 sources

        if (!TypeUtility.exists((IJavaElement)surroundingType)) {
            return null;
        }
        result = null;
        tmp = surroundingType;
        while (tmp != null && tmp.exists()) {
            result = tmp;
            tmp = tmp.getDeclaringType();
        }
        return result;
    }

    public static boolean exists(IJavaElement element) {
        return element != null && element.exists();
    }

    public static IType findInnerType(IType type, String innerTypeName) throws JavaModelException {
        if (!TypeUtility.exists((IJavaElement)type)) {
            return null;
        }
        if (CompareUtility.equals((Object)type.getElementName(), (Object)innerTypeName)) {
            return type;
        }
        IType[] iTypeArray = type.getTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType innerType = iTypeArray[n2];
            IType found = TypeUtility.findInnerType(innerType, innerTypeName);
            if (found != null) {
                return found;
            }
            ++n2;
        }
        return null;
    }

    public static String getReferencedTypeFqn(IType declaringType, String typeName, boolean searchOnClassPath) throws JavaModelException {
        IJavaProject javaProject;
        String[][] resolvedTypeName;
        ICompilationUnit compilationUnit = declaringType.getCompilationUnit();
        if (compilationUnit != null) {
            IImportDeclaration[] imports;
            String searchString = String.valueOf('.') + typeName;
            IImportDeclaration[] iImportDeclarationArray = imports = compilationUnit.getImports();
            int n = imports.length;
            int n2 = 0;
            while (n2 < n) {
                IImportDeclaration imp = iImportDeclarationArray[n2];
                if (imp.getElementName().endsWith(searchString)) {
                    return imp.getElementName();
                }
                ++n2;
            }
        }
        if ((resolvedTypeName = declaringType.resolveType(typeName)) != null && resolvedTypeName.length == 1) {
            String pck = resolvedTypeName[0][0];
            StringBuilder fqName = new StringBuilder();
            if (pck != null && pck.length() > 0) {
                fqName.append(pck);
                fqName.append('.');
            }
            fqName.append(resolvedTypeName[0][1]);
            return fqName.toString();
        }
        if (searchOnClassPath && TypeUtility.exists((IJavaElement)(javaProject = declaringType.getJavaProject()))) {
            Set<IType> candidates = TypeUtility.getTypes(typeName);
            Iterator<IType> iterator = candidates.iterator();
            while (iterator.hasNext()) {
                IType cur = iterator.next();
                if (TypeUtility.isOnClasspath((IJavaElement)cur, javaProject)) continue;
                iterator.remove();
            }
            if (candidates.size() == 1) {
                return ((IType)CollectionUtility.firstElement(candidates)).getFullyQualifiedName();
            }
        }
        return null;
    }

    public static IType getReferencedType(IType declaringType, String typeName, boolean searchOnClassPath) throws JavaModelException {
        String referencedTypeFqn = TypeUtility.getReferencedTypeFqn(declaringType, typeName, searchOnClassPath);
        if (referencedTypeFqn != null) {
            return TypeUtility.getType(referencedTypeFqn);
        }
        return null;
    }

    public static boolean isGenericType(IType type) {
        if (TypeUtility.exists((IJavaElement)type)) {
            try {
                return type.getTypeParameters().length > 0;
            }
            catch (JavaModelException e) {
                SdkUtilActivator.logError("Unable to parse type parameters of type '" + type + "'.", e);
            }
        }
        return false;
    }

    public static IType getMoreSpecificType(IType a, IType b) {
        if (!TypeUtility.exists((IJavaElement)a) && !TypeUtility.exists((IJavaElement)b)) {
            return null;
        }
        if (!TypeUtility.exists((IJavaElement)a)) {
            return b;
        }
        if (!TypeUtility.exists((IJavaElement)b)) {
            return a;
        }
        if (ScoutSdkUtilCore.getHierarchyCache().getSupertypeHierarchy(a).contains(b)) {
            return a;
        }
        if (ScoutSdkUtilCore.getHierarchyCache().getSupertypeHierarchy(b).contains(a)) {
            return b;
        }
        return null;
    }

    public static ICachedTypeHierarchyResult getAbstractTypesOnClasspathHierarchy(IType hierarchyBaseType, IJavaProject project) {
        TypeHierarchyConstraints constraints = new TypeHierarchyConstraints(hierarchyBaseType, project);
        constraints.modifiersNotSet(512, 0x100000).modifiersSet(1024, 1);
        ICachedTypeHierarchyResult h = HierarchyCache.getInstance().getProjectContextTypeHierarchy(constraints);
        return h;
    }

    public static Set<IType> getAbstractTypesOnClasspath(IType hierarchyBaseType, IJavaProject project, ITypeFilter filter) {
        ICachedTypeHierarchyResult h = TypeUtility.getAbstractTypesOnClasspathHierarchy(hierarchyBaseType, project);
        return h.getAllTypes(filter, TypeComparators.getTypeNameComparator());
    }

    public static Set<IType> getClassesOnClasspath(IType supertype, IJavaProject project, ITypeFilter filter) {
        TypeHierarchyConstraints constraints = new TypeHierarchyConstraints(supertype, project);
        constraints.modifiersNotSet(1024, 0x100000, 512);
        ICachedTypeHierarchyResult h = HierarchyCache.getInstance().getProjectContextTypeHierarchy(constraints);
        return h.getAllTypes(filter, TypeComparators.getTypeNameComparator());
    }

    public static Set<IType> getInterfacesOnClasspath(IType supertype, IJavaProject project, ITypeFilter filter) {
        TypeHierarchyConstraints constraints = new TypeHierarchyConstraints(supertype, project);
        constraints.modifiersSet(512);
        ICachedTypeHierarchyResult h = HierarchyCache.getInstance().getProjectContextTypeHierarchy(constraints);
        return h.getAllTypes(filter, TypeComparators.getTypeNameComparator());
    }

    public static boolean isOnClasspath(IJavaElement element, IJavaProject project) {
        IMember member;
        if (!TypeUtility.exists(element)) {
            return false;
        }
        if (!TypeUtility.exists((IJavaElement)project)) {
            return false;
        }
        if (element instanceof IMember && (member = (IMember)element).isBinary()) {
            return project.isOnClasspath((IJavaElement)member);
        }
        IJavaProject elemenProject = element.getJavaProject();
        if (elemenProject != null) {
            if (project.equals(elemenProject)) {
                return true;
            }
            return project.isOnClasspath((IJavaElement)elemenProject);
        }
        return project.isOnClasspath(element);
    }

    public static Set<? extends IPropertyBean> getPropertyBeans(IType type, IPropertyBeanFilter propertyFilter, Comparator<IPropertyBean> comparator) {
        IMethodFilter filter = MethodFilters.getMultiMethodFilter(MethodFilters.getFlagsFilter(1), MethodFilters.getNameRegexFilter(BEAN_METHOD_NAME));
        Set<IMethod> methods = TypeUtility.getMethods(type, filter);
        HashMap<Object, PropertyBean> beans = new HashMap<Object, PropertyBean>(methods.size());
        for (IMethod m : methods) {
            Matcher matcher = BEAN_METHOD_NAME.matcher(m.getElementName());
            if (!matcher.matches()) continue;
            try {
                PropertyBean desc;
                String kind = matcher.group(1);
                String name = matcher.group(2);
                String[] parameterTypes = m.getParameterTypes();
                String returnType = m.getReturnType();
                if ("get".equals(kind) && parameterTypes.length == 0 && !returnType.equals("V")) {
                    desc = (PropertyBean)beans.get(name);
                    if (desc == null) {
                        desc = new PropertyBean(type, name);
                        beans.put(name, desc);
                    }
                    if (desc.getReadMethod() != null) continue;
                    desc.setReadMethod(m);
                    continue;
                }
                if ("is".equals(kind) && parameterTypes.length == 0 && returnType.equals("Z")) {
                    desc = (PropertyBean)beans.get(name);
                    if (desc == null) {
                        desc = new PropertyBean(type, name);
                        beans.put(name, desc);
                    }
                    if (desc.getReadMethod() != null) continue;
                    desc.setReadMethod(m);
                    continue;
                }
                if (!"set".equals(kind) || parameterTypes.length != 1 || !returnType.equals("V")) continue;
                desc = (PropertyBean)beans.get(name);
                if (desc == null) {
                    desc = new PropertyBean(type, name);
                    beans.put(name, desc);
                }
                if (desc.getWriteMethod() != null) continue;
                desc.setWriteMethod(m);
            }
            catch (JavaModelException e) {
                SdkUtilActivator.logError("Error while collectiong property beans of type [" + type + "]", e);
            }
        }
        AbstractSet filteredBeans = null;
        filteredBeans = comparator == null ? new HashSet(beans.size()) : new TreeSet<IPropertyBean>(comparator);
        for (PropertyBean bean : beans.values()) {
            if (propertyFilter != null && !propertyFilter.accept(bean)) continue;
            filteredBeans.add((IPropertyBean)bean);
        }
        Set<IField> fieldCandidates = TypeUtility.getFields(type, FieldFilters.getPrivateNotStaticNotFinalNotAbstract(), null);
        HashMap<String, IField> fields = new HashMap<String, IField>(fieldCandidates.size());
        for (IField field : fieldCandidates) {
            fields.put(field.getElementName(), field);
        }
        AssistOptions assistOptions = new AssistOptions(type.getJavaProject().getOptions(true));
        Set<String> fieldPrefixes = TypeUtility.toStringSet(assistOptions.fieldPrefixes, "m_", "");
        Set<String> fieldSuffixes = TypeUtility.toStringSet(assistOptions.fieldSuffixes, "");
        for (PropertyBean bean : filteredBeans) {
            IField field = TypeUtility.findFieldForPropertyBean(bean.getBeanName(), fields, fieldPrefixes, fieldSuffixes);
            if (field != null) {
                bean.setField(field);
                continue;
            }
            SdkUtilActivator.logWarning("Unable to find field for property bean [" + bean + "]");
        }
        return filteredBeans;
    }

    public static boolean isAncestor(IJavaElement parent, IJavaElement child) {
        if (parent == null || child == null) {
            return false;
        }
        if (parent.equals(child)) {
            return true;
        }
        if (child.getParent() != null && child.getParent().getElementType() >= parent.getElementType()) {
            return TypeUtility.isAncestor(parent, child.getParent().getAncestor(parent.getElementType()));
        }
        return false;
    }

    public static int getIndent(IJavaElement element) {
        int indent = 0;
        IJavaElement visitedElement = element;
        while (visitedElement.getElementType() != 5) {
            ++indent;
            visitedElement = element.getParent();
        }
        return indent;
    }

    public static IMethod findMethodInSupertypeHierarchy(String methodName, IType type, ITypeHierarchy supertypeHierarchy) {
        return TypeUtility.findMethodInSupertypeHierarchy(type, supertypeHierarchy, MethodFilters.getNameFilter(methodName));
    }

    public static IMethod findMethodInSupertypeHierarchy(IType type, ITypeHierarchy supertypeHierarchy, IMethodFilter filter) {
        Set<IMethod> methods = TypeUtility.getMethods(type, filter);
        IMethod method = null;
        IMethod first = (IMethod)CollectionUtility.firstElement(methods);
        if (methods.size() == 1) {
            return first;
        }
        if (methods.size() > 1) {
            StringBuilder sb = new StringBuilder(" [\n");
            for (IMethod m : methods) {
                if (m != first) {
                    sb.append(",\n");
                }
                sb.append("\t\t").append(m.toString());
            }
            sb.append("\n\t]");
            SdkUtilActivator.logWarning("found more than one method in hierarchy" + sb.toString());
            return first;
        }
        IType supertype = supertypeHierarchy.getSuperclass(type);
        if (TypeUtility.exists((IJavaElement)supertype) && !supertype.getElementName().equals(Object.class.getName())) {
            method = TypeUtility.findMethodInSupertypeHierarchy(supertype, supertypeHierarchy, filter);
        }
        if (TypeUtility.exists(method)) {
            return method;
        }
        for (IType intType : supertypeHierarchy.getSuperInterfaces(type)) {
            if (TypeUtility.exists((IJavaElement)intType) && !intType.getElementName().equals(Object.class.getName())) {
                method = TypeUtility.findMethodInSupertypeHierarchy(intType, supertypeHierarchy, filter);
            }
            if (!TypeUtility.exists((IJavaElement)method)) continue;
            return method;
        }
        return null;
    }

    private static IField findFieldForPropertyBean(String beanName, HashMap<String, IField> fields, Set<String> fieldPrefixes, Set<String> fieldSuffixes) {
        for (String prefix : fieldPrefixes) {
            for (String suffix : fieldSuffixes) {
                IField field = fields.get(String.valueOf(prefix) + NamingUtility.ensureStartWithLowerCase(beanName) + suffix);
                if (!TypeUtility.exists((IJavaElement)field)) continue;
                return field;
            }
        }
        return null;
    }

    private static Set<String> toStringSet(char[][] arrayOfChars, String ... additionalValues) {
        int n;
        int n2;
        Object object;
        HashSet<String> result = new HashSet<String>();
        if (additionalValues != null) {
            object = additionalValues;
            n2 = additionalValues.length;
            n = 0;
            while (n < n2) {
                String s = object[n];
                result.add(s);
                ++n;
            }
        }
        if (arrayOfChars != null) {
            object = arrayOfChars;
            n2 = arrayOfChars.length;
            n = 0;
            while (n < n2) {
                String cs = object[n];
                if (cs != null && ((String)cs).length > 0) {
                    result.add(String.valueOf((char[])cs));
                }
                ++n;
            }
        }
        return result;
    }
}

