/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package org.eclipse.scout.commons.holders;

import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

/**
 * @since 3.0
 */

public final class HolderUtility {
  private static final IScoutLogger LOG = ScoutLogManager.getLogger(HolderUtility.class);

  private HolderUtility() {
  }

  public static boolean containEqualValues(IHolder a, IHolder b) {
    Object va = a.getValue();
    Object vb = b.getValue();
    return CompareUtility.equals(va, vb);
  }

  public static <T> void setAndCastValue(IHolder<T> h, Object value) {
    if (h == null) {
      /* nop */
    }
    else {
      h.setValue(TypeCastUtility.castValue(value, h.getHolderType()));
    }
  }

  /**
   * when passing IHolder values to remote services it is necessary to create a
   * value copy of the holder for serialization
   */
  public static <T> IHolder<T> createSerializableHolder(IHolder<T> h) {
    if (h == null) {
      return null;
    }
    return new Holder<T>(h.getHolderType(), h.getValue());
  }

}
