/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.osgi.BundleListClassLoader;
import org.eclipse.scout.commons.serialization.IObjectReplacer;
import org.osgi.framework.Bundle;

public class BundleObjectInputStream
extends ObjectInputStream {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BundleObjectInputStream.class);
    private final ClassLoader m_classLoader;
    private final IObjectReplacer m_objectReplacer;

    public BundleObjectInputStream(InputStream in, Bundle[] bundleList) throws IOException {
        this(in, new BundleListClassLoader(null, bundleList), null);
    }

    public BundleObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
        this(in, classLoader, null);
    }

    public BundleObjectInputStream(InputStream in, ClassLoader classLoader, IObjectReplacer objectReplacer) throws IOException {
        super(in);
        if (classLoader == null) {
            throw new IllegalArgumentException("classLoader must not be null");
        }
        this.m_classLoader = classLoader;
        this.m_objectReplacer = objectReplacer;
        this.enableResolveObject(true);
    }

    @Override
    public Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        return this.m_classLoader.loadClass(desc.getName());
    }

    @Override
    protected Object resolveObject(Object obj) throws IOException {
        if (this.m_objectReplacer != null) {
            return this.m_objectReplacer.resolveObject(obj);
        }
        return super.resolveObject(obj);
    }
}

