/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.parsers.sql;

import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.parsers.sql.SqlParser;
import org.eclipse.scout.commons.parsers.sql.SqlParserToken;

public class SqlFormatter {
    private static IScoutLogger logger = ScoutLogManager.getLogger(SqlFormatter.class);

    public static String wellform(String s) {
        return new SqlFormatter().wellform(s, 10);
    }

    public String wellform(String s, int tabSize) {
        SqlParserToken.Statement stm = new SqlParser().parse(s);
        FormatContext ctx = new FormatContext(tabSize);
        this.formatStatement(stm, ctx);
        return ctx.getBuffer().trim();
    }

    private void formatStatement(SqlParserToken.Statement stm, FormatContext ctx) {
        if (stm != null) {
            for (SqlParserToken.IToken t : stm.getChildren()) {
                if (t instanceof SqlParserToken.Statement) {
                    this.formatStatement((SqlParserToken.Statement)t, ctx);
                    continue;
                }
                if (t instanceof SqlParserToken.SingleStatement) {
                    this.formatSingleStatement((SqlParserToken.SingleStatement)t, ctx);
                    continue;
                }
                if (t instanceof SqlParserToken.BracketExpr) {
                    this.formatBracketExpr((SqlParserToken.BracketExpr)t, ctx);
                    continue;
                }
                if (t instanceof SqlParserToken.UnionToken) {
                    this.formatDefault(t, ctx);
                    ctx.println();
                    continue;
                }
                if (t instanceof SqlParserToken.Unparsed) {
                    ctx.println("*** UNPARSED ***");
                    this.formatDefault(t, ctx);
                    ctx.println();
                    continue;
                }
                this.formatDefault(t, ctx);
            }
        }
    }

    private void formatSingleStatement(SqlParserToken.SingleStatement stm, FormatContext ctx) {
        for (SqlParserToken.IToken t : stm.getChildren()) {
            if (t instanceof SqlParserToken.Part) {
                this.formatPart((SqlParserToken.Part)t, ctx);
                continue;
            }
            this.formatDefault(t, ctx);
        }
    }

    private void formatPart(SqlParserToken.Part stm, FormatContext ctx) {
        boolean hasList = false;
        for (SqlParserToken.IToken t : stm.getChildren()) {
            if (t instanceof SqlParserToken.PartToken) {
                this.formatDefault(t, ctx);
                continue;
            }
            if (t instanceof SqlParserToken.Part) {
                ctx.in();
                this.formatPart((SqlParserToken.Part)t, ctx);
                ctx.out();
                continue;
            }
            if (t instanceof SqlParserToken.ListExpr) {
                hasList = true;
                ctx.in();
                this.formatListExpr((SqlParserToken.ListExpr)t, true, ctx);
                ctx.out();
                continue;
            }
            this.formatDefault(t, ctx);
        }
        if (!hasList) {
            ctx.in();
            ctx.print(" ");
            ctx.out();
        }
    }

    private void formatListExpr(SqlParserToken.ListExpr stm, boolean multiline, FormatContext ctx) {
        for (SqlParserToken.IToken t : stm.getChildren()) {
            if (t instanceof SqlParserToken.OrExpr) {
                this.formatOrExpr((SqlParserToken.OrExpr)t, ctx);
                continue;
            }
            if (t instanceof SqlParserToken.ListSeparator) {
                this.formatDefault(t, ctx);
                if (multiline) {
                    ctx.println();
                    continue;
                }
                ctx.print(" ");
                continue;
            }
            this.formatDefault(t, ctx);
        }
    }

    private void formatOrExpr(SqlParserToken.OrExpr stm, FormatContext ctx) {
        for (SqlParserToken.IToken t : stm.getChildren()) {
            if (t instanceof SqlParserToken.AndExpr) {
                this.formatAndExpr((SqlParserToken.AndExpr)t, ctx);
                continue;
            }
            if (t instanceof SqlParserToken.OrOp) {
                ctx.println();
                this.formatDefault(t, ctx);
                ctx.println();
                continue;
            }
            this.formatDefault(t, ctx);
        }
    }

    private void formatAndExpr(SqlParserToken.AndExpr stm, FormatContext ctx) {
        for (SqlParserToken.IToken t : stm.getChildren()) {
            if (t instanceof SqlParserToken.MathExpr) {
                this.formatMathExpr((SqlParserToken.MathExpr)t, ctx);
                continue;
            }
            if (t instanceof SqlParserToken.AndOp) {
                ctx.println();
                this.formatDefault(t, ctx);
                ctx.print(" ");
                continue;
            }
            this.formatDefault(t, ctx);
        }
    }

    private void formatMathExpr(SqlParserToken.MathExpr stm, FormatContext ctx) {
        for (SqlParserToken.IToken t : stm.getChildren()) {
            if (!(t instanceof SqlParserToken.MathOp)) {
                this.formatSimpleExpr(t, ctx);
                continue;
            }
            if (t instanceof SqlParserToken.MathOp) {
                ctx.print(" ");
                this.formatDefault(t, ctx);
                ctx.print(" ");
                continue;
            }
            this.formatDefault(t, ctx);
        }
    }

    private void formatSimpleExpr(SqlParserToken.IToken stm, FormatContext ctx) {
        SqlParserToken.IToken t = stm;
        if (t instanceof SqlParserToken.UnaryPrefixExpr) {
            this.formatUnaryPrefixExpr((SqlParserToken.UnaryPrefixExpr)t, ctx);
        } else if (t instanceof SqlParserToken.MinusExpr) {
            this.formatMinusExpr((SqlParserToken.MinusExpr)t, ctx);
        } else if (t instanceof SqlParserToken.Atom) {
            this.formatAtom((SqlParserToken.Atom)t, ctx);
        } else {
            this.formatDefault(t, ctx);
        }
    }

    private void formatUnaryPrefixExpr(SqlParserToken.UnaryPrefixExpr stm, FormatContext ctx) {
        for (SqlParserToken.IToken t : stm.getChildren()) {
            if (t instanceof SqlParserToken.UnaryPrefix) {
                this.formatDefault(t, ctx);
                ctx.print(" ");
                continue;
            }
            if (t instanceof SqlParserToken.Atom) {
                this.formatAtom((SqlParserToken.Atom)t, ctx);
                continue;
            }
            this.formatDefault(t, ctx);
        }
    }

    private void formatMinusExpr(SqlParserToken.MinusExpr stm, FormatContext ctx) {
        for (SqlParserToken.IToken t : stm.getChildren()) {
            if (t instanceof SqlParserToken.MathOp) {
                this.formatDefault(t, ctx);
                continue;
            }
            if (t instanceof SqlParserToken.Atom) {
                this.formatAtom((SqlParserToken.Atom)t, ctx);
                continue;
            }
            this.formatDefault(t, ctx);
        }
    }

    private void formatAtom(SqlParserToken.Atom stm, FormatContext ctx) {
        int index = 0;
        for (SqlParserToken.IToken t : stm.getChildren()) {
            if (t instanceof SqlParserToken.BracketExpr) {
                this.formatBracketExpr((SqlParserToken.BracketExpr)t, ctx);
            } else if (t instanceof SqlParserToken.Statement) {
                this.formatStatement((SqlParserToken.Statement)t, ctx);
            } else if (t instanceof SqlParserToken.Part) {
                this.formatPart((SqlParserToken.Part)t, ctx);
            } else if (t instanceof SqlParserToken.OrExpr) {
                this.formatOrExpr((SqlParserToken.OrExpr)t, ctx);
            } else if (t instanceof SqlParserToken.FunExpr) {
                this.formatFunExpr((SqlParserToken.FunExpr)t, ctx);
            } else if (t instanceof SqlParserToken.Name) {
                if (index > 0) {
                    ctx.print(" ");
                }
                this.formatDefault(t, ctx);
            } else {
                this.formatDefault(t, ctx);
            }
            ++index;
        }
    }

    private void formatBracketExpr(SqlParserToken.BracketExpr stm, FormatContext ctx) {
        boolean multiline = this.isMultiline(stm);
        for (SqlParserToken.IToken t : stm.getChildren()) {
            if (t instanceof SqlParserToken.OpenBracketToken) {
                this.formatDefault(t, ctx);
                if (!multiline) continue;
                ctx.println();
                ctx.in();
                continue;
            }
            if (t instanceof SqlParserToken.CloseBracketToken) {
                if (multiline) {
                    ctx.out();
                }
                this.formatDefault(t, ctx);
                continue;
            }
            if (t instanceof SqlParserToken.Statement) {
                this.formatStatement((SqlParserToken.Statement)t, ctx);
                continue;
            }
            if (t instanceof SqlParserToken.SingleStatement) {
                this.formatSingleStatement((SqlParserToken.SingleStatement)t, ctx);
                continue;
            }
            if (t instanceof SqlParserToken.ListExpr) {
                this.formatListExpr((SqlParserToken.ListExpr)t, multiline, ctx);
                continue;
            }
            this.formatDefault(t, ctx);
        }
    }

    private void formatFunExpr(SqlParserToken.FunExpr stm, FormatContext ctx) {
        for (SqlParserToken.IToken t : stm.getChildren()) {
            if (t instanceof SqlParserToken.Name) {
                this.formatDefault(t, ctx);
                continue;
            }
            if (t instanceof SqlParserToken.BracketExpr) {
                this.formatBracketExpr((SqlParserToken.BracketExpr)t, ctx);
                continue;
            }
            this.formatDefault(t, ctx);
        }
    }

    private void formatDefault(SqlParserToken.IToken t, FormatContext ctx) {
        for (SqlParserToken.Comment c : t.getComments()) {
            ctx.print(c.toString());
        }
        ctx.print(t.toString());
    }

    private boolean isMultiline(SqlParserToken.IToken stm) {
        if (stm instanceof SqlParserToken.Statement) {
            return true;
        }
        for (SqlParserToken.IToken t : stm.getChildren()) {
            if (!this.isMultiline(t)) continue;
            return true;
        }
        return false;
    }

    private static class FormatContext {
        private int m_tabSize;
        private int m_indent;
        private int m_linePos;
        private StringBuilder m_buf;

        public FormatContext(int tabSize) {
            this.m_tabSize = tabSize;
            this.m_buf = new StringBuilder();
        }

        public void in() {
            this.m_indent += this.m_tabSize;
            if (this.m_linePos >= this.m_indent) {
                this.print(" ");
            }
        }

        public void out() {
            this.m_indent -= this.m_tabSize;
            if (this.m_linePos > this.m_indent) {
                this.println();
            }
        }

        public void println() {
            this.print("\n");
        }

        public void println(String s) {
            this.print(s);
            this.print("\n");
        }

        /*
         * Unable to fully structure code
         */
        public void print(String s) {
            var5_2 = s.toCharArray();
            var4_3 = var5_2.length;
            var3_4 = 0;
            while (var3_4 < var4_3) {
                block2: {
                    ch = var5_2[var3_4];
                    if (ch != '\n') ** GOTO lbl14
                    this.m_buf.append('\n');
                    this.m_linePos = 0;
                    break block2;
lbl-1000:
                    // 1 sources

                    {
                        this.m_buf.append(' ');
                        ++this.m_linePos;
lbl14:
                        // 2 sources

                        ** while (this.m_linePos < this.m_indent)
                    }
lbl15:
                    // 1 sources

                    this.m_buf.append(ch);
                    ++this.m_linePos;
                }
                ++var3_4;
            }
        }

        public String getBuffer() {
            return this.m_buf.toString();
        }
    }
}

