/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.parsers.token;

import org.eclipse.scout.commons.parsers.token.IToken;

public class ValueOutputToken
implements IToken {
    private String m_parsedToken;
    private String m_replaceToken;
    private String m_name;
    private boolean m_batch;
    private boolean m_selectInto;

    public ValueOutputToken(String parsedToken, String name, boolean selectInto) {
        this.m_parsedToken = parsedToken;
        this.m_name = name;
        this.m_selectInto = selectInto;
        if (name.startsWith("{") && name.endsWith("}")) {
            this.m_name = this.m_name.substring(1, this.m_name.length() - 1);
            this.m_batch = true;
        }
    }

    @Override
    public boolean isInput() {
        return false;
    }

    @Override
    public boolean isOutput() {
        return true;
    }

    @Override
    public String getParsedToken() {
        return this.m_parsedToken;
    }

    @Override
    public String getReplaceToken() {
        if (this.m_replaceToken != null) {
            return this.m_replaceToken;
        }
        return this.m_parsedToken;
    }

    @Override
    public void setReplaceToken(String s) {
        this.m_replaceToken = s;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean isSelectInto() {
        return this.m_selectInto;
    }

    public boolean isBatch() {
        return this.m_batch;
    }

    public void setBatch(boolean b) {
        this.m_batch = b;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(String.valueOf(this.getClass().getSimpleName()) + "[");
        b.append(this.m_name);
        b.append(" ");
        b.append("parsed '");
        b.append(this.getParsedToken());
        b.append("'");
        b.append(", replaced '");
        b.append(this.getReplaceToken());
        b.append("'");
        if (this.isBatch()) {
            b.append(" batch");
        }
        if (this.isSelectInto()) {
            b.append(" into");
        }
        b.append("]");
        return b.toString();
    }
}

