/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.action;

import org.eclipse.jface.action.Action;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.internal.model.NlsReferenceProvider;
import org.eclipse.scout.nls.sdk.internal.model.NlsTableModel;
import org.eclipse.scout.nls.sdk.internal.search.INlsKeySearchListener;
import org.eclipse.scout.nls.sdk.internal.search.NlsFindKeysJob;
import org.eclipse.scout.nls.sdk.internal.ui.editor.NlsTable;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.search.ui.text.Match;

public class UpdateKeyUsageCountAction
extends Action {
    private final INlsProject m_project;
    private final NlsTable m_table;
    private final NlsTableModel m_tableModel;
    private NlsFindKeysJob m_job;

    public UpdateKeyUsageCountAction(INlsProject project, NlsTable table, NlsTableModel model) {
        this.m_project = project;
        this.m_table = table;
        this.m_tableModel = model;
        this.setEnabled(project != null);
        this.setText("Show Key usage");
        this.setImageDescriptor(NlsCore.getImageDescriptor("find_obj"));
    }

    public void run() {
        this.m_job = new NlsFindKeysJob(this.m_project, this.getText());
        this.m_job.getSearchRequstor().addFindReferencesListener(new P_JobListener());
        this.m_job.schedule();
    }

    private void handleBeginSearch() {
        this.m_table.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                UpdateKeyUsageCountAction.this.setEnabled(false);
            }
        });
    }

    private void handleEndSearch() {
        this.m_table.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                UpdateKeyUsageCountAction.this.setEnabled(true);
                UpdateKeyUsageCountAction.this.m_tableModel.setReferenceProvider(new NlsReferenceProvider(UpdateKeyUsageCountAction.this.m_job.getMatches()));
                UpdateKeyUsageCountAction.this.m_table.refreshAll(false);
            }
        });
    }

    private class P_JobListener
    implements INlsKeySearchListener {
        private P_JobListener() {
        }

        @Override
        public void beginReporting() {
            UpdateKeyUsageCountAction.this.handleBeginSearch();
        }

        @Override
        public void foundMatch(String key, Match match) {
        }

        @Override
        public void endReporting() {
            UpdateKeyUsageCountAction.this.handleEndSearch();
        }
    }
}

