/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.model.workspace.project;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.nls.sdk.model.workspace.translationResource.ITranslationResource;

public class NlsProjectEvent {
    public static final int TYPE_ENTRY_ADDED = 1;
    public static final int TYPE_ENTRY_REMOVED = 2;
    public static final int TYPE_ENTRY_MODIFYED = 4;
    public static final int TYPE_REFRESH = 8;
    public static final int TYPE_FULL_REFRESH = 16;
    public static final int TYPE_TRANSLATION_RESOURCE_ADDED = 32;
    public static final int TYPE_TRANSLATION_RESOURCE_REMOVED = 64;
    private final INlsProject m_source;
    private final int m_type;
    private final List<NlsProjectEvent> m_childEvents;
    private final ITranslationResource m_resource;
    private final INlsEntry m_entry;

    public NlsProjectEvent(INlsProject source) {
        this(source, 0);
    }

    public NlsProjectEvent(INlsProject source, int type) {
        this(source, null, null, type);
    }

    public NlsProjectEvent(INlsProject source, ITranslationResource r, int type) {
        this(source, r, null, type);
    }

    public NlsProjectEvent(INlsProject source, INlsEntry entry, int type) {
        this(source, null, entry, type);
    }

    private NlsProjectEvent(INlsProject source, ITranslationResource r, INlsEntry entry, int type) {
        this.m_source = source;
        this.m_entry = entry;
        this.m_type = type;
        this.m_resource = r;
        this.m_childEvents = new ArrayList<NlsProjectEvent>();
    }

    public boolean isMultiEvent() {
        return this.m_childEvents != null && this.m_childEvents.size() > 0;
    }

    public void addChildEvent(NlsProjectEvent event) {
        this.m_childEvents.add(event);
    }

    public void removeChildEvent(NlsProjectEvent event) {
        this.m_childEvents.remove(event);
    }

    public NlsProjectEvent[] getChildEvents() {
        if (this.m_childEvents == null) {
            return new NlsProjectEvent[0];
        }
        return this.m_childEvents.toArray(new NlsProjectEvent[this.m_childEvents.size()]);
    }

    public INlsProject getSource() {
        return this.m_source;
    }

    public INlsEntry getEntry() {
        return this.m_entry;
    }

    public int getType() {
        return this.m_type;
    }

    public ITranslationResource getResource() {
        return this.m_resource;
    }
}

