/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui;

import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.common.icon.IIconProviderService;
import org.eclipse.scout.rt.client.services.common.icon.IconProviderService;
import org.eclipse.scout.rt.client.services.common.icon.IconSpec;
import org.eclipse.scout.rt.client.ui.IIconLocator;
import org.eclipse.scout.service.SERVICES;
import org.osgi.framework.Bundle;

public class IconLocator
implements IIconLocator {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(IconLocator.class);
    private final IIconProviderService[] m_iconProviderServices;

    public IconLocator(IClientSession session) {
        Bundle clientBundle = session.getBundle();
        TreeSet<IIconProviderService> services = new TreeSet<IIconProviderService>(new P_ServiceComparator());
        IIconProviderService[] registeredServices = (IIconProviderService[])SERVICES.getServices(IIconProviderService.class);
        services.addAll(Arrays.asList(registeredServices));
        boolean containsClientBundle = false;
        IIconProviderService[] iIconProviderServiceArray = registeredServices;
        int n = registeredServices.length;
        int n2 = 0;
        while (n2 < n) {
            IIconProviderService service = iIconProviderServiceArray[n2];
            if (CompareUtility.equals((Object)service.getHostBundle(), (Object)clientBundle)) {
                containsClientBundle = true;
                break;
            }
            ++n2;
        }
        if (!containsClientBundle) {
            services.add(new P_ClientIconProviderService(clientBundle));
        }
        this.m_iconProviderServices = services.toArray(new IIconProviderService[services.size()]);
    }

    @Override
    public IconSpec getIconSpec(String name) {
        if (name == null || "null".equals(name)) {
            return null;
        }
        IconSpec spec = null;
        IIconProviderService[] iIconProviderServiceArray = this.m_iconProviderServices;
        int n = this.m_iconProviderServices.length;
        int n2 = 0;
        while (n2 < n) {
            IIconProviderService service = iIconProviderServiceArray[n2];
            spec = service.getIconSpec(name);
            if (spec != null) break;
            ++n2;
        }
        return spec;
    }

    private class P_ClientIconProviderService
    extends IconProviderService {
        public P_ClientIconProviderService(Bundle clientBundle) {
            this.setHostBundle(clientBundle);
        }

        @Override
        public int getRanking() {
            return -20;
        }
    }

    private class P_ServiceComparator
    implements Comparator<IIconProviderService> {
        private P_ServiceComparator() {
        }

        @Override
        public int compare(IIconProviderService o1, IIconProviderService o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int result = o2.getRanking() - o1.getRanking();
            if (result == 0) {
                LOG.warn("Multiple IIconProviderServices with the same ranking found. A clear definition of the rankings is necessary to properly enable the icon overriding. Affected services: " + o1 + ", " + o2);
                return -1;
            }
            return result;
        }
    }
}

