/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columnfilter;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.EventObject;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ITableColumnFilterManager;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;

public class TableColumnFilterEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_FILTER_ADDED = 10;
    public static final int TYPE_FILTER_CHANGED = 20;
    public static final int TYPE_FILTER_REMOVED = 30;
    public static final int TYPE_FILTERS_RESET = 40;
    private final int m_type;
    private final IColumn<?> m_column;

    public TableColumnFilterEvent(ITable table, int type) {
        this(table, type, null);
    }

    public TableColumnFilterEvent(ITable table, int type, IColumn<?> column) {
        super(table);
        this.m_type = type;
        this.m_column = column;
    }

    public ITable getTable() {
        return (ITable)this.getSource();
    }

    public ITableColumnFilterManager getColumnFilterManager() {
        if (this.getTable() == null) {
            return null;
        }
        return this.getTable().getColumnFilterManager();
    }

    public int getType() {
        return this.m_type;
    }

    public IColumn<?> getColumn() {
        return this.m_column;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DialogEvent[");
        try {
            Field[] f = this.getClass().getDeclaredFields();
            int i = 0;
            while (i < f.length) {
                if (Modifier.isPublic(f[i].getModifiers()) && Modifier.isStatic(f[i].getModifiers()) && f[i].getName().startsWith("TYPE_") && ((Number)f[i].get(null)).intValue() == this.m_type) {
                    sb.append(f[i].getName());
                    break;
                }
                ++i;
            }
        }
        catch (Throwable t) {
            sb.append("#" + this.m_type);
        }
        if (this.getTable() != null) {
            sb.append(" " + this.getTable().getClass());
        }
        sb.append("]");
        return sb.toString();
    }
}

