/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.annotations.Replace;
import org.eclipse.scout.commons.beans.AbstractPropertyObserver;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.ProcessingStatus;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.extension.ui.basic.table.columns.ColumnChains;
import org.eclipse.scout.rt.client.extension.ui.basic.table.columns.IColumnExtension;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.ColumnSet;
import org.eclipse.scout.rt.client.ui.basic.table.HeaderCell;
import org.eclipse.scout.rt.client.ui.basic.table.IHeaderCell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ITableColumnFilterManager;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.internal.InternalTableRow;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.client.ui.form.fields.ParsingFailedStatus;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.extension.AbstractExtension;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.eclipse.scout.rt.shared.services.common.security.IAccessControlService;
import org.eclipse.scout.service.SERVICES;

@ClassId(value="ebe15e4d-017b-4ac0-9a5a-2c9e07c8ad6f")
public abstract class AbstractColumn<VALUE>
extends AbstractPropertyObserver
implements IColumn<VALUE>,
IExtensibleObject {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractColumn.class);
    private ITable m_table;
    private final HeaderCell m_headerCell;
    private boolean m_primaryKey;
    private boolean m_summary;
    private boolean m_isValidating;
    private boolean m_visibleProperty;
    private boolean m_visibleGranted;
    private int m_initialWidth;
    private boolean m_initialVisible;
    private int m_initialSortIndex;
    private boolean m_initialSortAscending;
    private boolean m_initialAlwaysIncludeSortAtBegin;
    private boolean m_initialAlwaysIncludeSortAtEnd;
    private final Map<InternalTableRow, VALUE> m_validatedValues = new HashMap<InternalTableRow, VALUE>();
    private final ObjectExtensions<AbstractColumn<VALUE>, IColumnExtension<VALUE, ? extends AbstractColumn<VALUE>>> m_objectExtensions;

    public AbstractColumn() {
        this(true);
    }

    public AbstractColumn(boolean callInitializer) {
        this.m_headerCell = new HeaderCell();
        this.m_objectExtensions = new ObjectExtensions((Object)this);
        if (callInitializer) {
            this.callInitializer();
        }
        this.propertySupport.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!CompareUtility.isOneOf((Object)evt.getPropertyName(), (Object[])new Object[]{"editable", "visible"})) {
                    return;
                }
                ITable table = AbstractColumn.this.getTable();
                if (table != null) {
                    table.updateAllRows();
                }
            }
        });
    }

    protected final void callInitializer() {
        this.interceptInitConfig();
    }

    public final void clearValidatedValues() {
        this.m_validatedValues.clear();
    }

    public final VALUE clearValidatedValue(ITableRow row) {
        return this.m_validatedValues.remove(row);
    }

    private void storeValidatedValue(ITableRow row, VALUE validatedValue) {
        if (row instanceof InternalTableRow) {
            this.m_validatedValues.put((InternalTableRow)row, validatedValue);
        }
    }

    private void removeValidatedValue(ITableRow row) {
        if (row instanceof InternalTableRow) {
            this.m_validatedValues.remove((InternalTableRow)row);
        }
    }

    protected Map<String, Object> getPropertiesMap() {
        return this.propertySupport.getPropertiesMap();
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=10.0)
    protected boolean getConfiguredVisible() {
        return true;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=20.0)
    protected String getConfiguredHeaderText() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=30.0)
    protected String getConfiguredHeaderTooltipText() {
        return null;
    }

    @ConfigProperty(value="COLOR")
    @Order(value=40.0)
    protected String getConfiguredHeaderForegroundColor() {
        return null;
    }

    @ConfigProperty(value="COLOR")
    @Order(value=50.0)
    protected String getConfiguredHeaderBackgroundColor() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=60.0)
    protected String getConfiguredHeaderFont() {
        return null;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=70.0)
    protected int getConfiguredWidth() {
        return 60;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=75.0)
    protected boolean getConfiguredFixedWidth() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=80.0)
    protected boolean getConfiguredDisplayable() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=90.0)
    protected boolean getConfiguredPrimaryKey() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=95.0)
    protected boolean getConfiguredEditable() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=100.0)
    protected boolean getConfiguredSummary() {
        return false;
    }

    @ConfigProperty(value="COLOR")
    @Order(value=110.0)
    protected String getConfiguredForegroundColor() {
        return null;
    }

    @ConfigProperty(value="COLOR")
    @Order(value=120.0)
    protected String getConfiguredBackgroundColor() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=130.0)
    protected String getConfiguredFont() {
        return null;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=140.0)
    protected int getConfiguredSortIndex() {
        return -1;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=145.0)
    protected double getConfiguredViewOrder() {
        return 9.876543212345678E16;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=150.0)
    protected boolean getConfiguredSortAscending() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=160.0)
    protected boolean getConfiguredAlwaysIncludeSortAtBegin() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=170.0)
    protected boolean getConfiguredAlwaysIncludeSortAtEnd() {
        return false;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=180.0)
    protected int getConfiguredHorizontalAlignment() {
        return -1;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=190.0)
    protected boolean getConfiguredAutoOptimizeWidth() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=210.0)
    protected boolean getConfiguredMandatory() {
        return false;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execInitColumn() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=15.0)
    protected void execDisposeColumn() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected VALUE execParseValue(ITableRow row, Object rawValue) throws ProcessingException {
        return this.parseValueInternal(row, rawValue);
    }

    @ConfigOperation
    @Order(value=30.0)
    protected VALUE execValidateValue(ITableRow row, VALUE rawValue) throws ProcessingException {
        return this.validateValueInternal(row, rawValue);
    }

    @ConfigOperation
    @Order(value=40.0)
    protected void execDecorateCell(Cell cell, ITableRow row) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execDecorateHeaderCell(HeaderCell cell) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=60.0)
    protected boolean execIsEditable(ITableRow row) throws ProcessingException {
        return true;
    }

    @ConfigOperation
    @Order(value=61.0)
    protected IFormField execPrepareEdit(ITableRow row) throws ProcessingException {
        IFormField f = this.prepareEditInternal(row);
        if (f != null) {
            if (f instanceof AbstractValueField) {
                ((AbstractValueField)f).setAutoDisplayText(!this.m_isValidating);
            }
            f.setLabelVisible(false);
            GridData gd = f.getGridDataHints();
            gd.horizontalAlignment = this.getHorizontalAlignment();
            f.setGridDataHints(gd);
            if (f instanceof IValueField) {
                ((IValueField)f).setValue(this.getValue(row));
            }
            f.markSaved();
        }
        return f;
    }

    @ConfigOperation
    @Order(value=62.0)
    protected void execCompleteEdit(ITableRow row, IFormField editingField) throws ProcessingException {
        IValueField v;
        if (editingField instanceof IValueField && ((v = (IValueField)editingField).isSaveNeeded() || editingField.getErrorStatus() != null || row.getCell(this).getErrorStatus() != null)) {
            VALUE parsedValue = this.parseValue(row, v.getValue());
            this.setValueInternal(row, parsedValue, editingField);
            if (this.getTable() instanceof AbstractTable && ((AbstractTable)this.getTable()).wasEverValid(row)) {
                this.persistRowChange(row);
            }
        }
    }

    protected void applyValueInternal(ITableRow row, VALUE newValue) throws ProcessingException {
        if (!this.getTable().isSortEnabled()) {
            this.setValue(row, newValue);
        } else {
            try {
                this.getTable().setSortEnabled(false);
                this.setValue(row, newValue);
            }
            finally {
                this.getTable().setSortEnabled(true);
            }
        }
    }

    public final List<? extends IColumnExtension<VALUE, ? extends AbstractColumn<VALUE>>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    protected IColumnExtension<VALUE, ? extends AbstractColumn<VALUE>> createLocalExtension() {
        return new LocalColumnExtension(this);
    }

    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return (T)this.m_objectExtensions.getExtension(c);
    }

    protected final void interceptInitConfig() {
        this.m_objectExtensions.initConfig(this.createLocalExtension(), new Runnable(){

            @Override
            public void run() {
                AbstractColumn.this.initConfig();
            }
        });
    }

    protected void initConfig() {
        this.setAutoOptimizeWidth(this.getConfiguredAutoOptimizeWidth());
        this.m_visibleGranted = true;
        this.m_headerCell.setText(this.getConfiguredHeaderText());
        if (this.getConfiguredHeaderTooltipText() != null) {
            this.m_headerCell.setTooltipText(this.getConfiguredHeaderTooltipText());
        }
        if (this.getConfiguredHeaderForegroundColor() != null) {
            this.m_headerCell.setForegroundColor(this.getConfiguredHeaderForegroundColor());
        }
        if (this.getConfiguredHeaderBackgroundColor() != null) {
            this.m_headerCell.setBackgroundColor(this.getConfiguredHeaderBackgroundColor());
        }
        if (this.getConfiguredHeaderFont() != null) {
            this.m_headerCell.setFont(FontSpec.parse((String)this.getConfiguredHeaderFont()));
        }
        this.m_headerCell.setHorizontalAlignment(this.getConfiguredHorizontalAlignment());
        this.setHorizontalAlignment(this.getConfiguredHorizontalAlignment());
        this.setDisplayable(this.getConfiguredDisplayable());
        this.setVisible(this.getConfiguredVisible());
        this.setInitialWidth(this.getConfiguredWidth());
        this.setInitialVisible(this.getConfiguredVisible());
        this.setInitialSortIndex(this.getConfiguredSortIndex());
        this.setInitialSortAscending(this.getConfiguredSortAscending());
        this.setInitialAlwaysIncludeSortAtBegin(this.getConfiguredAlwaysIncludeSortAtBegin());
        this.setInitialAlwaysIncludeSortAtEnd(this.getConfiguredAlwaysIncludeSortAtEnd());
        this.setOrder(this.calculateViewOrder());
        this.setWidth(this.getConfiguredWidth());
        this.setFixedWidth(this.getConfiguredFixedWidth());
        this.m_primaryKey = this.getConfiguredPrimaryKey();
        this.m_summary = this.getConfiguredSummary();
        this.setEditable(this.getConfiguredEditable());
        this.setMandatory(this.getConfiguredMandatory());
        this.setVisibleColumnIndexHint(-1);
        if (this.getConfiguredForegroundColor() != null) {
            this.setForegroundColor(this.getConfiguredForegroundColor());
        }
        if (this.getConfiguredBackgroundColor() != null) {
            this.setBackgroundColor(this.getConfiguredBackgroundColor());
        }
        if (this.getConfiguredFont() != null) {
            this.setFont(FontSpec.parse((String)this.getConfiguredFont()));
        }
    }

    protected double calculateViewOrder() {
        double viewOrder = this.getConfiguredViewOrder();
        Class<?> cls = this.getClass();
        if (viewOrder == 9.876543212345678E16) {
            while (cls != null && IColumn.class.isAssignableFrom(cls)) {
                if (cls.isAnnotationPresent(Order.class)) {
                    Order order = cls.getAnnotation(Order.class);
                    return order.value();
                }
                cls = cls.getSuperclass();
            }
        }
        return viewOrder;
    }

    @Override
    public void initColumn() throws ProcessingException {
        ClientUIPreferences env = ClientUIPreferences.getInstance();
        this.setVisible(env.getTableColumnVisible(this, this.m_visibleProperty));
        this.setWidth(env.getTableColumnWidth(this, this.getWidth()));
        this.setVisibleColumnIndexHint(env.getTableColumnViewIndex(this, this.getVisibleColumnIndexHint()));
        this.interceptInitColumn();
    }

    @Override
    public void disposeColumn() throws ProcessingException {
        this.interceptDisposeColumn();
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.propertySupport.setPropertyBool("mandatory", mandatory);
        this.validateColumnValues();
    }

    @Override
    public boolean isMandatory() {
        return this.propertySupport.getPropertyBool("mandatory");
    }

    @Override
    public boolean isInitialVisible() {
        return this.m_initialVisible;
    }

    @Override
    public void setInitialVisible(boolean b) {
        this.m_initialVisible = b;
    }

    @Override
    public int getInitialSortIndex() {
        return this.m_initialSortIndex;
    }

    @Override
    public void setInitialSortIndex(int i) {
        this.m_initialSortIndex = i;
    }

    @Override
    public boolean isInitialSortAscending() {
        return this.m_initialSortAscending;
    }

    @Override
    public void setInitialSortAscending(boolean b) {
        this.m_initialSortAscending = b;
    }

    @Override
    public boolean isInitialAlwaysIncludeSortAtBegin() {
        return this.m_initialAlwaysIncludeSortAtBegin;
    }

    @Override
    public void setInitialAlwaysIncludeSortAtBegin(boolean b) {
        this.m_initialAlwaysIncludeSortAtBegin = b;
    }

    @Override
    public boolean isInitialAlwaysIncludeSortAtEnd() {
        return this.m_initialAlwaysIncludeSortAtEnd;
    }

    @Override
    public void setInitialAlwaysIncludeSortAtEnd(boolean b) {
        this.m_initialAlwaysIncludeSortAtEnd = b;
    }

    @Override
    public void setVisiblePermission(Permission p) {
        boolean b = p != null ? ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).checkPermission(p) : true;
        this.setVisibleGranted(b);
    }

    @Override
    public boolean isVisibleGranted() {
        return this.m_visibleGranted;
    }

    @Override
    public void setVisibleGranted(boolean b) {
        this.m_visibleGranted = b;
        this.calculateVisible();
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    public void setTableInternal(ITable table) {
        this.m_table = table;
    }

    @Override
    public int getColumnIndex() {
        return this.m_headerCell.getColumnIndex();
    }

    @Override
    public String getColumnId() {
        Class<?> c = this.getClass();
        while (c.isAnnotationPresent(Replace.class)) {
            c = c.getSuperclass();
        }
        String s = c.getSimpleName();
        if (s.endsWith("Column")) {
            s = s.replaceAll("Column$", "");
        }
        return s;
    }

    public String classId() {
        String simpleClassId = ConfigurationUtility.getAnnotatedClassIdWithFallback(this.getClass(), (boolean)false);
        return String.valueOf(simpleClassId) + "_" + this.getTable().classId();
    }

    @Override
    public VALUE getValue(ITableRow r) {
        VALUE validatedValue = this.m_validatedValues.get(r);
        if (validatedValue == null) {
            validatedValue = this.getValueInternal(r);
            this.storeValidatedValue(r, validatedValue);
        }
        return validatedValue;
    }

    protected VALUE getValueInternal(ITableRow r) {
        return (VALUE)(r != null ? r.getCellValue(this.getColumnIndex()) : null);
    }

    @Override
    public VALUE getValue(int rowIndex) {
        return this.getValue(this.getTable().getRow(rowIndex));
    }

    @Override
    public void setValue(int rowIndex, VALUE rawValue) throws ProcessingException {
        this.setValue(this.getTable().getRow(rowIndex), rawValue);
    }

    @Override
    public void setValue(ITableRow r, VALUE value) throws ProcessingException {
        this.setValueInternal(r, value, null);
    }

    private void setValueInternal(ITableRow row, VALUE value, IFormField editingField) throws ProcessingException {
        VALUE newValue = this.validateValue(row, value);
        this.validateColumnValue(row, editingField, true, newValue);
        ICell cell = row.getCell(this);
        if (cell instanceof Cell && ((Cell)cell).getErrorStatus() == null) {
            row.setCellValue(this.getColumnIndex(), newValue);
        }
    }

    @Override
    public void fill(VALUE rawValue) throws ProcessingException {
        for (ITableRow row : this.getTable().getRows()) {
            this.setValue(row, rawValue);
        }
    }

    @Override
    public Class<VALUE> getDataType() {
        return TypeCastUtility.getGenericsParameterClass(this.getClass(), IColumn.class);
    }

    @Override
    public List<VALUE> getValues() {
        int rowCount = this.m_table.getRowCount();
        ArrayList<VALUE> values = new ArrayList<VALUE>(rowCount);
        int i = 0;
        while (i < rowCount) {
            values.add(this.getValue(this.m_table.getRow(i)));
            ++i;
        }
        return values;
    }

    @Override
    public List<VALUE> getValues(boolean includeDeleted) {
        ArrayList<VALUE> values = new ArrayList<VALUE>();
        for (ITableRow row : this.m_table.getRows()) {
            if (!includeDeleted && row.getStatus() == 3) continue;
            values.add(this.getValue(row));
        }
        return values;
    }

    @Override
    public List<VALUE> getValues(Collection<? extends ITableRow> rows) {
        ArrayList<VALUE> values = new ArrayList<VALUE>(rows.size());
        for (ITableRow iTableRow : rows) {
            values.add(this.getValue(iTableRow));
        }
        return values;
    }

    @Override
    public List<VALUE> getSelectedValues() {
        List<ITableRow> selectedRows = this.m_table.getSelectedRows();
        ArrayList<VALUE> values = new ArrayList<VALUE>(selectedRows.size());
        for (ITableRow row : selectedRows) {
            values.add(this.getValue(row));
        }
        return values;
    }

    @Override
    public VALUE getSelectedValue() {
        ITableRow row = this.m_table.getSelectedRow();
        if (row != null) {
            return this.getValue(row);
        }
        return null;
    }

    @Override
    public String getDisplayText(ITableRow r) {
        return r.getCell(this.getColumnIndex()).getText();
    }

    @Override
    public List<String> getDisplayTexts() {
        ArrayList<String> values = new ArrayList<String>(this.m_table.getRowCount());
        int i = 0;
        while (i < this.m_table.getRowCount()) {
            values.add(this.getDisplayText(this.m_table.getRow(i)));
            ++i;
        }
        return values;
    }

    @Override
    public String getSelectedDisplayText() {
        ITableRow row = this.m_table.getSelectedRow();
        if (row != null) {
            return this.getDisplayText(row);
        }
        return null;
    }

    @Override
    public List<String> getSelectedDisplayTexts() {
        List<ITableRow> selectedRows = this.m_table.getSelectedRows();
        ArrayList<String> values = new ArrayList<String>(selectedRows.size());
        for (ITableRow row : selectedRows) {
            values.add(this.getDisplayText(row));
        }
        return values;
    }

    @Override
    public List<VALUE> getInsertedValues() {
        List<ITableRow> insertedRows = this.m_table.getInsertedRows();
        ArrayList<VALUE> values = new ArrayList<VALUE>(insertedRows.size());
        for (ITableRow row : insertedRows) {
            values.add(this.getValue(row));
        }
        return values;
    }

    @Override
    public List<VALUE> getUpdatedValues() {
        List<ITableRow> updatedRows = this.m_table.getUpdatedRows();
        ArrayList<VALUE> values = new ArrayList<VALUE>(updatedRows.size());
        for (ITableRow row : updatedRows) {
            values.add(this.getValue(row));
        }
        return values;
    }

    @Override
    public List<VALUE> getDeletedValues() {
        List<ITableRow> deletedRows = this.m_table.getDeletedRows();
        ArrayList<VALUE> values = new ArrayList<VALUE>(deletedRows.size());
        for (ITableRow row : deletedRows) {
            values.add(this.getValue(row));
        }
        return values;
    }

    @Override
    public List<VALUE> getNotDeletedValues() {
        List<ITableRow> notDeletedRows = this.m_table.getNotDeletedRows();
        ArrayList<VALUE> values = new ArrayList<VALUE>(notDeletedRows.size());
        for (ITableRow row : notDeletedRows) {
            values.add(this.getValue(row));
        }
        return values;
    }

    @Override
    public List<ITableRow> findRows(Collection<? extends VALUE> keys) {
        if (keys != null) {
            ArrayList<ITableRow> values = new ArrayList<ITableRow>(keys.size());
            for (VALUE t : keys) {
                ITableRow row = this.findRow(t);
                if (row == null) continue;
                values.add(row);
            }
            return values;
        }
        return CollectionUtility.emptyArrayList();
    }

    @Override
    public List<ITableRow> findRows(VALUE value) {
        ArrayList<ITableRow> values = new ArrayList<ITableRow>();
        int i = 0;
        while (i < this.m_table.getRowCount()) {
            ITableRow row = this.m_table.getRow(i);
            if (CompareUtility.equals(value, this.getValue(row))) {
                values.add(row);
            }
            ++i;
        }
        return values;
    }

    @Override
    public ITableRow findRow(VALUE value) {
        int i = 0;
        int ni = this.m_table.getRowCount();
        while (i < ni) {
            ITableRow row = this.m_table.getRow(i);
            if (CompareUtility.equals(value, this.getValue(row))) {
                return row;
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean contains(VALUE value) {
        int i = 0;
        int ni = this.m_table.getRowCount();
        while (i < ni) {
            ITableRow row = this.m_table.getRow(i);
            if (CompareUtility.equals(value, this.getValue(row))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean containsDuplicateValues() {
        return new HashSet<VALUE>(this.getValues()).size() < this.getValues().size();
    }

    @Override
    public boolean isEmpty() {
        if (this.m_table != null) {
            int i = 0;
            int ni = this.m_table.getRowCount();
            while (i < ni) {
                VALUE value = this.getValue(this.m_table.getRow(i));
                if (value != null) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public void setColumnIndexInternal(int index) {
        this.m_headerCell.setColumnIndexInternal(index);
    }

    @Override
    public boolean isSortActive() {
        return this.getHeaderCell().isSortActive();
    }

    @Override
    public boolean isSortExplicit() {
        return this.getHeaderCell().isSortExplicit();
    }

    @Override
    public boolean isSortAscending() {
        return this.getHeaderCell().isSortAscending();
    }

    @Override
    public boolean isSortPermanent() {
        return this.getHeaderCell().isSortPermanent();
    }

    @Override
    public int getSortIndex() {
        ColumnSet cs;
        ITable table = this.getTable();
        if (table != null && (cs = table.getColumnSet()) != null) {
            return cs.getSortColumnIndex(this);
        }
        return -1;
    }

    @Override
    public boolean isColumnFilterActive() {
        ITableColumnFilterManager m;
        ITable table = this.getTable();
        if (table != null && (m = table.getColumnFilterManager()) != null) {
            return m.getFilter(this) != null;
        }
        return false;
    }

    @Override
    public int compareTableRows(ITableRow r1, ITableRow r2) {
        VALUE o1 = this.getValue(r1);
        VALUE o2 = this.getValue(r2);
        int c = o1 == null && o2 == null ? 0 : (o1 == null ? -1 : (o2 == null ? 1 : (o1 instanceof Comparable && o2 instanceof Comparable ? ((Comparable)o1).compareTo(o2) : StringUtility.compareIgnoreCase((String)o1.toString(), (String)o2.toString()))));
        return c;
    }

    @Override
    public final VALUE parseValue(ITableRow row, Object rawValue) throws ProcessingException {
        VALUE parsedValue = this.interceptParseValue(row, rawValue);
        return this.validateValue(row, parsedValue);
    }

    protected VALUE parseValueInternal(ITableRow row, Object rawValue) throws ProcessingException {
        return (VALUE)TypeCastUtility.castValue((Object)rawValue, this.getDataType());
    }

    @Override
    public VALUE validateValue(ITableRow row, VALUE rawValue) throws ProcessingException {
        return this.interceptValidateValue(row, rawValue);
    }

    protected VALUE validateValueInternal(ITableRow row, VALUE rawValue) throws ProcessingException {
        return rawValue;
    }

    @Override
    public final IFormField prepareEdit(ITableRow row) throws ProcessingException {
        ITable table = this.getTable();
        if (table == null || !this.isCellEditable(row)) {
            return null;
        }
        IFormField f = this.interceptPrepareEdit(row);
        if (f != null) {
            f.setLabelVisible(false);
            GridData gd = f.getGridDataHints();
            gd.weightY = 1.0;
            f.setGridDataHints(gd);
        }
        return f;
    }

    protected IFormField prepareEditInternal(ITableRow row) throws ProcessingException {
        AbstractValueField f = new AbstractValueField<VALUE>(){};
        this.mapEditorFieldProperties(f);
        return f;
    }

    protected void mapEditorFieldProperties(IFormField f) {
        f.setBackgroundColor(this.getBackgroundColor());
        f.setForegroundColor(this.getForegroundColor());
        f.setFont(this.getFont());
        f.setMandatory(this.isMandatory());
    }

    @Override
    public final void completeEdit(ITableRow row, IFormField editingField) throws ProcessingException {
        ITable table = this.getTable();
        if (table == null || !table.isCellEditable(row, this)) {
            return;
        }
        this.interceptCompleteEdit(row, editingField);
    }

    @Override
    public void decorateCell(ITableRow row) {
        Cell cell = row.getCellForUpdate(this.getColumnIndex());
        if (cell.getErrorStatus() == null) {
            this.decorateCellInternal(cell, row);
        }
        try {
            this.interceptDecorateCell(cell, row);
        }
        catch (ProcessingException e) {
            LOG.warn(null, (Throwable)e);
        }
        catch (Throwable t) {
            LOG.warn(null, t);
        }
    }

    protected void decorateCellInternal(Cell cell, ITableRow row) {
        if (this.getForegroundColor() != null) {
            cell.setForegroundColor(this.getForegroundColor());
        }
        if (this.getBackgroundColor() != null) {
            cell.setBackgroundColor(this.getBackgroundColor());
        }
        if (this.getFont() != null) {
            cell.setFont(this.getFont());
        }
        cell.setHorizontalAlignment(this.getHorizontalAlignment());
        cell.setEditableInternal(this.isCellEditable(row));
    }

    @Override
    public void decorateHeaderCell() {
        HeaderCell cell = this.m_headerCell;
        this.decorateHeaderCellInternal(cell);
        try {
            this.interceptDecorateHeaderCell(cell);
            if (this.getTable() != null && this.getTable().getColumnSet() != null) {
                this.getTable().getColumnSet().updateColumn(this);
            }
        }
        catch (ProcessingException e) {
            LOG.warn(null, (Throwable)e);
        }
        catch (Throwable t) {
            LOG.warn(null, t);
        }
    }

    protected void decorateHeaderCellInternal(HeaderCell cell) {
    }

    @Override
    public IHeaderCell getHeaderCell() {
        return this.m_headerCell;
    }

    @Override
    public int getVisibleColumnIndexHint() {
        return this.propertySupport.getPropertyInt("viewColumnIndexHint");
    }

    @Override
    public void setVisibleColumnIndexHint(int index) {
        int oldIndex = this.getVisibleColumnIndexHint();
        if (oldIndex != index) {
            this.propertySupport.setPropertyInt("viewColumnIndexHint", index);
        }
    }

    @Override
    public int getInitialWidth() {
        return this.m_initialWidth;
    }

    @Override
    public void setInitialWidth(int w) {
        this.m_initialWidth = w;
    }

    @Override
    @Deprecated
    public double getViewOrder() {
        return this.getOrder();
    }

    @Override
    @Deprecated
    public void setViewOrder(double order) {
        this.setOrder(order);
    }

    public double getOrder() {
        return this.propertySupport.getPropertyDouble("viewOrder");
    }

    public void setOrder(double order) {
        this.propertySupport.setPropertyDouble("viewOrder", order);
    }

    @Override
    public int getWidth() {
        return this.propertySupport.getPropertyInt("width");
    }

    @Override
    public void setWidth(int w) {
        this.propertySupport.setPropertyInt("width", w);
    }

    @Override
    public void setWidthInternal(int w) {
        this.propertySupport.setPropertyNoFire("width", (Object)w);
    }

    @Override
    public boolean isFixedWidth() {
        return this.propertySupport.getPropertyBool("fixedWidth");
    }

    @Override
    public void setFixedWidth(boolean fixedWidth) {
        this.propertySupport.setPropertyBool("fixedWidth", fixedWidth);
    }

    @Override
    public void setHorizontalAlignment(int hAglin) {
        this.propertySupport.setPropertyInt("horizontalAlignment", hAglin);
    }

    @Override
    public int getHorizontalAlignment() {
        return this.propertySupport.getPropertyInt("horizontalAlignment");
    }

    @Override
    public boolean isDisplayable() {
        return this.propertySupport.getPropertyBool("displayable");
    }

    @Override
    public void setDisplayable(boolean b) {
        this.propertySupport.setPropertyBool("displayable", b);
        this.calculateVisible();
    }

    @Override
    public boolean isVisible() {
        return this.propertySupport.getPropertyBool("visible");
    }

    @Override
    public void setVisible(boolean b) {
        this.m_visibleProperty = b;
        this.calculateVisible();
    }

    private void calculateVisible() {
        this.propertySupport.setPropertyBool("visible", this.m_visibleGranted && this.isDisplayable() && this.m_visibleProperty);
    }

    @Override
    public boolean isVisibleInternal() {
        return this.m_visibleProperty;
    }

    @Override
    public boolean isPrimaryKey() {
        return this.m_primaryKey;
    }

    @Override
    public boolean isSummary() {
        return this.m_summary;
    }

    @Override
    public boolean isEditable() {
        return this.propertySupport.getPropertyBool("editable");
    }

    @Override
    public void setEditable(boolean b) {
        this.propertySupport.setPropertyBool("editable", b);
    }

    @Override
    public boolean isCellEditable(ITableRow row) {
        if (this.getTable() != null && this.getTable().isEnabled() && this.isEditable() && row != null && row.isEnabled() && row.getCell(this).isEnabled()) {
            try {
                return this.interceptIsEditable(row);
            }
            catch (Throwable t) {
                LOG.error("checking row " + row, t);
                return false;
            }
        }
        return false;
    }

    @Override
    public String getForegroundColor() {
        return (String)this.propertySupport.getProperty("foregroundColor");
    }

    @Override
    public void setForegroundColor(String c) {
        this.propertySupport.setProperty("foregroundColor", (Object)c);
    }

    @Override
    public String getBackgroundColor() {
        return (String)this.propertySupport.getProperty("backgroundColor");
    }

    @Override
    public void setBackgroundColor(String c) {
        this.propertySupport.setProperty("backgroundColor", (Object)c);
    }

    @Override
    public FontSpec getFont() {
        return (FontSpec)this.propertySupport.getProperty("font");
    }

    @Override
    public void setFont(FontSpec f) {
        this.propertySupport.setProperty("font", (Object)f);
    }

    @Override
    public boolean isAutoOptimizeWidth() {
        return this.propertySupport.getPropertyBool("autoOptimizeWidth");
    }

    @Override
    public void setAutoOptimizeWidth(boolean optimize) {
        this.propertySupport.setPropertyBool("autoOptimizeWidth", optimize);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.getHeaderCell().getText() + " width=" + this.getWidth() + (this.isPrimaryKey() ? " primaryKey" : "") + (this.isSummary() ? " summary" : "") + " viewIndexHint=" + this.getVisibleColumnIndexHint() + "]";
    }

    protected void persistRowChange(ITableRow row) throws ProcessingException {
    }

    public void validateColumnValues() {
        if (this.getTable() == null) {
            return;
        }
        for (ITableRow row : this.getTable().getRows()) {
            this.validateColumnValue(row, null, true, this.getValueOfCell(row));
        }
    }

    public void validateColumnValue(ITableRow row) {
        this.validateColumnValue(row, null, false, this.getValueOfCell(row));
    }

    protected VALUE getValueOfCell(ITableRow row) {
        return (VALUE)row.getCell(this).getValue();
    }

    public void validateColumnValue(ITableRow row, IFormField editor, boolean singleColValidation, VALUE value) {
        ICell cell;
        if (row == null) {
            LOG.error("validateColumnValue called with row=null");
            return;
        }
        if (!(row instanceof InternalTableRow)) {
            LOG.debug("validateColumnValue called with row not of type " + InternalTableRow.class);
            return;
        }
        if (this.m_isValidating) {
            LOG.warn("validateColumnValue called during running validation. Value " + String.valueOf(value) + " will not be set.");
            Cell cell2 = row.getCellForUpdate(this);
            cell2.setErrorStatus((IProcessingStatus)new ProcessingStatus(ScoutTexts.get((String)"RunningColumnValidation", (String[])new String[0]), 4));
            return;
        }
        if (this.isCellEditable(row)) {
            try {
                if (editor == null) {
                    this.m_isValidating = true;
                    try {
                        editor = this.prepareEdit(row);
                        if (editor instanceof IValueField) {
                            ((IValueField)editor).setValue(value);
                        }
                    }
                    finally {
                        this.m_isValidating = false;
                    }
                }
                if (editor != null) {
                    IProcessingStatus errorStatus = editor.getErrorStatus();
                    boolean editorValid = editor.isContentValid() && errorStatus == null;
                    Cell cell3 = row.getCellForUpdate(this);
                    if (!editorValid) {
                        if (this.isDisplayable() && !this.isVisible()) {
                            this.setVisible(true);
                        }
                        cell3.setErrorStatus(errorStatus);
                        if (errorStatus instanceof ParsingFailedStatus) {
                            cell3.setText(((ParsingFailedStatus)errorStatus).getParseInputString());
                        } else {
                            cell3.setErrorStatus((IProcessingStatus)new ProcessingStatus(ScoutTexts.get((String)"FormEmptyMandatoryFieldsMessage", (String[])new String[0]), 4));
                            cell3.setText("");
                        }
                        return;
                    }
                    cell3.clearErrorStatus();
                    cell3.setValue(value);
                    this.decorateCellInternal(cell3, row);
                    ITable table = this.getTable();
                    if (table instanceof AbstractTable && singleColValidation) {
                        ((AbstractTable)table).wasEverValid(row);
                    }
                }
            }
            catch (Throwable t) {
                LOG.error("validating " + this.getTable().getClass().getSimpleName() + " for new row for column " + this.getClass().getSimpleName(), t);
                return;
            }
        }
        if ((cell = row.getCell(this)) instanceof Cell && ((Cell)cell).getErrorStatus() == null) {
            this.removeValidatedValue(row);
        }
    }

    protected final void interceptCompleteEdit(ITableRow row, IFormField editingField) throws ProcessingException {
        List<IColumnExtension<VALUE, AbstractColumn<VALUE>>> extensions = this.getAllExtensions();
        ColumnChains.ColumnCompleteEditChain<VALUE> chain = new ColumnChains.ColumnCompleteEditChain<VALUE>(extensions);
        chain.execCompleteEdit(row, editingField);
    }

    protected final void interceptInitColumn() throws ProcessingException {
        List<IColumnExtension<VALUE, AbstractColumn<VALUE>>> extensions = this.getAllExtensions();
        ColumnChains.ColumnInitColumnChain<VALUE> chain = new ColumnChains.ColumnInitColumnChain<VALUE>(extensions);
        chain.execInitColumn();
    }

    protected final VALUE interceptParseValue(ITableRow row, Object rawValue) throws ProcessingException {
        List<IColumnExtension<VALUE, AbstractColumn<VALUE>>> extensions = this.getAllExtensions();
        ColumnChains.ColumnParseValueChain<VALUE> chain = new ColumnChains.ColumnParseValueChain<VALUE>(extensions);
        return chain.execParseValue(row, rawValue);
    }

    protected final boolean interceptIsEditable(ITableRow row) throws ProcessingException {
        List<IColumnExtension<VALUE, AbstractColumn<VALUE>>> extensions = this.getAllExtensions();
        ColumnChains.ColumnIsEditableChain<VALUE> chain = new ColumnChains.ColumnIsEditableChain<VALUE>(extensions);
        return chain.execIsEditable(row);
    }

    protected final VALUE interceptValidateValue(ITableRow row, VALUE rawValue) throws ProcessingException {
        List<IColumnExtension<VALUE, AbstractColumn<VALUE>>> extensions = this.getAllExtensions();
        ColumnChains.ColumnValidateValueChain<VALUE> chain = new ColumnChains.ColumnValidateValueChain<VALUE>(extensions);
        return chain.execValidateValue(row, rawValue);
    }

    protected final IFormField interceptPrepareEdit(ITableRow row) throws ProcessingException {
        List<IColumnExtension<VALUE, AbstractColumn<VALUE>>> extensions = this.getAllExtensions();
        ColumnChains.ColumnPrepareEditChain<VALUE> chain = new ColumnChains.ColumnPrepareEditChain<VALUE>(extensions);
        return chain.execPrepareEdit(row);
    }

    protected final void interceptDecorateHeaderCell(HeaderCell cell) throws ProcessingException {
        List<IColumnExtension<VALUE, AbstractColumn<VALUE>>> extensions = this.getAllExtensions();
        ColumnChains.ColumnDecorateHeaderCellChain<VALUE> chain = new ColumnChains.ColumnDecorateHeaderCellChain<VALUE>(extensions);
        chain.execDecorateHeaderCell(cell);
    }

    protected final void interceptDecorateCell(Cell cell, ITableRow row) throws ProcessingException {
        List<IColumnExtension<VALUE, AbstractColumn<VALUE>>> extensions = this.getAllExtensions();
        ColumnChains.ColumnDecorateCellChain<VALUE> chain = new ColumnChains.ColumnDecorateCellChain<VALUE>(extensions);
        chain.execDecorateCell(cell, row);
    }

    protected final void interceptDisposeColumn() throws ProcessingException {
        List<IColumnExtension<VALUE, AbstractColumn<VALUE>>> extensions = this.getAllExtensions();
        ColumnChains.ColumnDisposeColumnChain<VALUE> chain = new ColumnChains.ColumnDisposeColumnChain<VALUE>(extensions);
        chain.execDisposeColumn();
    }

    protected static class LocalColumnExtension<VALUE, OWNER extends AbstractColumn<VALUE>>
    extends AbstractExtension<OWNER>
    implements IColumnExtension<VALUE, OWNER> {
        public LocalColumnExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execCompleteEdit(ColumnChains.ColumnCompleteEditChain<VALUE> chain, ITableRow row, IFormField editingField) throws ProcessingException {
            ((AbstractColumn)this.getOwner()).execCompleteEdit(row, editingField);
        }

        @Override
        public void execInitColumn(ColumnChains.ColumnInitColumnChain<VALUE> chain) throws ProcessingException {
            ((AbstractColumn)this.getOwner()).execInitColumn();
        }

        @Override
        public VALUE execParseValue(ColumnChains.ColumnParseValueChain<VALUE> chain, ITableRow row, Object rawValue) throws ProcessingException {
            return ((AbstractColumn)this.getOwner()).execParseValue(row, rawValue);
        }

        @Override
        public boolean execIsEditable(ColumnChains.ColumnIsEditableChain<VALUE> chain, ITableRow row) throws ProcessingException {
            return ((AbstractColumn)this.getOwner()).execIsEditable(row);
        }

        @Override
        public VALUE execValidateValue(ColumnChains.ColumnValidateValueChain<VALUE> chain, ITableRow row, VALUE rawValue) throws ProcessingException {
            return ((AbstractColumn)this.getOwner()).execValidateValue(row, rawValue);
        }

        @Override
        public IFormField execPrepareEdit(ColumnChains.ColumnPrepareEditChain<VALUE> chain, ITableRow row) throws ProcessingException {
            return ((AbstractColumn)this.getOwner()).execPrepareEdit(row);
        }

        @Override
        public void execDecorateHeaderCell(ColumnChains.ColumnDecorateHeaderCellChain<VALUE> chain, HeaderCell cell) throws ProcessingException {
            ((AbstractColumn)this.getOwner()).execDecorateHeaderCell(cell);
        }

        @Override
        public void execDecorateCell(ColumnChains.ColumnDecorateCellChain<VALUE> chain, Cell cell, ITableRow row) throws ProcessingException {
            ((AbstractColumn)this.getOwner()).execDecorateCell(cell, row);
        }

        @Override
        public void execDisposeColumn(ColumnChains.ColumnDisposeColumnChain<VALUE> chain) throws ProcessingException {
            ((AbstractColumn)this.getOwner()).execDisposeColumn();
        }
    }
}

