/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.groupbox.internal;

import java.io.PrintStream;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.internal.GridDataBuilder;

public class GridCell {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(GridCell.class);
    private IFormField m_field;
    private int m_gridColumnCount;
    private GridCell m_up;
    private GridCell m_down;
    private GridCell m_right;
    protected GridData data;

    public GridCell(IFormField f, int gridColumnCount) {
        this.m_field = f;
        this.m_gridColumnCount = gridColumnCount;
        if (f != null) {
            GridData hints = GridDataBuilder.createFromHints(f, gridColumnCount);
            this.data = new GridData(hints);
        }
    }

    public IFormField getField() {
        return this.m_field;
    }

    protected void calculateGridLayout(int gridX, int gridY) {
        if (this.data.w >= this.m_gridColumnCount || gridX >= this.m_gridColumnCount) {
            gridX = 0;
        }
        this.data.x = gridX;
        this.data.y = gridY;
        if (this.m_field != null) {
            this.m_field.setGridDataInternal(new GridData(this.data));
        }
        if (this.m_down != null) {
            this.m_down.calculateGridLayout(gridX, gridY + this.data.h);
        }
        if (this.m_right != null) {
            this.m_right.calculateGridLayout(gridX + this.data.w, gridY);
        }
    }

    protected GridCell getSplitCell(int before, int maxWeight, int colCount) {
        GridCell cell;
        int after = maxWeight - before - this.data.h * this.data.w;
        if ((colCount - 1) * before >= this.data.h + after) {
            return this;
        }
        if (before > 0 && after == 0) {
            return this;
        }
        if (this.m_down != null && (cell = this.m_down.getSplitCell(before + this.data.h, maxWeight, colCount)) != null) {
            return cell;
        }
        if (this.m_right != null && (cell = this.m_right.getSplitCell(before, maxWeight, colCount)) != null) {
            return cell;
        }
        return null;
    }

    protected int getMaxWeight() {
        int wDown = this.m_down != null ? this.m_down.getMaxWeight() : 0;
        int wRight = this.m_right != null ? this.m_right.getMaxWeight() : 0;
        return Math.max(this.data.h * Math.max(this.data.w, 1) + wDown, wRight);
    }

    protected int getMaxY() {
        int mdown = this.m_down != null ? this.m_down.getMaxY() : 0;
        int mright = this.m_right != null ? this.m_right.getMaxY() : 0;
        return Math.max(this.data.h + mdown, mright);
    }

    protected int getMaxCols() {
        int mdown = this.m_down != null ? this.m_down.getMaxCols() : 0;
        int mright = this.m_right != null ? this.m_right.getMaxCols() : 0;
        return Math.max(mdown, this.data.w + mright);
    }

    protected void addBottomCell(GridCell c) {
        int mright;
        int mdown = this.m_down != null ? this.m_down.getMaxY() : 0;
        int n = mright = this.m_right != null ? this.m_right.getMaxY() : 0;
        if (this.m_down != null && this.data.h + mdown >= mright) {
            this.m_down.addBottomCellImpl(c);
        } else if (this.m_right != null && mright > this.data.h) {
            this.m_right.addBottomCellImpl(c);
        } else {
            this.m_down = c;
            c.m_up = this;
        }
    }

    private void addBottomCellImpl(GridCell c) {
        if (this.m_down != null) {
            this.m_down.addBottomCellImpl(c);
        } else {
            this.m_down = c;
            c.m_up = this;
        }
    }

    protected GridCell getUp() {
        return this.m_up;
    }

    protected void setDown(GridCell down) {
        this.m_down = down;
    }

    protected void setRight(GridCell right) {
        this.m_right = right;
    }

    protected boolean isProcessButton() {
        if (this.m_field instanceof IButton) {
            return ((IButton)this.m_field).isProcessButton();
        }
        return false;
    }

    protected boolean isSystemProcessButton() {
        if (this.isProcessButton()) {
            return ((IButton)this.m_field).getSystemType() != 0;
        }
        return false;
    }

    void printCell(PrintStream out, String pref) {
        out.println(String.valueOf(pref) + "field: " + this.getField());
        if (this.m_up != null) {
            out.println(String.valueOf(pref) + "-up: " + this.m_up.getField());
        }
        if (this.m_right != null) {
            out.println(String.valueOf(pref) + "-right: " + this.m_right.getField());
            this.m_right.printCell(out, String.valueOf(pref) + "  ");
        }
        if (this.m_down != null) {
            out.println(String.valueOf(pref) + "-down: " + this.m_down.getField());
            this.m_down.printCell(out, String.valueOf(pref) + "  ");
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getSimpleName());
        buf.append("[");
        buf.append(this.data);
        buf.append(" field=" + (this.m_field != null ? this.m_field.getFieldId() : null));
        buf.append(" class=" + (this.m_field != null ? this.m_field.getClass() : null));
        buf.append("]");
        return buf.toString();
    }
}

