/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.servletfilter.helper;

import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.security.SimplePrincipal;
import org.eclipse.scout.rt.server.commons.servletfilter.FilterConfigInjection;
import org.eclipse.scout.rt.server.commons.servletfilter.security.SecureHttpServletRequestWrapper;

public class DevelopmentAuthFilter
implements Filter {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(DevelopmentAuthFilter.class);
    private FilterConfigInjection m_injection;
    private boolean m_showWarning = true;

    public void init(FilterConfig config0) throws ServletException {
        this.m_injection = new FilterConfigInjection(config0, this.getClass());
    }

    public void destroy() {
        this.m_injection = null;
    }

    public void doFilter(ServletRequest in, ServletResponse out, FilterChain chain) throws IOException, ServletException {
        if (this.isSubjectSet() || !Platform.inDevelopmentMode()) {
            chain.doFilter(in, out);
            return;
        }
        FilterConfigInjection.FilterConfig config = this.m_injection.getConfig(in);
        if (!config.isActive()) {
            chain.doFilter(in, out);
            return;
        }
        Subject subject = this.createDevelopmentSubject(this.m_showWarning);
        this.m_showWarning = false;
        if (subject == null) {
            chain.doFilter(in, out);
            return;
        }
        this.continueChainWithPrincipal(subject, (HttpServletRequest)in, (HttpServletResponse)out, chain);
    }

    private boolean isSubjectSet() {
        Subject subject = Subject.getSubject(AccessController.getContext());
        return subject != null;
    }

    protected Subject createDevelopmentSubject(boolean showWarning) {
        if (showWarning) {
            LOG.warn("+++Development security: Create Subject based on System.getProperty('user.name')");
        }
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new SimplePrincipal(System.getProperty("user.name")));
        return subject;
    }

    private void continueChainWithPrincipal(Subject subject, final HttpServletRequest req, final HttpServletResponse res, final FilterChain chain) throws IOException, ServletException {
        try {
            Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    Principal principal = Subject.getSubject(AccessController.getContext()).getPrincipals().iterator().next();
                    SecureHttpServletRequestWrapper secureReq = new SecureHttpServletRequestWrapper(req, principal);
                    chain.doFilter((ServletRequest)secureReq, (ServletResponse)res);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            throw new ServletException(t);
        }
    }
}

