/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.scheduler.internal.node;

import org.eclipse.scout.rt.server.scheduler.internal.node.AbstractNode;
import org.eclipse.scout.rt.server.scheduler.internal.node.INode;
import org.eclipse.scout.rt.server.scheduler.internal.visitor.IEvalVisitor;
import org.eclipse.scout.rt.server.scheduler.internal.visitor.IFormatVisitor;

public abstract class AbstractOperation
extends AbstractNode
implements INode {
    private INode m_leftCmd;
    private INode m_rightCmd;

    public AbstractOperation(INode leftCmd, INode rightCmd) {
        this.m_leftCmd = leftCmd;
        this.m_rightCmd = rightCmd;
    }

    public INode getLeftSide() {
        return this.m_leftCmd;
    }

    public INode getRightSide() {
        return this.m_rightCmd;
    }

    @Override
    public void format(IFormatVisitor v) {
        this.m_leftCmd.format(v);
        v.print(" ");
        this.formatOpImpl(v);
        v.print(" ");
        this.m_rightCmd.format(v);
    }

    @Override
    public Object eval(IEvalVisitor v) {
        return this.evalImpl(v, this.m_leftCmd.eval(v), this.m_rightCmd.eval(v));
    }

    public abstract void formatOpImpl(IFormatVisitor var1);

    public abstract Object evalImpl(IEvalVisitor var1, Object var2, Object var3);
}

