/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.clientnotification.internal;

import java.util.WeakHashMap;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.services.common.clientnotification.IClientNotificationFilter;
import org.eclipse.scout.rt.server.services.common.clientnotification.IClientNotificationQueueElement;
import org.eclipse.scout.rt.server.services.common.clientnotification.internal.ClientNotificationQueueElement;
import org.eclipse.scout.rt.shared.services.common.clientnotification.IClientNotification;

public class ConsumableClientNotificationQueueElement
extends ClientNotificationQueueElement
implements IClientNotificationQueueElement {
    private static final long serialVersionUID = 5831131193589383447L;
    private final Object m_consumedBySessionsLock = new Object();
    private WeakHashMap<IServerSession, Object> m_consumedBySessions;

    public ConsumableClientNotificationQueueElement(IClientNotification notification, IClientNotificationFilter filter) {
        super(notification, filter);
    }

    public boolean isConsumable(IServerSession serverSession) {
        return this.isActive() && !this.isConsumedBy(serverSession) && this.m_filter.accept();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isConsumedBy(IServerSession session) {
        if (session == null) {
            return false;
        }
        Object object = this.m_consumedBySessionsLock;
        synchronized (object) {
            if (this.m_consumedBySessions != null) {
                return this.m_consumedBySessions.containsKey(session);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConsumedBy(IServerSession session) {
        if (session != null) {
            Object object = this.m_consumedBySessionsLock;
            synchronized (object) {
                if (this.m_consumedBySessions == null) {
                    this.m_consumedBySessions = new WeakHashMap();
                }
                this.m_consumedBySessions.put(session, null);
            }
        }
    }
}

