/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.session;

import javax.security.auth.Subject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.server.IServerJobFactory;
import org.eclipse.scout.rt.server.IServerJobService;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ITransactionRunnable;
import org.eclipse.scout.rt.server.services.common.session.IServerSessionRegistryService;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.eclipse.scout.service.AbstractService;
import org.eclipse.scout.service.SERVICES;
import org.osgi.framework.Bundle;

public class ServerSessionRegistryService
extends AbstractService
implements IServerSessionRegistryService {
    private final IServerJobService m_backendService = (IServerJobService)SERVICES.getService(IServerJobService.class);

    protected IServerJobService getBackendService() {
        return this.m_backendService;
    }

    @Override
    public <T extends IServerSession> T newServerSession(Class<T> clazz, Subject subject) throws ProcessingException {
        return this.newServerSession(clazz, subject, UserAgent.createDefault());
    }

    @Override
    public <T extends IServerSession> T newServerSession(Class<T> clazz, Subject subject, UserAgent userAgent) throws ProcessingException {
        IServerSession serverSession = this.createSessionInstance(clazz);
        serverSession.setUserAgent(userAgent);
        IServerJobFactory jobFactory = this.getBackendService().createJobFactory(serverSession, subject);
        this.runLoadSessionJob(serverSession, jobFactory);
        return (T)serverSession;
    }

    protected <T extends IServerSession> IServerSession createSessionInstance(Class<T> clazz) throws ProcessingException {
        IServerSession serverSession;
        try {
            serverSession = (IServerSession)clazz.newInstance();
        }
        catch (Throwable t) {
            throw new ProcessingException("create instance of " + clazz, t);
        }
        return serverSession;
    }

    protected void runLoadSessionJob(final IServerSession serverSession, IServerJobFactory jobFactory) throws ProcessingException {
        jobFactory.runNow("loading session " + serverSession.getClass().getSimpleName(), new ITransactionRunnable(){

            @Override
            public IStatus run(IProgressMonitor monitor) throws ProcessingException {
                String symbolicName = serverSession.getClass().getPackage().getName();
                Bundle bundle = Platform.getBundle((String)symbolicName);
                serverSession.loadSession(bundle);
                return Status.OK_STATUS;
            }
        });
    }
}

