/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.model;

import java.io.Serializable;
import java.security.Permission;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.beans.AbstractPropertyObserver;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.data.model.DataModelAttributeInjector;
import org.eclipse.scout.rt.shared.data.model.DataModelConstants;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttributeOp;
import org.eclipse.scout.rt.shared.data.model.IDataModelEntity;
import org.eclipse.scout.rt.shared.extension.AbstractSerializableExtension;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.eclipse.scout.rt.shared.extension.data.model.DataModelAttributeChains;
import org.eclipse.scout.rt.shared.extension.data.model.IDataModelAttributeExtension;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.common.security.IAccessControlService;
import org.eclipse.scout.rt.shared.services.lookup.ICodeLookupCallFactoryService;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractDataModelAttribute
extends AbstractPropertyObserver
implements IDataModelAttribute,
DataModelConstants,
Serializable,
IExtensibleObject {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractDataModelAttribute.class);
    private static final long serialVersionUID = 1L;
    private String m_id;
    private String m_text;
    private int m_type;
    private double m_order;
    private List<? extends IDataModelAttributeOp> m_operators;
    private int[] m_aggregationTypes;
    private String m_iconId;
    private boolean m_allowNullOperator;
    private boolean m_allowNotOperator;
    private boolean m_aggregationEnabled;
    private Class<? extends ICodeType> m_codeTypeClass;
    private ILookupCall<?> m_lookupCall;
    private Permission m_visiblePermission;
    private boolean m_visibleGranted;
    private boolean m_visibleProperty;
    private boolean m_visible;
    private boolean m_activeFilterEnabled;
    private IDataModelEntity m_parentEntity;
    private final ObjectExtensions<AbstractDataModelAttribute, IDataModelAttributeExtension<? extends AbstractDataModelAttribute>> m_objectExtensions = new ObjectExtensions(this);

    public AbstractDataModelAttribute() {
        this(true);
    }

    public AbstractDataModelAttribute(boolean callInitConfig) {
        if (callInitConfig) {
            this.callInitializer();
        }
    }

    protected final void callInitializer() {
        this.interceptInitConfig();
    }

    protected double calculateViewOrder() {
        double viewOrder = this.getConfiguredViewOrder();
        Class<?> cls = this.getClass();
        if (viewOrder == 9.876543212345678E16) {
            while (cls != null && IDataModelAttribute.class.isAssignableFrom(cls)) {
                if (cls.isAnnotationPresent(Order.class)) {
                    Order order = cls.getAnnotation(Order.class);
                    return order.value();
                }
                cls = cls.getSuperclass();
            }
        }
        return viewOrder;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=10.0)
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=20.0)
    protected String getConfiguredText() {
        return null;
    }

    @ConfigProperty(value="LOOKUP_CALL")
    @Order(value=30.0)
    protected Class<? extends ILookupCall<?>> getConfiguredLookupCall() {
        return null;
    }

    @ConfigProperty(value="CODE_TYPE")
    @Order(value=40.0)
    protected Class<? extends ICodeType<?, ?>> getConfiguredCodeType() {
        return null;
    }

    @ConfigProperty(value="COMPOSER_ATTRIBUTE_TYPE")
    @Order(value=70.0)
    protected int getConfiguredType() {
        return 15;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=90.0)
    protected boolean getConfiguredNullOperatorEnabled() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=100.0)
    protected boolean getConfiguredNotOperatorEnabled() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=105.0)
    protected boolean getConfiguredAggregationEnabled() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=110.0)
    protected boolean getConfiguredVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=120.0)
    protected boolean getConfiguredActiveFilterEnabled() {
        return false;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=130.0)
    protected double getConfiguredViewOrder() {
        return 9.876543212345678E16;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execInitAttribute() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execPrepareLookup(ILookupCall<?> call) throws ProcessingException {
    }

    @Override
    public Map<String, String> getMetaDataOfAttribute() {
        return null;
    }

    protected final void interceptInitConfig() {
        this.m_objectExtensions.initConfig(this.createLocalExtension(), new Runnable(){

            @Override
            public void run() {
                AbstractDataModelAttribute.this.initConfig();
            }
        });
    }

    protected void initConfig() {
        Class<ILookupCall<?>> lsCls;
        this.m_visibleGranted = true;
        this.setNotOperatorEnabled(this.getConfiguredNotOperatorEnabled());
        this.setNullOperatorEnabled(this.getConfiguredNullOperatorEnabled());
        this.setAggregationEnabled(this.getConfiguredAggregationEnabled());
        this.setIconId(this.getConfiguredIconId());
        this.setText(this.getConfiguredText());
        this.setType(this.getConfiguredType());
        this.setVisible(this.getConfiguredVisible());
        this.setActiveFilterEnabled(this.getConfiguredActiveFilterEnabled());
        this.setOrder(this.calculateViewOrder());
        if (this.getConfiguredCodeType() != null) {
            this.setCodeTypeClass(this.getConfiguredCodeType());
        }
        if ((lsCls = this.getConfiguredLookupCall()) != null) {
            try {
                ILookupCall<?> call = lsCls.newInstance();
                this.setLookupCall(call);
            }
            catch (Exception e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + lsCls.getName() + "'.", (Throwable)e));
            }
        }
        this.injectOperators();
        this.injectAggregationTypes();
    }

    public final List<? extends IDataModelAttributeExtension<? extends AbstractDataModelAttribute>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    protected IDataModelAttributeExtension<? extends AbstractDataModelAttribute> createLocalExtension() {
        return new LocalDataModelAttributeExtension<AbstractDataModelAttribute>(this);
    }

    @Override
    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return this.m_objectExtensions.getExtension(c);
    }

    protected void injectOperators() {
        new DataModelAttributeInjector().injectOperators(this);
    }

    protected void injectAggregationTypes() {
        new DataModelAttributeInjector().injectAggregationTypes(this);
    }

    @Override
    public final void initAttribute() throws ProcessingException {
        this.interceptInitAttribute();
    }

    @Override
    public void prepareLookup(ILookupCall<?> call) throws ProcessingException {
        this.interceptPrepareLookup(call);
    }

    public double getOrder() {
        return this.m_order;
    }

    public void setOrder(double order) {
        this.m_order = order;
    }

    @Override
    public String getText() {
        return this.m_text;
    }

    @Override
    public void setText(String s) {
        this.m_text = s;
    }

    @Override
    public int getType() {
        return this.m_type;
    }

    @Override
    public void setType(int i) {
        this.m_type = i;
    }

    @Override
    public String getIconId() {
        return this.m_iconId;
    }

    @Override
    public void setIconId(String s) {
        this.m_iconId = s;
    }

    @Override
    public List<IDataModelAttributeOp> getOperators() {
        return CollectionUtility.arrayList(this.m_operators);
    }

    @Override
    public void setOperators(List<? extends IDataModelAttributeOp> ops) {
        this.m_operators = CollectionUtility.arrayList(ops);
    }

    @Override
    public int[] getAggregationTypes() {
        return this.m_aggregationTypes != null ? this.m_aggregationTypes : new int[]{};
    }

    @Override
    public void setAggregationTypes(int[] aggregationTypes) {
        this.m_aggregationTypes = aggregationTypes;
    }

    @Override
    public boolean containsAggregationType(int agType) {
        if (this.m_aggregationTypes == null) {
            return false;
        }
        int[] nArray = this.m_aggregationTypes;
        int n = this.m_aggregationTypes.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (i == agType) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isNullOperatorEnabled() {
        return this.m_allowNullOperator;
    }

    @Override
    public void setNullOperatorEnabled(boolean b) {
        this.m_allowNullOperator = b;
    }

    @Override
    public boolean isAggregationEnabled() {
        return this.m_aggregationEnabled;
    }

    @Override
    public void setAggregationEnabled(boolean aggregationEnabled) {
        this.m_aggregationEnabled = aggregationEnabled;
        if (this.m_aggregationTypes != null) {
            this.injectAggregationTypes();
        }
    }

    @Override
    public boolean isNotOperatorEnabled() {
        return this.m_allowNotOperator;
    }

    @Override
    public void setNotOperatorEnabled(boolean b) {
        this.m_allowNotOperator = b;
    }

    @Override
    public Class<? extends ICodeType<?, ?>> getCodeTypeClass() {
        return this.m_codeTypeClass;
    }

    @Override
    public void setCodeTypeClass(Class<? extends ICodeType<?, ?>> codeTypeClass) {
        this.m_codeTypeClass = codeTypeClass;
        this.m_lookupCall = null;
        if (this.m_codeTypeClass != null) {
            this.m_lookupCall = ((ICodeLookupCallFactoryService)SERVICES.getService(ICodeLookupCallFactoryService.class)).newInstance(this.m_codeTypeClass);
        }
    }

    @Override
    public ILookupCall<Object> getLookupCall() {
        return this.m_lookupCall;
    }

    @Override
    public void setLookupCall(ILookupCall<?> call) {
        this.m_lookupCall = call;
    }

    @Override
    public Permission getVisiblePermission() {
        return this.m_visiblePermission;
    }

    @Override
    public void setVisiblePermission(Permission p) {
        this.setVisiblePermissionInternal(p);
        boolean b = p != null ? ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).checkPermission(p) : true;
        this.setVisibleGranted(b);
    }

    protected void setVisiblePermissionInternal(Permission p) {
        this.m_visiblePermission = p;
    }

    @Override
    public boolean isVisibleGranted() {
        return this.m_visibleGranted;
    }

    @Override
    public void setVisibleGranted(boolean b) {
        this.m_visibleGranted = b;
        this.calculateVisible();
    }

    @Override
    public boolean isVisible() {
        return this.m_visible;
    }

    @Override
    public void setVisible(boolean b) {
        this.setVisibleProperty(b);
        this.calculateVisible();
    }

    protected void setVisibleProperty(boolean b) {
        this.m_visibleProperty = b;
    }

    protected boolean isVisibleProperty() {
        return this.m_visibleProperty;
    }

    @Override
    public void setActiveFilterEnabled(boolean active) {
        this.m_activeFilterEnabled = active;
    }

    @Override
    public boolean isActiveFilterEnabled() {
        return this.m_activeFilterEnabled;
    }

    @Override
    public IDataModelEntity getParentEntity() {
        return this.m_parentEntity;
    }

    public void setParentEntity(IDataModelEntity parent) {
        this.m_parentEntity = parent;
    }

    private void calculateVisible() {
        this.m_visible = this.m_visibleGranted && this.m_visibleProperty;
    }

    @Override
    public boolean isMultiValued() {
        switch (this.getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String formatValue(Object rawValue) {
        if (rawValue == null) {
            return this.formatNullValue();
        }
        switch (this.getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 16: {
                return this.formatSmart(rawValue, this.getCodeTypeClass(), this.getLookupCall());
            }
            case 5: {
                return this.formatDate(rawValue, true, false);
            }
            case 7: {
                return this.formatDate(rawValue, true, true);
            }
            case 6: {
                return this.formatDate(rawValue, false, true);
            }
            case 8: {
                return this.formatInteger(rawValue, true);
            }
            case 9: {
                return this.formatLong(rawValue, true);
            }
            case 10: {
                return this.formatDouble(rawValue, true, false);
            }
            case 11: {
                return this.formatInteger(rawValue, false);
            }
            case 12: {
                return this.formatLong(rawValue, false);
            }
            case 13: {
                return this.formatDouble(rawValue, false, false);
            }
            case 14: {
                return this.formatDouble(rawValue, true, true);
            }
            case 15: 
            case 18: {
                return this.formatString(rawValue);
            }
        }
        return this.formatObject(rawValue);
    }

    protected String formatNullValue() {
        return null;
    }

    protected String formatDate(Object rawValue, boolean hasDate, boolean hasTime) {
        Date value = (Date)TypeCastUtility.castValue((Object)rawValue, Date.class);
        DateFormat df = null;
        df = hasDate && !hasTime ? DateFormat.getDateInstance(2, LocaleThreadLocal.get()) : (!hasDate && hasTime ? DateFormat.getTimeInstance(3, LocaleThreadLocal.get()) : DateFormat.getDateTimeInstance(3, 3, LocaleThreadLocal.get()));
        df.setLenient(true);
        return df.format(value);
    }

    protected String formatDouble(Object rawValue, boolean groupingUsed, boolean percent) {
        Double value = (Double)TypeCastUtility.castValue((Object)rawValue, Double.class);
        NumberFormat fmt = null;
        fmt = percent ? NumberFormat.getPercentInstance(LocaleThreadLocal.get()) : NumberFormat.getNumberInstance(LocaleThreadLocal.get());
        if (fmt instanceof DecimalFormat) {
            ((DecimalFormat)fmt).setMultiplier(1);
        }
        fmt.setMinimumFractionDigits(2);
        fmt.setMaximumFractionDigits(2);
        fmt.setGroupingUsed(groupingUsed);
        return fmt.format(value);
    }

    protected String formatInteger(Object rawValue, boolean groupingUsed) {
        Integer value = (Integer)TypeCastUtility.castValue((Object)rawValue, Integer.class);
        NumberFormat fmt = NumberFormat.getNumberInstance(LocaleThreadLocal.get());
        fmt.setMinimumFractionDigits(0);
        fmt.setMaximumFractionDigits(0);
        fmt.setGroupingUsed(groupingUsed);
        return fmt.format(value);
    }

    protected String formatLong(Object rawValue, boolean groupingUsed) {
        Long value = (Long)TypeCastUtility.castValue((Object)rawValue, Long.class);
        NumberFormat fmt = NumberFormat.getNumberInstance(LocaleThreadLocal.get());
        fmt.setMinimumFractionDigits(0);
        fmt.setMaximumFractionDigits(0);
        fmt.setGroupingUsed(groupingUsed);
        return fmt.format(value);
    }

    protected String formatSmart(Object rawValue, Class<? extends ICodeType<?, ?>> codeTypeClass, ILookupCall<?> lookupCall) {
        ILookupCall<Object> call;
        if (codeTypeClass == null && lookupCall == null) {
            return null;
        }
        if (codeTypeClass != null) {
            call = ((ICodeLookupCallFactoryService)SERVICES.getService(ICodeLookupCallFactoryService.class)).newInstance(codeTypeClass);
        } else if (lookupCall instanceof LookupCall) {
            call = (ILookupCall)((LookupCall)lookupCall).clone();
        } else {
            return null;
        }
        call.setKey(rawValue);
        call.setText(null);
        call.setAll(null);
        call.setRec(null);
        try {
            List<ILookupRow<Object>> result = call.getDataByKey();
            if (result.size() == 1) {
                return result.get(0).getText();
            }
            if (result.size() > 1) {
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < result.size()) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(result.get(i).getText());
                    ++i;
                }
                return sb.toString();
            }
        }
        catch (ProcessingException e) {
            LOG.warn("Execution of lookup call failed", (Throwable)e);
        }
        return "";
    }

    protected String formatString(Object rawValue) {
        return (String)TypeCastUtility.castValue((Object)rawValue, String.class);
    }

    protected String formatObject(Object rawValue) {
        return rawValue.toString();
    }

    protected final void interceptInitAttribute() throws ProcessingException {
        List<? extends IDataModelAttributeExtension<? extends AbstractDataModelAttribute>> extensions = this.getAllExtensions();
        DataModelAttributeChains.DataModelAttributeInitAttributeChain chain = new DataModelAttributeChains.DataModelAttributeInitAttributeChain(extensions);
        chain.execInitAttribute();
    }

    protected final void interceptPrepareLookup(ILookupCall<?> call) throws ProcessingException {
        List<? extends IDataModelAttributeExtension<? extends AbstractDataModelAttribute>> extensions = this.getAllExtensions();
        DataModelAttributeChains.DataModelAttributePrepareLookupChain chain = new DataModelAttributeChains.DataModelAttributePrepareLookupChain(extensions);
        chain.execPrepareLookup(call);
    }

    protected static class LocalDataModelAttributeExtension<OWNER extends AbstractDataModelAttribute>
    extends AbstractSerializableExtension<OWNER>
    implements IDataModelAttributeExtension<OWNER> {
        private static final long serialVersionUID = 1L;

        public LocalDataModelAttributeExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execInitAttribute(DataModelAttributeChains.DataModelAttributeInitAttributeChain chain) throws ProcessingException {
            ((AbstractDataModelAttribute)this.getOwner()).execInitAttribute();
        }

        @Override
        public void execPrepareLookup(DataModelAttributeChains.DataModelAttributePrepareLookupChain chain, ILookupCall<?> call) throws ProcessingException {
            ((AbstractDataModelAttribute)this.getOwner()).execPrepareLookup(call);
        }
    }
}

