/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.ui;

import java.io.Serializable;
import org.eclipse.scout.rt.shared.Activator;
import org.eclipse.scout.rt.shared.ui.DefaultUserAgentParser;
import org.eclipse.scout.rt.shared.ui.IUiDeviceType;
import org.eclipse.scout.rt.shared.ui.IUiLayer;
import org.eclipse.scout.rt.shared.ui.IUserAgentParser;
import org.eclipse.scout.rt.shared.ui.UiDeviceType;
import org.eclipse.scout.rt.shared.ui.UiLayer;

public final class UserAgent
implements Serializable {
    private static final long serialVersionUID = 6194949468393137650L;
    private String m_uiDeviceId;
    private IUiLayer m_uiLayer;
    private IUiDeviceType m_uiDeviceType;

    private UserAgent(IUiLayer uiLayer, IUiDeviceType uiDeviceType, String uiDeviceId) {
        if (uiLayer == null || uiDeviceType == null || uiDeviceId == null) {
            throw new IllegalArgumentException("Arguments must not be null.");
        }
        this.m_uiLayer = uiLayer;
        this.m_uiDeviceType = uiDeviceType;
        this.m_uiDeviceId = uiDeviceId;
    }

    public IUiDeviceType getUiDeviceType() {
        return this.m_uiDeviceType;
    }

    public IUiLayer getUiLayer() {
        return this.m_uiLayer;
    }

    public String getUiDeviceId() {
        return this.m_uiDeviceId;
    }

    public void setUiDeviceId(String uiDeviceId) {
        this.m_uiDeviceId = uiDeviceId;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        UserAgent otherUserAgent = (UserAgent)other;
        boolean equal = otherUserAgent.getUiDeviceType().equals(this.getUiDeviceType());
        equal &= otherUserAgent.getUiLayer().equals(this.getUiLayer());
        return equal &= otherUserAgent.getUiDeviceId().equals(this.getUiDeviceId());
    }

    public int hashCode() {
        int hash = 17 + this.getUiLayer().hashCode();
        hash = hash * 17 + this.getUiDeviceType().hashCode();
        hash = hash * 17 + this.getUiDeviceId().hashCode();
        return hash;
    }

    public String toString() {
        return this.createIdentifier();
    }

    public String createIdentifier() {
        return this.createIdentifier(new DefaultUserAgentParser());
    }

    public String createIdentifier(IUserAgentParser parser) {
        return parser.createIdentifier(this);
    }

    public static UserAgent create(IUiLayer uiLayer, IUiDeviceType uiDeviceType) {
        String osName = Activator.getDefault().getBundle().getBundleContext().getProperty("org.osgi.framework.os.name");
        return new UserAgent(uiLayer, uiDeviceType, osName);
    }

    public static UserAgent create(IUiLayer uiLayer, IUiDeviceType uiDeviceType, String uiDeviceId) {
        return new UserAgent(uiLayer, uiDeviceType, uiDeviceId);
    }

    public static UserAgent createDefault() {
        return UserAgent.create(UiLayer.UNKNOWN, UiDeviceType.UNKNOWN);
    }

    public static UserAgent createByIdentifier(IUserAgentParser parser, String userAgent) {
        return parser.parseIdentifier(userAgent);
    }

    public static UserAgent createByIdentifier(String userAgent) {
        return UserAgent.createByIdentifier(new DefaultUserAgentParser(), userAgent);
    }
}

