/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.validate;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.rt.shared.validate.checks.IValidateCheck;

public interface IValidationStrategy {
    public boolean accept(IValidateCheck var1);

    public static class NO_CHECK
    implements IValidationStrategy {
        @Override
        public boolean accept(IValidateCheck check) {
            return false;
        }
    }

    public static class PROCESS
    implements IValidationStrategy {
        @Override
        public boolean accept(IValidateCheck check) {
            return true;
        }
    }

    public static class QUERY
    implements IValidationStrategy {
        private Set<String> m_accept = new HashSet<String>(Arrays.asList("maxLength", "codeValue", "lookupValue", "regexMatch"));

        @Override
        public boolean accept(IValidateCheck check) {
            return this.m_accept.contains(check.getCheckId());
        }
    }
}

