/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.validate.checks;

import java.util.regex.Pattern;
import org.eclipse.scout.rt.shared.validate.ValidationUtility;
import org.eclipse.scout.rt.shared.validate.checks.IValidateCheck;

public class RegexMatchCheck
implements IValidateCheck {
    public static final String ID = "regexMatch";
    private Pattern m_pat;

    public RegexMatchCheck(String pattern) {
        this(Pattern.compile(pattern, 34));
    }

    public RegexMatchCheck(Pattern pat) {
        this.m_pat = pat;
    }

    @Override
    public String getCheckId() {
        return ID;
    }

    @Override
    public boolean accept(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            return true;
        }
        return obj.getClass() == String[].class;
    }

    @Override
    public void check(Object obj) throws Exception {
        if (obj.getClass().isArray()) {
            ValidationUtility.checkRegexMatchArray(obj, this.m_pat);
        } else {
            ValidationUtility.checkRegexMatchValue(obj, this.m_pat);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.m_pat.pattern();
    }
}

