/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client.config.entity;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.shared.TEXTS;
import org.eclipse.scout.rt.spec.client.config.entity.AbstractEntityTableConfig;
import org.eclipse.scout.rt.spec.client.gen.extract.DescriptionExtractor;
import org.eclipse.scout.rt.spec.client.gen.extract.IDocTextExtractor;
import org.eclipse.scout.rt.spec.client.gen.extract.LinkableTypeExtractor;
import org.eclipse.scout.rt.spec.client.gen.extract.form.field.FormFieldBooleanPropertyExtractor;
import org.eclipse.scout.rt.spec.client.gen.extract.form.field.FormFieldLabelExtractor;
import org.eclipse.scout.rt.spec.client.gen.extract.form.field.FormFieldPropertyExtractor;

public class DefaultFormFieldTableConfig
extends AbstractEntityTableConfig<IFormField> {
    private boolean m_hierarchicLabels;

    public DefaultFormFieldTableConfig() {
        this(true);
    }

    public DefaultFormFieldTableConfig(boolean hierarchicLabels) {
        this.m_hierarchicLabels = hierarchicLabels;
    }

    @Override
    public List<IDocTextExtractor<IFormField>> getTextExtractors() {
        ArrayList<IDocTextExtractor<IFormField>> extractors = new ArrayList<IDocTextExtractor<IFormField>>();
        extractors.add(new FormFieldLabelExtractor(this.m_hierarchicLabels, this.getFilters()));
        extractors.add(new DescriptionExtractor());
        extractors.add(new FormFieldPropertyExtractor("tooltipText", TEXTS.get((String)"org.eclipse.scout.rt.spec.tooltip")));
        extractors.add(new FormFieldBooleanPropertyExtractor("mandatory", TEXTS.get((String)"org.eclipse.scout.rt.spec.mandatory")));
        extractors.add(new FormFieldBooleanPropertyExtractor("enabled", TEXTS.get((String)"org.eclipse.scout.rt.spec.enabled")));
        extractors.add(new FormFieldPropertyExtractor("maxLength", TEXTS.get((String)"org.eclipse.scout.rt.spec.length")));
        extractors.add(new LinkableTypeExtractor());
        return extractors;
    }

    @Override
    public String getTitle() {
        return TEXTS.get((String)"org.eclipse.scout.rt.spec.fields");
    }
}

