/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client.out.html;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.mediawiki.core.MediaWikiLanguage;
import org.eclipse.scout.commons.exception.ProcessingException;

public class HtmlConverter {
    private static final String ENCODING = "utf-8";
    private final HtmlDocumentBuilder.Stylesheet m_css;

    public HtmlConverter(File css) {
        this.m_css = new HtmlDocumentBuilder.Stylesheet(css);
    }

    public void convertWikiToHtml(File in, File out) throws ProcessingException {
        try {
            BufferedWriter htmlWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(out.getPath()), ENCODING));
            HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)htmlWriter);
            builder.addCssStylesheet(this.m_css);
            builder.setUseInlineStyles(false);
            builder.setEncoding(ENCODING);
            MarkupParser parser = new MarkupParser((MarkupLanguage)new MediaWikiLanguage());
            parser.setBuilder((DocumentBuilder)builder);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(in.getPath()), ENCODING));
            parser.parse((Reader)reader);
            htmlWriter.flush();
            htmlWriter.close();
        }
        catch (FileNotFoundException e) {
            throw new ProcessingException("Could not convert document to html", (Throwable)e);
        }
        catch (IOException e) {
            throw new ProcessingException("Could not convert document to html", (Throwable)e);
        }
    }
}

