/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client.out.mediawiki;

public final class MediawikiUtility {
    private static final String[] ESCAPE_LIST = new String[]{"[", "]", "=", "*", "----", "#", "{", "--~"};

    private MediawikiUtility() {
    }

    public static String transformToWiki(Object text) {
        if (text == null) {
            return "";
        }
        return MediawikiUtility.escapeWiki(text.toString());
    }

    private static String escapeWiki(String input) {
        String res = input;
        String[] stringArray = ESCAPE_LIST;
        int n = ESCAPE_LIST.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            res = res.replace(s, "<nowiki>" + s + "</nowiki>");
            ++n2;
        }
        return res;
    }

    public static String createLink(String id, String name) {
        StringBuilder sb = new StringBuilder();
        sb.append("[[").append(id).append("|").append(name).append("]]");
        return sb.toString();
    }

    public static String createAnchor(String id) {
        return "{{a:" + id + "}}";
    }

    public static String removeAnchorsAndLinks(String input) {
        input = input.replaceAll("\\{\\{[^}]+}}", "");
        input = input.replaceAll("\\[\\[([A-Za-z][A-Za-z0-9_\\$\\.-]+)\\|(.*?)]]", "$2");
        return input;
    }

    public static String createImageLink(String imagePath) {
        return "[[Image:" + imagePath + "]]";
    }

    public static String createImageLink(String imagePath, int scale) {
        return "[[Image:" + imagePath + "|" + scale + "px]]";
    }
}

