/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client.utility;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.spec.client.config.ConfigRegistry;
import org.osgi.framework.Bundle;

public final class SpecIOUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SpecIOUtility.class);
    public static final String ENCODING = "utf-8";

    private SpecIOUtility() {
    }

    public static String[] getRelativePaths(File[] files, File baseDir) {
        ArrayList<String> pathList = new ArrayList<String>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String relative = SpecIOUtility.getReleativePath(baseDir, f);
            pathList.add(relative);
            ++n2;
        }
        return (String[])CollectionUtility.toArray(pathList, String.class);
    }

    public static String getReleativePath(File baseDir, File f) {
        return baseDir.toURI().relativize(f.toURI()).getPath();
    }

    public static String[] addPrefix(String[] files, String pathPrefix) {
        String[] pathList = new String[files.length];
        int i = 0;
        while (i < files.length) {
            pathList[i] = String.valueOf(pathPrefix) + files[i];
            ++i;
        }
        return pathList;
    }

    public static File createNewFile(File directory, String baseName, String fileExtension) throws ProcessingException {
        directory.mkdirs();
        File file = new File(directory, String.valueOf(baseName) + fileExtension);
        try {
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            return file;
        }
        catch (IOException e) {
            throw new ProcessingException("Error creating file.", (Throwable)e);
        }
    }

    public static Writer createWriter(File file) throws ProcessingException {
        try {
            FileOutputStream outputStream = new FileOutputStream(file.getPath(), true);
            return new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, ENCODING));
        }
        catch (IOException e) {
            throw new ProcessingException("Error writing mediawiki file.", (Throwable)e);
        }
    }

    public static Properties loadProperties(File file) throws ProcessingException {
        Properties prop = new Properties();
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(file);
            prop.load(inStream);
            Properties properties = prop;
            return properties;
        }
        catch (FileNotFoundException e) {
            throw new ProcessingException("Error loading property file", (Throwable)e);
        }
        catch (IOException e) {
            throw new ProcessingException("Error loading property file", (Throwable)e);
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void copyFile(Bundle bundle, String path, File destFile) throws ProcessingException {
        if (destFile.getParentFile() != null && !destFile.getParentFile().exists()) {
            destFile.getParentFile().mkdirs();
        }
        Channel sourceChannel = null;
        AbstractInterruptibleChannel destChannel = null;
        FileOutputStream out = null;
        try {
            try {
                InputStream stream = FileLocator.openStream((Bundle)bundle, (IPath)new Path(path), (boolean)true);
                sourceChannel = Channels.newChannel(stream);
                out = new FileOutputStream(destFile);
                destChannel = out.getChannel();
                long maxBytes = 1000000L;
                ((FileChannel)destChannel).transferFrom((ReadableByteChannel)sourceChannel, 0L, 1000000L);
            }
            catch (IOException e) {
                throw new ProcessingException("Failed to copy.", (Throwable)e);
            }
        }
        finally {
            if (sourceChannel != null) {
                try {
                    sourceChannel.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (destChannel != null) {
                try {
                    destChannel.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void copy(File source, File dest) throws ProcessingException {
        FileChannel sourceChannel = null;
        AbstractInterruptibleChannel destChannel = null;
        try {
            try {
                sourceChannel = new FileInputStream(source).getChannel();
                destChannel = new FileOutputStream(dest).getChannel();
                ((FileChannel)destChannel).transferFrom(sourceChannel, 0L, sourceChannel.size());
            }
            catch (FileNotFoundException e) {
                throw new ProcessingException("Error copying file", (Throwable)e);
            }
            catch (IOException e) {
                throw new ProcessingException("Error copying file", (Throwable)e);
            }
        }
        finally {
            if (sourceChannel != null) {
                try {
                    sourceChannel.close();
                }
                catch (IOException iOException) {}
            }
            if (destChannel != null) {
                try {
                    destChannel.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void replaceAll(File in, final Map<String, String> m) throws ProcessingException {
        SpecIOUtility.process(in, new IStringProcessor(){

            @Override
            public String processLine(String input) {
                return SpecIOUtility.replaceAll(input, (Map<String, String>)m);
            }
        });
    }

    public static void process(File file, IStringProcessor processor) throws ProcessingException {
        FileReader reader = null;
        OutputStreamWriter writer = null;
        BufferedReader br = null;
        File temp = new File(file.getParent(), String.valueOf(file.getName()) + "_temp");
        try {
            try {
                String line;
                reader = new FileReader(file);
                writer = new FileWriter(temp);
                br = new BufferedReader(reader);
                while ((line = br.readLine()) != null) {
                    String repl = processor.processLine(line);
                    writer.write(repl);
                    writer.write(System.getProperty("line.separator"));
                }
            }
            catch (FileNotFoundException e) {
                throw new ProcessingException("Error processing file", (Throwable)e);
            }
            catch (IOException e) {
                throw new ProcessingException("Error processing file", (Throwable)e);
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
        SpecIOUtility.copy(temp, file);
        temp.delete();
    }

    private static String replaceAll(String s, Map<String, String> m) {
        for (Map.Entry<String, String> e : m.entrySet()) {
            s = s.replaceAll(e.getKey(), e.getValue());
        }
        return s;
    }

    public static List<String> listFiles(Bundle bundle, String path, FilenameFilter filter) throws ProcessingException {
        if (!path.endsWith(File.separator)) {
            path = String.valueOf(path) + File.separator;
        }
        URL bundleRoot = bundle.getEntry("/");
        URI resolvedBundleUri = null;
        URL resolvedBundleUrl = null;
        try {
            resolvedBundleUrl = FileLocator.resolve((URL)bundleRoot);
            resolvedBundleUri = resolvedBundleUrl.toURI();
        }
        catch (URISyntaxException e) {
            throw new ProcessingException("Error reading directory", (Throwable)e);
        }
        catch (IOException e) {
            throw new ProcessingException("Error reading directory", (Throwable)e);
        }
        if ("jar".equals(resolvedBundleUri.getScheme())) {
            return SpecIOUtility.listFilesBinary(path, resolvedBundleUrl, filter);
        }
        if ("file".equals(resolvedBundleUri.getScheme())) {
            return SpecIOUtility.listFilesSource(path, resolvedBundleUri, filter);
        }
        throw new ProcessingException("Error reading directory");
    }

    private static List<String> listFilesSource(String relativePath, URI resolvedFileBundleUri, FilenameFilter filter) {
        ArrayList<String> fileNames = new ArrayList<String>();
        File bundleRoot = new File(resolvedFileBundleUri);
        File dir = new File(bundleRoot, relativePath);
        File[] files = dir.listFiles(filter);
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile()) {
                    fileNames.add(file.getName());
                }
                ++n2;
            }
        } else {
            LOG.debug("Could not read directory: " + dir.getPath());
        }
        return fileNames;
    }

    private static List<String> listFilesBinary(String relativePath, URL resolvedBinaryBundleUrl, FilenameFilter filter) throws ProcessingException {
        ArrayList<String> list = new ArrayList<String>();
        ZipInputStream jis = null;
        try {
            try {
                ZipEntry entry;
                JarURLConnection connection = (JarURLConnection)resolvedBinaryBundleUrl.openConnection();
                File jarFile = new File(connection.getJarFileURL().toURI());
                jis = new JarInputStream(new FileInputStream(jarFile));
                while ((entry = ((JarInputStream)jis).getNextEntry()) != null) {
                    String name = entry.getName().replace("/", File.separator);
                    if (!name.startsWith(relativePath) || name.substring(relativePath.length()).length() <= 0 || name.substring(relativePath.length()).contains(File.separator) || !filter.accept(null, name.substring(relativePath.length()))) continue;
                    list.add(name.substring(relativePath.length()));
                }
            }
            catch (FileNotFoundException e) {
                throw new ProcessingException("Error reading directory", (Throwable)e);
            }
            catch (IOException e) {
                throw new ProcessingException("Error reading directory", (Throwable)e);
            }
            catch (URISyntaxException e) {
                throw new ProcessingException("Error reading directory", (Throwable)e);
            }
        }
        finally {
            if (jis != null) {
                try {
                    jis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return list;
    }

    public static Properties loadLinkPropertiesFile() throws ProcessingException {
        Properties p = new Properties();
        try {
            p.load(new FileReader(ConfigRegistry.getSpecFileConfigInstance().getLinksFile()));
        }
        catch (FileNotFoundException e) {
            throw new ProcessingException("Error loading links file", (Throwable)e);
        }
        catch (IOException e) {
            throw new ProcessingException("Error loading links file", (Throwable)e);
        }
        return p;
    }

    public static void copyFilesFromAllSourceBundles(File destDir, String bundleRelativeSourceDirPath, FilenameFilter filenameFilter) throws ProcessingException {
        for (Bundle bundle : ConfigRegistry.getSpecFileConfigInstance().getSourceBundles()) {
            for (String file : SpecIOUtility.listFiles(bundle, bundleRelativeSourceDirPath, filenameFilter)) {
                File destFile = new File(destDir, file);
                SpecIOUtility.copyFile(bundle, String.valueOf(bundleRelativeSourceDirPath) + File.separator + file, destFile);
            }
        }
    }

    public static interface IStringProcessor {
        public String processLine(String var1);
    }
}

