/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.testing.client;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.testing.shared.WaitCondition;
import org.eclipse.scout.testing.client.IGuiMock;

public abstract class AbstractGuiMock
implements IGuiMock {
    private IClientSession m_session;

    protected AbstractGuiMock(IClientSession session) {
        this.setClientSession(session);
    }

    @Override
    public <T> T invokeScoutAndWait(final WaitCondition<T> r, long startTimeout, long runTimeout) throws Throwable {
        final long deadLine = startTimeout > 0L ? System.nanoTime() + startTimeout : -1L;
        final AtomicReference<Object> ret = new AtomicReference<Object>(null);
        final AtomicReference<Object> throwables = new AtomicReference<Object>(null);
        ClientSyncJob eclipseJob = new ClientSyncJob(r.toString(), this.getClientSession()){

            protected void runVoid(IProgressMonitor monitor) {
                if (deadLine < 0L || deadLine > System.nanoTime()) {
                    try {
                        ret.set(r.run());
                    }
                    catch (Throwable e) {
                        throwables.set(e);
                    }
                }
            }
        };
        eclipseJob.schedule();
        try {
            eclipseJob.join(runTimeout);
            Throwable t = throwables.get();
            if (t != null) {
                throw t;
            }
            this.waitForIdle();
            return ret.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IClientSession getClientSession() {
        return this.m_session;
    }

    public void setClientSession(IClientSession session) {
        this.m_session = session;
    }
}

