/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.testing.client.servicetunnel.http;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.IClientSession;

public class MultiClientAuthenticator
extends Authenticator {
    private static final Map<String, String> USER_PASSWORDS = new HashMap<String, String>();
    private static final Map<IClientSession, String> LOGIN_INFOS = new WeakHashMap<IClientSession, String>();
    private static String s_defaultUser;

    public static void setDefaultUser(String username) {
        s_defaultUser = username;
    }

    public static void addUser(String username, String password) {
        USER_PASSWORDS.put(username, password);
    }

    public static void assignSessionToUser(IClientSession clientSession, String username) {
        LOGIN_INFOS.put(clientSession, username);
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        IClientSession currentSession = ClientJob.getCurrentSession();
        String user = LOGIN_INFOS.get(currentSession);
        if (user == null) {
            user = s_defaultUser;
        }
        if (user == null) {
            return null;
        }
        String password = USER_PASSWORDS.get(user);
        return new PasswordAuthentication(user, password == null ? null : password.toCharArray());
    }
}

